$('#tutorial').on('click', function () {
    $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#DadosGerais').hasClass('show'));
                    $('#DadosGerais').collapse('show');
                }
            },
        });

        driver.defineSteps([{
            element: '#geral',
            popover: {
                title: 'Cadastro Geral',
                description: 'Clique aqui para abrir a aba de cadastro Geral.',
                position: 'top'
            }
        },
        {
            element: '#DadosGerais',
            popover: {
                title: 'Dados de Cadastro Geral',
                description: 'Esses são os campos que você informará os dados gerais de cadastro.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtTabelaPreco',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#dataIni',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#dataFim',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#divProduto',
            popover: {
                title: 'Incluir Produto',
                description: 'Aqui você pode incluir um produto.',
                position: 'top'
            }
        },
        {
            element: '#tipos',
            popover: {
                title: 'Tipo',
                description: 'Aqui você seleciona o tipo de regra.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Ao clicar nesse botão você grava os dados inseridos.',
                position: 'left'
            }
        }
        ]);

        driver.start();
    });
});


$(document).ready(async function () {
    componenteFiltro('servico', false, false)
    componenteFiltro('grupoMA', false, false, 'Grupo')
    let objRegraConsumo = {}
    let ordemAlteracao = ''

    $('#tabelaCalculo').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        scrollY: '205px',
        "columns": [
            {
                'title': 'Ordem',
                'data': 'ordem'
            },
            {
                'title': 'Descrição',
                'data': 'descricao'
            },
            {
                'title': 'Parâmetro',
                'data': 'parametro'
            }
        ],
        columnDefs: [
            {
                render(data, type, row) {
                    return retornaBotaoOpcoesTabelaCalculo(data, row);
                },
                targets: 0,
            },
        ]
    });

    $('#tabelaCalculoItens').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        scrollY: '205px',
        "columns": [
            // {
            //     'title': 'Ação',
            //     'data': 'ACAO'
            // },
            {
                'title': 'Ordem',
                'data': 'ordem'
            },
            {
                'title': 'Largura Inicial',
                'data': 'paramInicial'
            },
            {
                'title': 'Largura Final',
                'data': 'paramFinal'
            },
            {
                'title': 'resultado',
                'data': 'resultado'
            }
        ]
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let regra = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/regra_cortina`;
    });

    $("#checkDescPromo, #checkValorPromo").on("change", function () {
        $("#txtValorAdd").val("");
        $("#txtValorAdd").maskMoney('destroy');
        $("#txtValorAdd").maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });
    })

    // $('#msform').validate({
    //     debug: false,
    //     ignore: "",
    //     // rules: {
    //     //     txtDescricao: { required: true, },
    //     //     txtTabelaPreco: { required: true, },
    //     //     dataIni: { required: true, },
    //     //     dataFim: { required: true, },
    //     // },
    //     // messages: {
    //     //     txtDescricao: { required: 'Descrição inválida.', },
    //     //     txtTabelaPreco: { required: 'Tabela de preço inválida.', },
    //     //     dataIni: { required: 'Data inicial inválida.', },
    //     //     dataFim: { required: 'Data final inválida.', },
    //     // },
    //     errorElement: 'span',
    //     errorPlacement(error, element) {
    //         error.addClass('invalid-feedback');
    //         element.closest('.form-group').append(error);
    //     },
    //     highlight(element) {
    //         $(element).addClass('is-invalid');
    //     },
    //     unhighlight(element) {
    //         $(element).removeClass('is-invalid');
    //     },
    $('#btnGravar').on('click', async function (event) {
        event.preventDefault();
        if (!$('#txtDescricao').val()) {
            return msgAlerta('Necessário informar uma descrição. Por favor, verifique!')
        }
        // async submitHandler(form, event) {
        try {
            $.LoadingOverlay("show");
            objRegraConsumo.codigo = $('#txtCodigo').val()
            objRegraConsumo.descricao = $('#txtDescricao').val()
            objRegraConsumo.arredondamento = $('#cbArredondamento').is(':checked') ? 'S' : 'N'
            objRegraConsumo.grupo = pegaChave('#txtGrupo')
            objRegraConsumo.fichaTecnica = 'C'
            objRegraConsumo.tipoRegra = 'T'
            objRegraConsumo.multiRegra = 'N'
            try {
                const response = await requisicao('POST', `/sisplan/regra_cortina/v1/regra?`, ``, JSON.stringify(objRegraConsumo), 90000);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.mensagem);
                    return;
                }


                toastr.success(
                    `Cadastro efetuado com sucesso! Regra: ${objRegraConsumo.codigo}`,
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/regra_cortina`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px"
                });
            } catch (error) {
                msgErro(`Não foi possível gravar os dados da regra`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
        // }
    })

    async function buscaDados() {
        $.LoadingOverlay('show')
        try {
            const response = await requisicao('GET', `/sisplan/regra_cortina/v1/regra?`, `CODIGO=${regra}`);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }

            return jsonStr
        } catch (error) {

        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#cbAplicaParametros').on('change', function () {
        if ($(this).is(':checked')) {
            $('#divCalculo').removeClass('d-none')
            // $('#fieldTabelaCalculo').addClass('d-none')
        } else {
            $('#divCalculo').addClass('d-none')
            // $('#fieldTabelaCalculo').removeClass('d-none')
        }
    })

    $('#selectTipoRegra').on('change', function () {
        if ($(this).val() == 'T') {
            $('#fieldTabelaCalculo').removeClass('d-none')
            // $('#divCalculo').removeClass('d-none')
            // $('#fieldTabelaCalculo').addClass('d-none')
        } else {
            $('#fieldTabelaCalculo').addClass('d-none')
            // $('#divCalculo').addClass('d-none')
        }
    })

    if (regra != '' && regra != 'create') {
        try {
            $.LoadingOverlay('show');
            try {
                buscaDados().then((result) => {
                    objRegraConsumo = result
                    $('#txtCodigo').val(regra);
                    $('#txtDescricao').val(result.descricao);
                    $('#cbArredondamento').prop('checked', result.arredondamento == 'S');
                    insereValor('#txtGrupo', result.grupo, { tabela: 'GRUPO_MA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: result.grupo })
                    addTabelas(result.tabelas)
                })
            } catch (error) {
                console.error(error);
                msgErro('Erro ao retornar os dados da regra.');
            }
        } finally {
            $.LoadingOverlay('hide');
            $('#txtTabelaPreco').trigger('blur')
        }
    } else {
        $('#txtCodigo').val(await RetornaProximo('CODIGO', 'REGRA_CONSUMO', 'CODIGO'));
    }

    $('#btnIncluir').on('click', async function () {
        if (!$('#txtDescricaoCalculo').val()) {
            return msgAlerta('Necessário informar uma descrição. Por favor, verifique!')
        }

        if (!$('#selectParametro').val()) {
            return msgAlerta('Necessário informar um parâmetro. Por favor, verifique!')
        }
        const ordem = ordemAlteracao ? ordemAlteracao : $('#tabelaCalculo').DataTable().rows().count() + 1
        adicionaTabelaCalculo(
            ordem,
            $('#txtDescricaoCalculo').val(),
            $('#selectParametro').val(),
            ordem
        );
        limpaCamposTabela()
    });

    function limpaCamposTabela() {
        $('#txtDescricaoCalculo').val('')
        $('#selectParametro').val('(LARGURA_ITEM)')
    }

    aplicaMascara()
    $('#btnIncluirItem').on('click', async function () {
        if (!$('#txtParamInicial').val()) {
            return msgAlerta('Necessário informar um parâmetro inicial. Por favor, verifique!')
        }

        if (!$('#txtParamFinal').val()) {
            return msgAlerta('Necessário informar um parâmetro final. Por favor, verifique!')
        }
        if (!$('#txtServico').val()) {
            return msgAlerta('Necessário informar um serviço. Por favor, verifique!')
        }

        const tabelaCalculo = $('#tabelaCalculo').DataTable().row('.selected').data()

        adicionaCalculoItem(
            $('#tabelaCalculoItens').DataTable().rows().count() + 1,
            $('#txtParamInicial').val(),
            $('#txtParamFinal').val(),
            pegaChave('#txtServico'),
            tabelaCalculo.tabela,
        );

        limpaCamposCalculo()
    });

    function limpaCamposCalculo() {
        $('#txtParamInicial').val('')
        $('#txtParamFinal').val('')
        $('#txtServico').val('')
    }

    $('#modalCalculo').on('hide.bs.modal', function () {
        limpaCamposCalculo()
    })

    $('#btnRemover').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            $('#tabela-produtos').DataTable().rows().remove().draw(false);

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    function addTabelas(tabelas) {
        try {
            $('#tabelaCalculo').DataTable({
                paging: false,
                filter: false,
                info: false,
                order: true,
                destroy: true,
                scrollY: '205px',
                data: tabelas,
                "columns": [
                    {
                        'title': 'Ordem',
                        'data': 'ordem'
                    },
                    {
                        'title': 'Descrição',
                        'data': 'descricao'
                    },
                    {
                        'title': 'Parâmetro',
                        'data': 'parametro'
                    }
                ],
                columnDefs: [
                    {
                        render(data, type, row) {
                            return retornaBotaoOpcoesTabelaCalculo(data, row);
                        },
                        targets: 0,
                    },
                ]
            });

            $("#tabelaCalculo tbody").on("click", "tr", async function () {
                $("#tabelaCalculo tbody tr td")[0].click();
                $("#tabelaCalculo tbody tr.selected").removeClass("selected");
                $(this).addClass("selected");

                // setTimeout(async () => { await buscaCalculoItens() }, 100)
            });

            setTimeout(() => { $("#tabelaCalculo").DataTable().columns.adjust().draw(false); }, 200)
            setTimeout(async () => { $("#tabelaCalculo tbody tr td")[0].click() }, 100)

        } catch (error) {
            console.error(error);
        }
    }

    $("#tabelaCalculo tbody").on("click", "tr", async function () {
        $("#tabelaCalculo tbody tr td")[0].click();
        $("#tabelaCalculo tbody tr.selected").removeClass("selected");
        $(this).addClass("selected");

        // setTimeout(async () => { await buscaCalculoItens() }, 100)
    });

    async function buscaCalculoItens(ordem) {
        if ($.fn.DataTable.isDataTable('#tabelaCalculoItens')) {
            $('#tabelaCalculoItens').DataTable().destroy();
            $('#tabelaCalculoItens').empty();
        };

        try {
            const item = objRegraConsumo.tabelas.find(item => item.ordem === ordem);
            const calculos = item?.calculos;

            // if (!calculos || calculos.length === 0) {
            //     return;
            // }

            $('#tabelaCalculoItens').DataTable({
                paging: false,
                filter: false,
                info: false,
                order: true,
                destroy: true,
                scrollY: '205px',
                data: calculos,
                "columns": [
                    {
                        'title': 'Ação',
                        'data': 'ACAO'
                    },
                    {
                        'title': 'Ordem',
                        'data': 'ordem'
                    },
                    {
                        'title': 'Param. Inicial',
                        'data': 'paramInicial'
                    },
                    {
                        'title': 'Params. Final',
                        'data': 'paramFinal'
                    },
                    {
                        'title': 'Resultado',
                        'data': 'resultado'
                    }
                ],
                columnDefs: [
                    {
                        render(data, type, row) {
                            return retornaBotaoOpcoesItem(data, row);
                        },
                        targets: 0,
                    },
                ]
            });

            setTimeout(() => {
                $("#tabelaCalculoItens").DataTable().columns.adjust().draw(false);
            }, 200)

        } catch (error) {
            console.error('Erro ao buscar cálculos:', error);
        }
    }


    function adicionaTabelaCalculo(ordem, descricao, parametro, tabela) {
        try {
            const dados = $('#tabelaCalculo').DataTable().rows().data().toArray()
            const table = $('#tabelaCalculo').DataTable();
            const indiceEncontrado = dados.findIndex(e =>
                // e.descricao === descricao &&
                e.ordem === ordem &&
                e.parametro === parametro
            )
            if (indiceEncontrado !== -1) {
                const dadosIndice = $('#tabelaCalculo').DataTable().row(indiceEncontrado).data()
                // dadosIndice[5] = parseFloat(dadosIndice[5]) + 1

                table.row(indiceEncontrado).data({
                    ordem: $(dadosIndice.ordem).find('button').length > $ ? (dadosIndice.ordem).find('button').first().html().trim() : dadosIndice.ordem,
                    descricao: $('#txtDescricaoCalculo').val(),
                    parametro: $('#selectParametro').val(),
                    regra: $('#txtCodigo').val(),
                    tabela: dadosIndice.tabela,
                }).draw(false).node();

                objRegraConsumo = { ...objRegraConsumo.tabelas[ordem], tabelas: table.data() }

            } else {
                const item = {
                    ordem: ordem,
                    descricao: descricao,
                    parametro: parametro,
                    regra: $('#txtCodigo').val(),
                    tabela: tabela
                }
                table.row.add(item).draw(false);

                if (objRegraConsumo.tabelas) {
                    objRegraConsumo.tabelas.push(item);
                } else {
                    objRegraConsumo.tabelas = [item];
                }
            }
        } finally {
            ordemAlteracao = ''
        }
    }

    function adicionaCalculoItem(ordem, paramInicial, paramFinal, resultado, tabela) {
        const item = {
            acao: retornaBotaoOpcoesItem(),
            regra: $('#txtCodigo').val(),
            ordem: ordem,
            paramInicial: paramInicial,
            paramFinal: paramFinal,
            resultado: resultado,
            tabela: tabela,
        }
        $('#tabelaCalculoItens').DataTable().row.add(item).draw(false);
    }

    $('.collapse').on('shown.bs.collapse', function (e) {
        let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

        clicked
            .parent()
            .find(".fa-angle-right")
            .removeClass("fa-angle-right")
            .addClass("fa-angle-down");
    })
        .on('hidden.bs.collapse', function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    function retornaBotaoOpcoesTabelaCalculo(data) {
        var retorno = '<div style="text-align:start;" class="mx-1"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu" style="max-height: 250px; overflow: scroll;scrollbar-gutter: stable; overflow-inline: auto;"> ' +
            '    <button class="dropdown-item" type="button" title="Visualizar Cálculo" id="btnVisualizarCalculo">Visualizar Cálculo</button>     ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    };

    function retornaBotaoOpcoesItem() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:white"></span></button>  ' +
            '   </div>';
    };

    $('#tabelaCalculoItens').on('click', '.btn-excluir', async function () {
        const dataTable = $('#tabelaCalculoItens').DataTable();

        dataTable.rows($(this).closest('tr')).remove();

        const tabela = dataTable.data().toArray();

        tabela.forEach((item, i) => {
            item.ordem = i + 1;
        });

        dataTable.clear().rows.add(tabela).draw(false);
    });

    $('#tabelaCalculo').on('click', '#btnEditar', async function () {
        const data = $('#tabelaCalculo').DataTable().row($(this).parents('tr')).data();
        ordemAlteracao = data.ordem
        editaCamposCalculo(
            data.descricao,
            data.parametro,
        )
    });

    function atualizarTabelaRegras() {
        const table = $('#tabelaCalculo').DataTable();

        table.clear();

        if (objRegraConsumo.tabelas && objRegraConsumo.tabelas.length > 0) {
            table.rows.add(objRegraConsumo.tabelas);
        }

        table.draw(false);
    }

    function reindexarTabelas() {
        if (objRegraConsumo.tabelas && objRegraConsumo.tabelas.length > 0) {
            objRegraConsumo.tabelas.forEach((item, index) => {
                item.ordem = index + 1;
            });
        }
    }

    $('#tabelaCalculo').on('click', '#btnExcluir', function () {
        try {
            const data = $("#tabelaCalculo").DataTable().row($(this).parents('tr')).data();
            $('#tabelaCalculo').DataTable().row($(this).parents('tr')).remove().draw(false);

            const index = objRegraConsumo.tabelas.toArray().findIndex(item => item.ordem === data.ordem);

            if (index !== undefined && index !== -1) {
                objRegraConsumo.tabelas.splice(index, 1);
                reindexarTabelas();
                atualizarTabelaRegras();
            }
        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível realizar a exclusão: ${e}`);
        }
    });

    $('#tabelaCalculo').on('click', '#btnVisualizarCalculo', async function () {
        const data = $('#tabelaCalculo').DataTable().row($(this).parents('tr')).data();
        await buscaCalculoItens(data.ordem)
        $('#modalCalculo').modal('show');
    });

    async function editaCamposCalculo(descricao, parametro) {
        $('#txtDescricaoCalculo').val(descricao)
        $('#txtParametro').val(parametro)
    }

    $('#btnConfirmarCalculo').on('click', async function () {
        const data = $('#tabelaCalculo').DataTable().row('.selected').data();
        const tabelaCalculos = $('#tabelaCalculoItens').DataTable().rows().data().toArray();

        if (objRegraConsumo.tabelas) {
            const item = objRegraConsumo.tabelas.find(item => item.ordem === data.ordem);
            if (item) {
                const calculosProcessados = tabelaCalculos.map((calculo) => {
                    const calculoProcessado = { ...calculo };

                    if (calculoProcessado.hasOwnProperty('paramInicial')) {
                        const valorInicial = parseFloat(calculoProcessado.paramInicial);
                        calculoProcessado.paramInicial = isNaN(valorInicial) ? 0 : TruncaDecimaisNova(3, valorInicial);
                    }

                    if (calculoProcessado.hasOwnProperty('paramFinal')) {
                        const valorFinal = parseFloat(calculoProcessado.paramFinal);
                        calculoProcessado.paramFinal = isNaN(valorFinal) ? 0 : TruncaDecimaisNova(3, valorFinal);
                    }

                    return calculoProcessado;
                });

                item.calculos = calculosProcessados;
            }
        }
    });

    aplicaMascara()
    function aplicaMascara() {
        $(".camposMascara").maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $(".camposMascara").on('blur', function () {
            if (($(this).val() == '0.00') || ($(this).val() == '')) {
                $(this).val('0.00');
            }
        });
    }
});