$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          if (pegaChave('#txtNumero') == '') {
            insereValor('#txtNumero', ' ', ' ')
          };
          if (pegaChave('#txtCliente') == '') {
            insereValor('#txtCliente', ' ', ' ')
          };
          if (pegaChave('#txtRepresentante') == '') {
            insereValor('#txtRepresentante', ' ', ' ')
          };

          $('#avancar1').trigger('click');
        }
        else if ((Element.node.id == 'avancarComercial')) {
          if (pegaChave('#txtTabelaPreco') == '') {
            insereValor('#txtTabelaPreco', ' ', ' ')
          };
          $('#avancarComercial').trigger('click');
        }
        else if ((Element.node.id == 'avancarItens')) {
          if (pegaChave('#txtDeposito') == '') {
            insereValor('#txtDeposito', ' ', ' ')
          };
          if (pegaChave('#txtStatus') == '') {
            insereValor('#txtStatus', ' ', ' ')
          };
          $('#avancarItens').trigger('click');
        }
        else if ((Element.node.id == 'avancarFinanceiro')) {
          if (pegaChave('#txtTabelaPreco') == '') {
            insereValor('#txtTabelaPreco', ' ', ' ')
          };
          if (pegaChave('#txtMoeda') == '') {
            insereValor('#txtMoeda', ' ', ' ')
          };
          $('#avancarFinanceiro').trigger('click');
        }
        else if ((Element.node.id == 'avancarPagamento')) {
          $('#avancarPagamento').trigger('click');
        }
        else if ((Element.node.id == 'gravar')) {
          $('.driver-next-btn').on('click', location.reload());
        };
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'VoltarGeral') {
          $('#VoltarGeral').trigger('click');
        }
        else if (Element.node.id == 'voltarComercial') {
          $('#voltarComercial').trigger('click');
        }
        else if (Element.node.id == 'ultimoVoltar') {
          $('#ultimoVoltar').trigger('click');
        }
        else if (Element.node.id == 'voltarItens') {
          $('#voltarItens').trigger('click');
        }
      }
    });

    driver.defineSteps([{
      element: '#tourGeral',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os dados gerais do pedido.',
        position: 'top'
      }
    },
    {
      element: '#txtCliente',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtRepresentante',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#avancar1',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para avançar para a aba Comercial.',
        position: 'left'
      }
    },
    {
      element: '#VoltarGeral',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a aba Geral.',
        position: 'left'
      }
    },
    {
      element: '#tourComercial',
      popover: {
        title: 'Comercial',
        description: 'Aqui estão os dados comerciais do pedido.',
        position: 'left'
      }
    },
    {
      element: '#checkPrecoManual',
      popover: {
        title: 'Preço Manual',
        description: 'Opção para definir a tabela de preço como 999, neste caso é informado o preço manualmente no item.',
        position: 'top'
      }
    },
    {
      element: '#txtTabelaPreco',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#avancarComercial',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para avançar para a aba Informações.',
        position: 'left'
      }
    },
    {
      element: '#voltarComercial',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a aba Comercial.',
        position: 'left'
      }
    },
    {
      element: '#financeiroFs',
      popover: {
        title: 'Informações',
        description: 'Aqui estão demais dados do pedido.',
        position: 'top'
      }
    },
    {
      element: '#txtDeposito',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtStatus',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#avancarItens',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para avançar para a aba Itens.',
        position: 'left'
      }
    },
    {
      element: '#ultimoVoltar',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a aba Informações.',
        position: 'left'
      }
    },
    {
      element: '#tabelaItens_wrapper',
      popover: {
        title: 'Itens',
        description: 'Aqui estão os itens do pedido.',
        position: 'top'
      }
    },
    {
      element: '#btnAdicionar',
      popover: {
        title: 'Botão Adicionar',
        description: 'Clique aqui para inserir itens.',
        position: 'top'
      }
    },
    {
      element: '#avancarPagamento',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para avançar para a aba Pagamento.',
        position: 'top'
      }
    },
    {
      element: '#voltarItens',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a aba Itens.',
        position: 'left'
      }
    },
    {
      element: '#tourFinanceiro',
      popover: {
        title: 'Pagamento',
        description: 'Aqui estão os dados de pagamento.',
        position: 'top'
      }
    },
    {
      element: '#txtCondPagto1',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtMoeda',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnLimpar',
      popover: {
        title: 'Botão Limpar',
        description: 'Clique aqui para limpar o grid das condições.',
        position: 'top'
      }
    },
    {
      element: '#btnAtualizar',
      popover: {
        title: 'Botão Atualizar',
        description: 'Clique aqui para atualizar as condições de pagamento. Irá criar as condições com os dados informados nos campos: "Nr. Parcelas", "Intervalo de Dias" e "1º Vencimento"',
        position: 'top'
      }
    },
    {
      element: '#tabelaCondicao',
      popover: {
        title: 'Condições',
        description: 'Aqui estão as condições de pagamento do pedido.',
        position: 'top'
      }
    },
    {
      element: '#gravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar o pedido.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});

async function reqRetornaDesconto(desconto) {
  try {
    const url = "/sisplan/pedido/v1/descpedido?";
    const response = await requisicao(
      "GET",
      url,
      `DESCONTO=${desconto}&CODCLI=${pegaChave('#txtCliente')}`,
      null
    );

    if (!response) {
      return;
    }
    if (response.status != 200) {
      msgErro(response.mensagem);
      return 0;
    }

    const jsonStr = await response.json();

    if (!jsonStr) return 0

    return jsonStr;
  } catch (error) {
    console.error(error);
  }
}

$(document).ready(async function () {

  const listaBarrasLog = []

  let currentFs, nextFs, previousFs, opacity;

  const paramsPedido = await BuscaParametrosPedido()
  const somarFreteCondicoes = paramsPedido[10].VALOR == '1';
  const bReserva = paramsPedido[13].VALOR == '1';
  const parametrosSistema = await BuscaParametrosSistema('S');
  let quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
  const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;
  let temCondicaoEntidade = false;

  const parametroObrigaResponsavel = await CopiaParametro('PEDIDO', 8);
  const bParamLote = paramsPedido[17].VALOR == '1';
  const bAlteraDataEmissao = paramsPedido[18].VALOR == '0';
  const bBloqueiaNumeroPedido = paramsPedido[22].VALOR == '0';
  const utilizaBarraLog = parametrosSistema[0].VALOR != 0;
  const apenasBarraLog = parametrosSistema[0].VALOR == 2;
  let camposObrigatorios = await retornaCamposObrigatorios('pedido');


  let existeStatusTipoPed = false
  await pesquisaStatusTipoPed()
  await verificaRegraStatusPedidoInclusao()
  await deletaReservaProduto();

  const botaoDinamico = {
    targets: [0],
    funcao: (data, type, row) => { return retornaOpcoes(data); }
  }


  function retornaOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Alterar" id="btn-alterar">Alterar</button>  ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  }

  await adicionaPaginacao();
  adicionaValidacoes();
  adicionaMascaraCampos();
  await adicionaPesquisaAutocompleta();
  criaDataTablePadrao('#tabelaItens', false, false, false, true, true, true, '400px', null, null, [9, 12, 13, 14, 15, 16, 17], [], [], [8], botaoDinamico, quantidadeCasasDecimaisCampo, '', '', false, [], [7]);
  criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px', null, null, [], [], [], [5]);

  const BuscaPorCorETam = (await CopiaParametro('PEDIDO', 0));
  const statusLibComercial = (await CopiaParametro('PEDIDO', 1));
  const statusLibFinanceiro = (await CopiaParametro('PEDIDO', 2));
  const bloqueiaPedidoNovamente = (await CopiaParametro('PEDIDO', 6));
  const bConsideraQtdePendentePedido = (await CopiaParametro('PEDIDO', 3)) == 1;
  const bBloqueiaAlterarPreco = (await CopiaParametro('PEDIDO', 4)) == 0;
  const bBloqueiaAddItemSemPreco = (await CopiaParametro('PEDIDO', 5)) == 1;
  const bUtilizaIndice = (await CopiaParametro("FATURAMENTO", 3)) == '1';

  await adicionaEmpresas();
  await setaDatas();
  await validaEdicao();


  if (paramsPedido) {
    switch (paramsPedido[7].VALOR) {
      case '0':
        $('#cbRegraPromocao').prop('checked', false)
        $('#divRegraPromocao').removeClass('d-flex')
        $('#divRegraPromocao').addClass('d-none')
        break;
      case '1':
        $('#cbRegraPromocao').prop('checked', false)
        $('#cbRegraPromocao').prop('disabled', false)
        $('#divRegraPromocao').addClass('d-flex')
        $('#divRegraPromocao').removeClass('d-none')
        break;
      case '2':
        $('#cbRegraPromocao').prop('checked', true)
        $('#cbRegraPromocao').prop('disabled', false)
        $('#divRegraPromocao').addClass('d-flex')
        $('#divRegraPromocao').removeClass('d-none')
        break;
      case '3':
        $('#cbRegraPromocao').prop('checked', true)
        $('#cbRegraPromocao').prop('disabled', true)
        $('#divRegraPromocao').addClass('d-flex')
        $('#divRegraPromocao').removeClass('d-none')
        break;
      default:
        break;
    }
  }

  if (bConsideraQtdePendentePedido) {
    $('#divQtdeEstoque').prop('title', '(Quantidade Estoque) - (Quantidade Pendente Pedidos)');
  };

  if (bUtilizaIndice) {
    $('#divIndice').removeClass('d-none');

    $('#divComRec').removeClass('col-lg-3');
    $('#divComRec').addClass('col-lg-2');

    $('#divComFat').removeClass('col-lg-3');
    $('#divComFat').addClass('col-lg-2');
  }

  $('#txtNumero').on('blur', async function () {
    const sNumero = $('#txtNumero').val();
    if (sNumero == '') {
      $('#txtNumero').val(await RetornaProximo('PEDIDO', 'PEDIDO', 'NUMERO', 5));
      bloqueiaCampoNumero();
    } else if (await validaPedidoExistente(sNumero)) {
      window.location.href = btoa(sNumero);
    } else {
      msgAlerta('Número de pedido inexistente, favor verificar.');
      $('#txtNumero').focus();
    }
  });

  $('#txtCliente').on('blur', async function () {
    if ($(window.location.href.split('/')).get(-1) != 'create') {
      return;
    }
    const cliente = pegaChave('#txtCliente');
    if (cliente == '') {
      return;
    }
    await buscaDadosCliente(cliente);
  });

  $('#btnAdicionar').on('click', function () {
    if (bParamLote) {
      $('#modalItemLote').modal('show');
    } else {
      $('#modalItem').modal('show');
    }
  });

  $('#modalItemLote').on('shown.bs.modal', async function () {
    if ($.fn.DataTable.isDataTable('#tabelaItensLote')) {
      $('#tabelaItensLote').DataTable().destroy();
      $('#tabelaItensLote').empty();
    };

    limpaValor('#txtProdutoLote');
    limpaValor('#txtLoteConsulta');
    limpaValor('#txtDepositoLote');
    limpaValor('#txtValorLote');

    insereValor('#txtDepositoLote', pegaValor('#txtDeposito'));
    $('#txtLoteConsulta').focus();
  });

  $('#txtProdutoLote, #txtDepositoLote, #txtLoteConsulta').on('blur', async function () {
    if ($.fn.DataTable.isDataTable('#tabelaItensLote')) {
      $('#tabelaItensLote').DataTable().destroy();
      $('#tabelaItensLote').empty();
    };

    let produto = pegaChave('#txtProdutoLote');
    const deposito = pegaChave('#txtDepositoLote');
    const lote = pegaValor('#txtLoteConsulta');
    const qualidade = pegaValor('#rgQualidade');

    if ((produto == '') && (lote == '')) {
      return;
    }

    const dados = await retornaLotes(produto, deposito, lote, qualidade);

    if (produto == '') {
      produto = pegaChave('#txtProdutoLote');
    }

    const preco = await retornaPrecoProduto(pegaChave('#txtTabelaPreco'), produto);

    insereValor('#txtValorLote', preco);

    if (dados.length == 0) {
      msgAlerta('Nenhum lote com quantidade em estoque para esse produto/depósito filtrado, favor verificar.');
      return;
    }

    preencheTabelaLotes(dados);
  });

  $('#rgQualidade').on('change', async function () {
    if ($.fn.DataTable.isDataTable('#tabelaItensLote')) {
      $('#tabelaItensLote').DataTable().destroy();
      $('#tabelaItensLote').empty();
    };

    let produto = pegaChave('#txtProdutoLote');
    const deposito = pegaChave('#txtDepositoLote');
    const lote = pegaValor('#txtLoteConsulta');
    const qualidade = pegaValor('#rgQualidade');

    if ((produto == '') && (lote == '')) {
      return;
    }

    const dados = await retornaLotes(produto, deposito, lote, qualidade);

    if (produto == '') {
      produto = pegaChave('#txtProdutoLote');
    }

    const preco = await retornaPrecoProduto(pegaChave('#txtTabelaPreco'), produto);

    insereValor('#txtValorLote', preco);

    if (dados.length == 0) {
      msgAlerta('Nenhum lote com quantidade em estoque para esse produto/depósito filtrado, favor verificar.');
      return;
    }

    preencheTabelaLotes(dados);
  });

  $('#btnAtualizar').on('click', function () {
    const numeroParcelas = $('#txtNrParcelas').val();
    const intervaloDias = $('#txtIntervaloDias').val();
    const dtPrimeiroVencto = $('#dtPrimeiroVencto').val();

    if (numeroParcelas == '') {
      msgAlerta('O número de parcelas não foi preenchido. Não é possível continuar!')
      return
    }
    if (intervaloDias == '') {
      msgAlerta('Intervalo de dias não foi preenchido. Não é possível continuar!')
      return
    }
    if (dtPrimeiroVencto == '') {
      msgAlerta('O primeiro dia de vencimento da parcela não foi preenchido. Não é possível continuar!')
      return
    }

    geraCondicoes();
  });

  $('#btnLimpar').on('click', function () {
    limparTabelaCondicoes();
    limparCamposCondicoes();
    limparCamposDias();
    $('#dtPrimeiroVencto').val(new Date().toISOString().slice(0, 10));
    $('#txtCondicao').val('');
    $('#txtNrParcelas').prop('disabled', false);
    $('#txtIntervaloDias').prop('disabled', false);

    $('#txtMoeda').trigger('blur');
    atualizaValorCondicaoTotal();
  });

  $('#avancarPagamento').on('click', function () {
    retornaTotal();
  });

  $('#txtDesconto1').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto2').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto3').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto4').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto5').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto6').on('blur', function () {
    retornaTotal();
  });

  $('#checkPrecoManual').on('click', function () {
    handleClickCheckPrecoManual()
  });

  function handleClickCheckPrecoManual() {
    $('#txtTabelaPreco').prop('disabled', $('#checkPrecoManual').prop('checked'));
    $('#txtTabelaPreco').prop('readonly', $('#checkPrecoManual').prop('checked'));
    $('#btn-limpa-TabelaPreco').prop('disabled', $('#checkPrecoManual').prop('checked'));
    $('#btn-limpa-TabelaPreco').prop('readonly', $('#checkPrecoManual').prop('checked'));
    $('#btn-TabelaPreco').prop('disabled', $('#checkPrecoManual').prop('checked'));
    $('#btn-TabelaPreco').prop('readonly', $('#checkPrecoManual').prop('checked'));
    if ($('#checkPrecoManual').prop('checked')) {
      insereValor('#txtTabelaPreco', '999', 'Manual');
    } else {
      $('#txtTabelaPreco').val('');
    }
  }

  $('#tabelaItens').on('click', '#btn-excluir', async function () {
    try {
      const data = $("#tabelaItens").DataTable().row($(this).parents('tr')).data();

      if (await Existe('PEDIDO3', ['NUMERO', 'CODIGO', 'COR', 'TAM'], [$('#txtNumero').val(), data[0], data[2], data[4]])) {
        msgErro('Item possui expedição, impossível continuar.');
        return;
      }
      $('#tabelaItens').DataTable().row($(this).parents('tr')).remove().draw(false);
      removeBarrasBipadas(data[0], data[2], data[4])
      await atualizaValorTotalPedido();
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível realizar a exclusão: ${e}`);
    }
  });

  $('#txtAlterarPreco').on('input', function () {
    if (($(this).val()).split('.')[1]?.length > 4) {
      $(this).val(($(this).val()).slice(0, -1));
    }
  })

  $('#tabelaItens').on('click', '#btn-alterar', async function () {
    try {
      const data = $("#tabelaItens").DataTable().row($(this).parents('tr')).data();
      if (listaBarrasLog.find(e => e.CODIGO === data[0] && e.COR === data[2] && e.TAM === data[4])) {
        msgErro('Não é possível alterar esse item pois ele foi adicionado com uma barra log.')
        return
      }

      $('#txtContemExpedicao').val('N');
      if (await Existe('PEDIDO3', ['NUMERO', 'CODIGO', 'COR', 'TAM'], [$('#txtNumero').val(), data[0], data[2], data[4]])) {
        $('#txtContemExpedicao').val('S');
        $('#txtQtdeOrig').val(parseFloat(data[7]));
      }
      // $('#txtIdAlterarQtde').val($("#tabelaItens").DataTable().row($(this).parents('tr')).index());
      const indexesVisiveis = $("#tabelaItens").DataTable().rows({ search: 'applied' }).indexes();
      const rowIndex = indexesVisiveis.indexOf($("#tabelaItens").DataTable().row($(this).closest('tr')).index());
      $('#txtIdAlterarQtde').val(rowIndex);

      const row = $("#tabelaItens").DataTable().row($(this).closest('tr'));
      $('#txtIdAlterarQtde').data('rowNode', row.node());

      $(this).parents('tr').addClass('selected');
      $('#txtAlterarQtde').val(parseFloat(data[7]));
      $('#txtAlterarPreco').val(TruncaDecimaisNova(2, data[8]));
      $('#txtAlterarDesconto').val(TruncaDecimaisNova(2, data[17]));
      $('#txtPrecoOriginal').val(parseFloat(data[15]));
      $('#txtAlterarValor').val(parseFloat(data[7] * data[8]).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));

      adicionaEventoQtde(data[9]);

      const parametroAlteraPreco = await CopiaParametro('PEDIDO', 4);

      if (parametroAlteraPreco == '1') {
        $('#txtAlterarPreco').prop('disabled', false);
      }

      $('#modal-alterar-qtde').modal('show');

    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível realizar a exclusão: ${e}`);
    }
  })

  function adicionaEventoQtde(tipo) {

    $('#txtAlterarQtde').off('input');
    $('#txtAlterarQtde').on('input', function () {

      if (tipo == 'P') {

      } else {
        if (($(this).val()).split('.')[1]?.length > 2) {
          $(this).val(($(this).val()).slice(0, -1));
        }
      }
      const qtde = parseFloat($('#txtAlterarQtde').val());
      const preco = parseFloat($('#txtAlterarPreco').val());
      const valor = parseFloat(qtde * preco).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      });
      $('#txtAlterarValor').val(valor == 'NaN' ? '0' : valor);
    });

    $("#txtAlterarQtde").off("keydown");
    $("#txtAlterarQtde").on("keydown", function (e) {
      if (e.key == "+" || e.key == "-" || e.which == 69) {
        e.preventDefault();
      }
    })
  }

  $('#txtAlterarPreco').on('input', function () {
    const qtde = parseFloat($('#txtAlterarQtde').val());
    const preco = parseFloat($('#txtAlterarPreco').val());
    const valor = parseFloat(qtde * preco).toLocaleString("pt-br", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2,
    });
    $('#txtAlterarValor').val(valor == 'NaN' ? 0 : valor);
  });

  $('#tabelaItens').on('click', '.imagem', async function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
  });

  $('#txtProduto').on('blur', async function () {
    $('#txtQtdeTotalSelecionado').val('0');
    $('#txtValorSelecionado').val('0.00');
    $('#txtCorSelecionado').val('Cor');
    $('#txtTamSelecionado').val('Tamanho');
    $('#txtQtdeSelecionado').val('0');
    const codigo = pegaChave('#txtProduto');
    if (codigo == '') {
      return;
    };
    if ((await buscaValor('PRODUTO', 'ATIVO', 'CODIGO', codigo)).ATIVO == 'N') {
      msgAlerta('Produto inativo, impossível continuar.');
      limpaValor('#txtProduto');
      return;
    };

    if (await produtoComStatusBloqueio(codigo)) {
      msgAlerta('Produto com Status de bloqueio para digitação de pedidos.');
      limpaValor('#txtProduto');
      return;
    }

    await explodeGradeProduto(codigo);
    await buscaQuantidadeEmEstoque(codigo, pegaChave('#txtDeposito'));
    adicionaEventosCampoQtdeGradeItens();

    const bUnidadeInteira = await unidadeInteiraProduto(codigo);

    if (bUnidadeInteira) {
      $('.camposGrade').maskMoney({
        decimal: ".",
        thousands: "",
        precision: 0,
      });
    } else {
      $('.camposGrade').maskMoney({
        decimal: ".",
        thousands: "",
        precision: 2,
      });
    }

    calculaTotalSelecionado()
  });

  function calculaTotalSelecionado() {
    let sum = 0
    $('.camposGrade').each(function () {
      const value = parseFloat($(this).val())
      if (!isNaN(value)) {
        sum += value
      }
    })

    if (sum || sum === 0) {
      $('#txtQtdeTotalSelecionado').val(sum)
    }
  }

  async function calculaValorSelecionado(qtde, codigo, cor, tam) {
    try {
      let preco
      const tabPreco = pegaChave('#txtTabelaPreco');
      const desconto = parseFloat(coalesce($('#txtDescontoProd').val()));
      if (tabPreco !== '999') {
        if (BuscaPorCorETam == 1) {
          preco = await retornaPrecoCorTamProdutoAoBiparBarra(tabPreco, codigo, cor, tam)
        } else {
          preco = await retornaPrecoProduto(tabPreco, codigo)
        }
        if (!preco || preco === 0) {
          preco = parseFloat($('#txtValor').val())
        }
      } else {
        preco = parseFloat($('#txtValor').val())
      }

      if (desconto > 0) {
        preco = preco - desconto;
      }

      let valor = preco * qtde

      if (isNaN(valor)) {
        valor = 0
      }

      if (valor || valor === 0) {
        $('#txtValorSelecionado').val(valor.toLocaleString("pt-br", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2,
        }))
      }
    } catch (e) {
      console.log(e)
      $('#txtValorSelecionado').val('0,00')
    }
  }

  async function buscaQuantidadeEmEstoque(sCodigo, sDeposito) {
    const produtoPesquisadoPaIten = await retornaInfosProduto(sCodigo, sDeposito);
    const produtoPesquisadoPedIten = await retornaInfosProdutoPedido(sCodigo, sDeposito);

    if (!produtoPesquisadoPaIten) {
      return;
    }

    let data = produtoPesquisadoPaIten;
    let qtdeTot = 0;
    let qtdePend = 0;

    data.map(item => { qtdeTot += item.QUANTIDADE });

    if (bConsideraQtdePendentePedido && !!produtoPesquisadoPedIten) {
      produtoPesquisadoPedIten.map(item => { qtdePend += item.QUANTIDADE });
    };

    $('#txtQuantidadeEstoque').val(qtdeTot - qtdePend);

    $('#tabelaGradeProduto').DataTable().rows().data().map((item, index) => {
      const cor = (data.find(cor => { return cor.COR == item.COR }))?.RGB;
      if (cor?.length == 9) {
        item.DESC_COR = `<span title="RGB" style="background-color: RGB(${cor.substr(0, 3)},${cor.substr(3, 3)}, ${cor.substr(6, 3)})">      </span>  ` + item.DESC_COR;
      }
      $('#tabelaGradeProduto').DataTable().row(index).data(item).draw(false);
    });

    $('.camposGrade').on('click', function () {
      $('#txtQtdeSelecionado').val('')
      $('#txtTamSelecionado').val('')
      $('#txtCorSelecionado').val('')
      const qtdeEst = produtoPesquisadoPaIten.find(item => { return (item.COR == $(this).attr('cor') && item.TAM == $(this).attr('tam')) });

      if (!qtdeEst) {

        const rowData = $('#tabelaGradeProduto').DataTable()
          .row($(this).closest('tr'))
          .data();

        $('#txtCorSelecionado').val(rowData.COR);
        $('#txtTamSelecionado').val($(this).attr('tam'));
        $('#txtQtdeSelecionado').val('0');
        return;
      }

      let qtdeMostra = qtdeEst.QUANTIDADE;

      if (!!produtoPesquisadoPedIten && bConsideraQtdePendentePedido) {
        const qtdePedIten = produtoPesquisadoPedIten.find(item => { return (item.COR == $(this).attr('cor') && item.TAM == $(this).attr('tam')) });
        if (!!qtdePedIten) {
          qtdeMostra = qtdeEst.QUANTIDADE - qtdePedIten.QUANTIDADE;
        }
      }

      if (qtdeEst) {
        insereValor('#txtCorSelecionado', qtdeEst.COR);
        insereValor('#txtTamSelecionado', qtdeEst.TAM);
        insereValor('#txtQtdeSelecionado', qtdeMostra);
      }
      $('.itemSelecionado').removeClass('d-none');
      // $('#trocaClasse').addClass('d-flex justify-content-end');
    });

    $('.camposGrade').on('focusout', function () {
      $('.itemSelecionado').addClass('d-none');
      calculaTotalSelecionado()
      // $('#trocaClasse').removeClass('d-flex justify-content-end');
    });
  }

  async function retornaInfosProduto(sCodigo, sDeposito) {
    const dadosSelect = {
      tabela: 'PA_ITEN',
      camposSelect: ['SUM(PA_ITEN.QUANTIDADE) QUANTIDADE', 'PA_ITEN.COR', 'PA_ITEN.TAM', 'CADCOR.RGB'],
      leftJoin: [{ tabela: 'CADCOR', condicao: 'CADCOR.COR = PA_ITEN.COR' }],
      where: [`PA_ITEN.CODIGO = '${sCodigo}' AND PA_ITEN.DEPOSITO = '${sDeposito}'`],
      groupBy: ['PA_ITEN.COR', 'PA_ITEN.TAM', 'CADCOR.RGB']
    };
    const data = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!data) {
      return undefined;
    }
    if (data.length == 0) {
      return undefined;
    }

    return data;
  }

  async function retornaLotes(sCodigo, sDeposito, sLote, sQualidade) {
    const dadosSelect = {
      tabela: 'PA_ITEN',
      camposSelect: [
        'PA_ITEN.ID', 'PA_ITEN.CODIGO', 'PRODUTO.DESCRICAO', 'PA_ITEN.DEPOSITO', 'DEPOSITO.DESCRICAO DESC_DEPOSITO',
        'PA_ITEN.COR', 'CADCOR.DESCRICAO DESC_COR', 'PA_ITEN.TAM', 'PA_ITEN.LOTE',
        '(PA_ITEN.QUANTIDADE - SUM(COALESCE(PED_RESERVA.QTDE, 0)) - SUM(COALESCE(PEDIDO3.QTDE, 0))) QTDE_ESTOQUE',
        `'' QTDE`
      ],
      leftJoin: [
        { "tabela": "CADCOR", "condicao": "CADCOR.COR = PA_ITEN.COR" },
        { "tabela": "PRODUTO", "condicao": "PRODUTO.CODIGO = PA_ITEN.CODIGO" },
        { "tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PA_ITEN.DEPOSITO" },
        {
          "tabelaSelect": "(SELECT CODIGO, COR, TAM, DEPOSITO, LOTE, QUAL, SUM(QTDE) AS QTDE FROM [PED_RESERVA] GROUP BY CODIGO, COR, TAM, DEPOSITO, LOTE, QUAL)",
          "alias": "PED_RESERVA",
          "condicao": "PED_RESERVA.CODIGO = PA_ITEN.CODIGO AND PED_RESERVA.COR = PA_ITEN.COR AND PED_RESERVA.TAM = PA_ITEN.TAM AND PED_RESERVA.DEPOSITO = PA_ITEN.DEPOSITO AND PED_RESERVA.LOTE = PA_ITEN.LOTE AND PED_RESERVA.QUAL = PA_ITEN.TIPO"
        },
        {
          "tabelaSelect": "(SELECT CODIGO, COR, TAM, DEPOSITO, LOTE, QUALIDADE, SUM(QTDE) AS QTDE FROM [PEDIDO3] GROUP BY CODIGO, COR, TAM, DEPOSITO, LOTE, QUALIDADE)",
          "alias": "PEDIDO3",
          "condicao": "PEDIDO3.CODIGO = PA_ITEN.CODIGO AND PEDIDO3.COR = PA_ITEN.COR AND PEDIDO3.TAM = PA_ITEN.TAM AND PEDIDO3.DEPOSITO = PA_ITEN.DEPOSITO AND PEDIDO3.LOTE = PA_ITEN.LOTE AND PEDIDO3.QUALIDADE = PA_ITEN.TIPO"
        },
      ],
      where: [`1 = 1 ${sCodigo != '' ? ` AND PA_ITEN.CODIGO = '${sCodigo}'` : ''} ${sLote != '' ? ` AND PA_ITEN.LOTE = '${sLote}'` : ''} ${sDeposito != '' ? ` AND PA_ITEN.DEPOSITO = '${sDeposito}'` : ''} AND PA_ITEN.QUANTIDADE > 0 AND PA_ITEN.TIPO = '${sQualidade}'`],
      groupBy: ['PA_ITEN.CODIGO', 'PRODUTO.DESCRICAO', 'PA_ITEN.DEPOSITO', 'DEPOSITO.DESCRICAO', 'PA_ITEN.COR', 'CADCOR.DESCRICAO', 'PA_ITEN.TAM', 'PA_ITEN.LOTE', 'PA_ITEN.QUANTIDADE', 'PA_ITEN.ID', 'PRODUTO.CODIGO', 'PRODUTO.DESCRICAO'],
      orderBy: ['PA_ITEN.COR', 'PA_ITEN.TAM']
    };

    const data = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

    if (!data) {
      return [];
    }
    if (data.length == 0) {
      return [];
    }

    return data;
  };

  function preencheTabelaLotes(dados) {
    $.LoadingOverlay('show');
    try {
      const dataSetCols = [];

      let i = 0;
      const jsonObject = dados.map(obj => {
        const newObject = { ...obj };
        newObject.QTDE = `<input type="text" class="input-default focus form-control campoQtdeLote text-right" idx="${i}" style="width: 150px">`;
        i += 1;
        return { ...newObject };
      });

      const keys = Object.keys(dados[0]);
      for (var k in keys) {
        let titulo = keys[k];

        switch (keys[k]) {
          case 'ID':
            titulo = 'ID';
            break;
          case 'CODIGO':
            titulo = 'Código';
            break;
          case 'DESCRICAO':
            titulo = 'Descrição';
            break;
          case 'DEPOSITO':
            titulo = 'Depósito';
            break;
          case 'DESC_DEPOSITO':
            titulo = 'Desc. Depósito';
            break;
          case 'COR':
            titulo = 'Cor';
            break;
          case 'COR':
            titulo = 'Cor';
            break;
          case 'DESC_COR':
            titulo = 'Desc. Cor';
            break;
          case 'TAM':
            titulo = 'Tamanho';
            break;
          case 'LOTE':
            titulo = 'Lote';
            break;
          case 'QTDE_ESTOQUE':
            titulo = 'Qtde. Estoque';
            break;
          case 'QTDE':
            titulo = 'Quantidade';
            break;
        }

        dataSetCols.push({
          'title': titulo,
          'data': keys[k]
        });
      };

      criaDataTablePadrao('#tabelaItensLote', false, true, false, false, true, true, '400px', jsonObject, dataSetCols);

      $('.campoQtdeLote').maskMoney({
        decimal: ".",
        thousands: "",
        precision: 0,
      });

      $('.campoQtdeLote').on('blur', function () {
        const index = parseFloat($(this).attr('idx'));
        const qtdeInput = parseFloat(coalesce($(this).val()));
        const qtdeEst = $('#tabelaItensLote').DataTable().row(index).data().QTDE_ESTOQUE;

        if (qtdeInput > qtdeEst) {
          msgAlerta('Quantidade insuficiente em estoque para esse lote, favor verificar.');
          $(this).val('');
          return;
        }
      });
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function retornaInfosProdutoPedido(sCodigo, sDeposito) {
    const dadosSelect = {
      tabela: 'PED_ITEN',
      camposSelect: ['SUM(QTDE) QUANTIDADE', 'COR', 'TAM'],
      where: [`CODIGO = '${sCodigo}' AND DEPOSITO = '${sDeposito}'`],
      groupBy: ['COR', 'TAM']
    };
    const data = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!data) {
      return undefined;
    }
    if (data.length == 0) {
      return undefined;
    }

    return data;
  }

  $('#txtMaterial, #txtCor').change(async function () {
    const codigo = pegaChave('#txtMaterial');
    const cor = pegaChave('#txtCor');
    const deposito = pegaChave('#txtDeposito')
    const pedido = $('#txtNumero').val()

    if ((codigo == '') || (cor == '')) {
      return;
    };

    await buscaQuantidadeEmEstoqueMat(codigo, cor, deposito);

    if (isChecked('#radioProduto')) {
      return;
    };

    $('#txtMaterial').trigger('blur');
    retornarQuantidadeDisponivelMaterial({
      pedido,
      material: codigo,
      cor,
      deposito,
    }).then((quantidade) => {
      $('#txtQuantidadeDisponivelMat').val(quantidade)
    })
  });

  async function buscaQuantidadeEmEstoqueMat(sCodigo, sCor, sDeposito) {
    const dadosSelect = {
      tabela: 'MAT_ITEN',
      camposSelect: ['SUM(QTDE) QTDE'],
      where: [`CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}'`]
    };
    const data = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!data) {
      return;
    }
    if (data.length == 0) {
      return;
    }
    $('#txtQuantidadeEstoqueMat').val(data[0].QTDE);
  }

  async function retornarQuantidadeDisponivelMaterial({ pedido, material, cor, deposito }) {
    try {
      if (!pedido || !material || !cor || !deposito) {
        return 0
      }

      const response = await requisicao(
        'GET',
        '/sisplan/pedido/v1/quantidadedisponivelmaterial?',
        `&PEDIDO=${encodeURIComponent(String(pedido))}&CODIGO=${encodeURIComponent(String(material))}&COR=${encodeURIComponent(String(cor))}&DEPOSITO=${encodeURIComponent(String(deposito))}`,
        '',
        90000
      )
      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        return resultado?.quantidade ?? 0
      }

      return 0

    } catch (error) {
      msgErro('Ocorreu um erro ao buscar a quantidade disponível do material.')
      console.error(error)
    }
  }

  $('#btnConfirmarItem').on('click', async function () {
    if ($('#dadosMaterial').hasClass('d-none')) {
      await confirmaProduto();
    } else {
      await confirmaMaterial();
    }
    await atualizaValorTotalPedido();
  });

  $('#btnConfirmarItemLote').on('click', async function () {
    await confirmaProdutoLote();
    await atualizaValorTotalPedido();
  });

  $('#modalItem').on('hidden.bs.modal', function (_) {
    $('#txtProduto').val('');
    $('#txtValor').val('');
    $('#txtValorMat').val('');
    $('#txtDescMat').val('');
    $('#txtDescontoProd').val('');
    $('#txtMaterial').val('');
    $('#txtCor').val('');
    $('#txtQtde').val('1');
    $('#txtQuantidadeEstoque').val('');
    $('#txtCorSelecionado').val('');
    $('#txtTamSelecionado').val('');
    $('#txtQtdeSelecionado').val('');
    $('#txtObsItem').val('');
    $('#txtQtdeTotalSelecionado').val('')
    $('#txtValorSelecionado').val('')

    if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
      $('#tabelaGradeProduto').DataTable().destroy();
      $('#tabelaGradeProduto').empty();
    };
  });

  $('#gravar').click(async function () {
    if (validaGravar()) {
      await gravaDados();
    }
  });

  $('#voltarAcesso').on('click', async function () {
    const sPedido = $(window.location.href.split('/')).get(-1);
    const sNumero = pegaValor('#txtNumero');

    if ((sPedido == 'create') && (sNumero != '')) {
      await baixaCodigo('PEDIDO', 'NUMERO', sNumero);
    }

    window.location.href = `${BASE_URI}/pedido`;
  });

  $(window).on("beforeunload", async function () {
    const sPedido = $(window.location.href.split('/')).get(-1);
    const sNumero = pegaValor('#txtNumero');

    if ((sPedido == 'create') && (sNumero != '')) {
      await baixaCodigo('PEDIDO', 'NUMERO', sNumero);
    }
  });

  $('#radioProduto, #radioMaterial').on('change', function () {
    if (isChecked('#radioProduto')) {
      $('#dadosProduto').removeClass('d-none');
      $('#dadosMaterial').addClass('d-none');
      $('#dadosObsItem').css('margin-top', '0px');
      $('.divValoresSelecionados').removeClass('d-none');
    } else {
      $('#dadosProduto').addClass('d-none');
      $('#dadosMaterial').removeClass('d-none');
      $('#dadosObsItem').css('margin-top', '0px');
      $('.divValoresSelecionados').addClass('d-none');
    }
  });

  $('#txtMaterial').on('blur', async function () {
    sMaterial = pegaChave('#txtMaterial');

    if (sMaterial == '') {
      return;
    }

    $('#txtCor').unbind('autocompleta');
    $('#txtCor').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", 
                                          "camposSelect":[ "MAT_ITEN.COR CHAVE", "CADCOR.DESCRICAO" ],
                                          "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], 
                                          "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], 
                                          "where": ["MAT_ITEN.CODIGO = '${sMaterial}'"]}`, [], [], []);
    $('#btn-Cor').off();
    $('#btn-Cor').unbind('pesquisa');
    $('#btn-Cor').pesquisa(
      '#txtCor',
      'COR',
      'DESCRICAO',
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN","camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }],  "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"],"where": ["MAT_ITEN.CODIGO = '${sMaterial}'"]}`,
      'Pesquisa Cor',
      'CADCOR',
      undefined,
      () => setTimeout(
        () => {
          const cor = pegaChave('#txtCor')
          const deposito = pegaChave('#txtDeposito')
          const pedido = $('#txtNumero').val()
          buscaQuantidadeEmEstoqueMat(
            sMaterial,
            cor,
            deposito,
          )
          retornarQuantidadeDisponivelMaterial({
            pedido,
            material: sMaterial,
            cor,
            deposito,
          }).then((quantidade) => {
            $('#txtQuantidadeDisponivelMat').val(quantidade)
          })
        },
        100,
      ),
    )

    if (pegaChave('#txtTabelaPreco') != '999') {
      let preco = '';
      if (BuscaPorCorETam == 1) {
        preco = await retornaPrecoCorTamMaterial(pegaChave('#txtTabelaPreco'), sMaterial);
      } else {
        preco = await retornaPrecoProduto(pegaChave('#txtTabelaPreco'), sMaterial);
      }
      if (preco > 0) {
        $('#txtValorMat').val((+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(preco, quantidadeCasasDecimaisCampo)) : preco);
        $('#txtValorMatOrig').val($('#txtValorMat').val());
      } else {
        if (bBloqueiaAddItemSemPreco) {
          msgAlerta('Material sem preço cadastrado na tabela de preço, necessário cadastrar.');
          limpaValor('#txtMaterial');
          limpaValor('#txtCor');
          limpaValor('#txtQuantidadeEstoqueMat');
          limpaValor('#txtValorMat');
          insereValor('#txtQtde', '1');
        } else {
          msgAlerta('Material não consta na tabela de preço informada, necessário informar preço manualmente.');
        }
      }
    }
  });

  $('#txtValorCondicao').on('blur', function () {
    if ($(this).val() == '') {
      $(this).val('0.00');
    }

    atualizaValorCondicao();
  });

  async function validaEdicao() {
    const sPedido = $(window.location.href.split('/')).get(-1);

    if (sPedido == 'create') {
      if (!bBloqueiaNumeroPedido) {
        $('#txtNumero').attr('disabled', true);
        $('#txtNumero').val(await RetornaProximo('PEDIDO', 'PEDIDO', 'NUMERO', 5));
        $('#txtCliente').focus();
      }
    }

    $('#txtValor').prop('disabled', bBloqueiaAlterarPreco);
    $('#txtValorMat').prop('disabled', bBloqueiaAlterarPreco);



    if (sPedido == 'create') {
      await carregaValoresPadroes();
      $('#txtNumero').focus();
      return;
    };

    if (await apenasClientesVinculadosAoRepresentante()) {
      bloqueiaFiltroEPreencheValorRepresentante('#txtRepresentante', '#btn-representante', '#btn-limpa-representante');
    }

    if (bAlteraDataEmissao && sPedido != 'create') {
      $('#dtEmissao').attr('disabled', true)
    }

    bloqueiaCampoNumero();

    $.LoadingOverlay('show');
    try {
      const dados = await retornaDadosPedido(atob(sPedido));
      const itens = await retornaDadosItens(atob(sPedido));
      const condicao = await retornaCondicoes(atob(sPedido));
      const pedCom = await retornaDadosPedCom(atob(sPedido), dados.CODREP);

      insereValor('#txtNumero', dados.NUMERO);
      insereValor('#txtPedCliente', dados.PED_CLI);
      insereValor('#dtDigita', dados.DTDIGITA.slice(0, 10));
      insereValor('#txtCliente', dados.CODCLI, dados.NOME);
      insereValor('#txtComFat', dados.COM1);
      insereValor('#txtComRec', dados.COM2);
      insereValor('#txtRepresentante', dados.CODREP, dados.NOME_REP);
      insereValor('#txtTransportadora', dados.TAB_TRANS, dados.NOME_TRAN);
      insereValor('#txtRedesp', dados.TAB_REDES, dados.NOME_REDES);
      insereValor('#txtResponsavel', dados.RESPONSAVEL, dados.NOME_RESP);
      insereValor('#txtColecao', dados.COLECAO, dados.DESC_COLECAO);
      insereValor('#txtCfop', dados.NATUREZA, dados.DESC_NATUREZA);
      insereValor('#txtPrazoEnt', dados.PERIODO, dados.DESC_PRZENT);
      insereValor('#txtPrazoProd', dados.PERIODOPROD, dados.DESC_PRZPROD);
      insereValor('#dtEmissao', dados.DT_EMISSAO.slice(0, 10));
      insereValor('#dtFatura', dados.DT_FATURA.slice(0, 10));
      insereValor('#dtEntrega', dados.ENTREGA.slice(0, 10));
      insereValor('#dtSaida', dados.DT_SAIDA.slice(0, 10));
      if (condicao.length > 0) {
        insereValor('#txtCondicao', condicao[0].CODCOND, condicao[0].DESCCOND);
      }
      insereValor('#txtTabelaPreco', dados.TAB_PRE, dados.DESC_REGIAO);
      insereValor('#txtMoeda', dados.MOEDA, dados.DESC_MOEDA);
      insereValor('#txtClasseGer', dados.CLASSE_GER, dados.DESC_CLASSE);
      insereValor('#txtHistorico', dados.HISTORICO, dados.DESC_HISTORICO);
      insereValor('#txtSitDup', dados.SIT_DUP, dados.DESC_SIT);
      insereValor('#txtTaxa', dados.TAXA);
      insereValor('#txtFrete', dados.FRETE);
      insereValor('#txtDespesas', dados.DESPESA);
      insereValor('#txtFreteTrans', dados.VLR_FRETE_TRANSP);
      insereValor('#txtBonif', dados.BONIF);
      insereValor('#rgPrazo', dados.TAB_PRE2);
      insereValor('#txtDeposito', dados.DEPOSITO, dados.DESC_DEPOSITO);
      insereValor('#txtComprador', dados.COMPRADOR, dados.NOME_COMPRADOR);
      insereValor('#txtGrupoPed', dados.GRUPO, dados.DESC_GRUPO);
      insereValor('#txtStatus', dados.STATUS, dados.DESC_STATUS);
      insereValor('#txtEspecie', dados.ESPECIE, dados.DESC_ESPECIE);
      insereValor('#txtOperacao', dados.OPERACAO, dados.DESC_OPERACAO);
      insereValor('#txtQualidadeCapa', dados.QUALIDADE, dados.DESC_QUALIDADE);
      insereValor('#txtTpVenda', dados.ID_TIPO, dados.DESC_TIPO);
      insereValor('#txtObservacao', dados.OBS);
      insereValor('#txtObservacao2', dados.OBS2);
      insereValor('#txtDepto', dados.DEPTO);
      insereValor('#txtPrzAdicional', dados.PRZ_DIAS);
      insereValor('#txtOrcamento', dados.ORCAMENTO);
      insereValor('#txtDescontoEmprenho', dados.VAL_DESC_EMPENHO);
      insereValor('#txtPercDesconto', dados.PERC_DESC_EMPENHO);
      insereValor('#txtIndice', dados.IND_QTDE);
      insereValor('#txtIndiceFat', dados.FATURA);
      insereValor('#txtDesconto1', dados.PER_DESC);
      insereCondicoesPgto(dados.PGTO);
      insereDesconto(dados.DESCONTO);
      if (pedCom) inserePedCom(pedCom);
      $('#selectEmpresa').val(dados.EMP_FAT).change();
      $('#rgTransportador').val(dados.CIF).change();
      $('#radioCIF').prop('checked', dados.REDESP_CIF == '1');
      $('#radioFOB').prop('checked', dados.REDESP_CIF != '1');
      $('#checkBonificacao').prop('checked', dados.BONIFICACAO == 'S');
      $('#checkPrecoManual').prop('checked', dados.TAB_PRE == '999');

      for (let item of itens) {
        addItem(item);
      }

      condicao.map(item => { addCondicao(item) });
      await validaBloqueioItens(dados.STATUS);
      habilitaCondicoes();
      $('#txtMoeda').trigger('blur');
    } finally {
      $.LoadingOverlay('hide');
    }
    bloqueiaCampoTabela();
  };

  async function carregaValoresPadroes() {
    const jsonStr = await buscaValoresPadroes('PEDIDO')

    jsonStr.map(async (item) => {
      switch (item.CAMPO) {
        case 'DEPOSITO': {
          insereValor('#txtDeposito', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'STATUS': {
          insereValor('#txtStatus', item.VALOR, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'TRANSPORTADORA': {
          insereValor('#txtTransportadora', item.VALOR, { tabela: 'TABTRAN', campoBusca: 'NOME', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'HISTORICO': {
          insereValor('#txtHistorico', item.VALOR, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: item.VALOR });
          break;
        }
        case 'OPER_FISCAL': {
          insereValor('#txtOperacao', item.VALOR, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'TIPO_VENDA': {
          insereValor('#txtTpVenda', item.VALOR, { tabela: 'TIPO', campoBusca: 'DESCRICAO', campoWhere: 'ID', valorWhere: item.VALOR });
          break;
        }
        case 'ITEM_PADRAO': {
          if (item.VALOR == 'M') {
            $('#radioMaterial').trigger('click');
            $('#dadosProduto').addClass('d-none');
            $('#dadosMaterial').removeClass('d-none');
            $('#dadosObsItem').css('margin-top', '0px');
            $('.divValoresSelecionados').addClass('d-none');
          }
          break;
        }
        case 'RESPONSAVEL': {
          const response = await buscaValor('ENTIDADE', 'NOME', 'CODCLI', item.VALOR)
          if (response && response !== '') {
            insereValor('#txtResponsavel', item.VALOR, response.NOME);
          }
          break;
        }
        case 'COLECAO': {
          insereValor('#txtColecao', item.VALOR, { tabela: 'COLECAO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'QUALIDADE': {
          const response = await buscaValor('TABQUL', 'DESCRICAO', 'CODIGO', item.VALOR)
          if (response && response !== '') {
            insereValor('#txtQualidadeCapa', item.VALOR, response.DESCRICAO);
          }
          break;
        }
        case 'TABELA_PRECO': {
          if ($('#txtTabelaPreco').val() == '') {
            if (item.VALOR === '999') {
              $('#checkPrecoManual').prop('checked', true)
              handleClickCheckPrecoManual()
            } else {
              const response = await buscaValor('REGIAO', 'DESCRICAO', 'REGIAO', item.VALOR)

              if (response && response !== '') {
                insereValor('#txtTabelaPreco', item.VALOR, response.DESCRICAO);
              }
            }
          }
          break
        }
        case 'PRAZO_ENTREGA': {
          const responsePrazoEntrega = await buscaValor('TABPRZ', 'DESCRICAO', 'PRAZO', item.VALOR)

          if (!responsePrazoEntrega) return

          insereValor('#txtPrazoEnt', item.VALOR, responsePrazoEntrega.DESCRICAO)
          break
        }
        case 'PRAZO_PRODUCAO': {
          const responsePrazoProducao = await buscaValor('TABPRZ', 'DESCRICAO', 'PRAZO', item.VALOR)

          if (!responsePrazoProducao) return

          insereValor('#txtPrazoProd', item.VALOR, responsePrazoProducao.DESCRICAO)
          break
        }
      }
    });

    if (await apenasClientesVinculadosAoRepresentante()) {
      bloqueiaFiltroEPreencheValorRepresentante('#txtRepresentante', '#btn-representante', '#btn-limpa-representante');
    }

    if ((!sessionStorage.getItem('g_vendedor_logado')) || (sessionStorage.getItem('g_vendedor_logado') == '')) {
      const usuarioLogado = sessionStorage.getItem('cod_usuario');
      const params = {
        tabela: 'acesso_usuarios',
        camposSelect: ['acesso_usuarios.codrep, represen.nome'],
        LeftJoin: [{
          "tabela": "represen",
          "condicao": "represen.codrep = acesso_usuarios.codrep"
        }],
        where: [`acesso_usuarios.codigo = '${usuarioLogado}'`]
      };

      const response = await retornaJsonPesquisaPadrao(JSON.stringify(params));

      if (!response) {
        return;
      }
      const vendedorDoUsuario = response[0].CODREP;
      const nomeVendedor = response[0].NOME;

      if (vendedorDoUsuario != '') {
        const sCaixa = `[${vendedorDoUsuario}] - ${nomeVendedor}`;
        sessionStorage.setItem('g_vendedor_logado', sCaixa);
        insereValor('#txtRepresentante', vendedorDoUsuario, nomeVendedor);
      }
    } else {
      insereValor('#txtRepresentante', sessionStorage.getItem('g_vendedor_logado'));
    };
  };

  async function buscaCondicao(sNumero) {
    const dadosSelect = {
      tabela: 'CONDICAO',
      camposSelect: ['CONDICAO.NRPAR', 'CONDICAO.NRDIA'],
      where: [`CONDICAO.CODCOND = '${sNumero}'`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados da condição.');
      return;
    };
    insereValor('#txtNrParcelas', retornoSelect[0].NRPAR);
    insereValor('#txtIntervaloDias', retornoSelect[0].NRDIA);
  }

  async function retornaDadosItens(sNumero) {
    const dadosSelect = {
      tabela: 'PED_ITEN',
      camposSelect: [
        'PED_ITEN.CODIGO',
        `CASE WHEN PED_ITEN.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
        'PED_ITEN.COR',
        'CADCOR.DESCRICAO DESC_COR',
        'PED_ITEN.TAM',
        'PED_ITEN.QTDE',
        'PED_ITEN.QTDE_F',
        'PED_ITEN.QTDE_CANC',
        'PED_ITEN.PRECO',
        'PED_ITEN.TIPO',
        'PED_ITEN.OBSERVACAO',
        'PED_ITEN.ORDEM',
        'PED_ITEN.PRECO_ORIG',
        'PED_ITEN.LOTE',
        'PED_ITEN.DEPOSITO',
        '(PED_ITEN.DESC_ITEM / PED_ITEN.QTDE) DESC_ITEM',
        'PED_ITEN.QUALIDADE'
      ],
      leftJoin: [
        { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = PED_ITEN.CODIGO' },
        { tabela: 'CADCOR', condicao: 'CADCOR.COR = PED_ITEN.COR' }
      ],
      where: [`PED_ITEN.NUMERO = '${sNumero}'`],
      orderBy: ['PED_ITEN.ID']
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  };

  async function validaBloqueioItens(status) {
    const dadosSelect = {
      tabela: 'SITPROD',
      camposSelect: ['BLOQ_ITEMPED'],
      where: [`CODIGO = '${status}'`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

    if (!retornoSelect) {
      return;
    };

    if (retornoSelect.length == 0) {
      return;
    }

    if (retornoSelect[0].BLOQ_ITEMPED == 'S') {
      $('.btnVerificaOpcoes').prop('disabled', true);
      setTimeout(() => {
        $('.btnVerificaOpcoes').prop('disabled', true);
      }, 1000);
    }
  }

  $('#lblRepresentantes').on('click', async function () {
    $('#modalVinculaRepresentante').modal('show');
    if ($.fn.DataTable.isDataTable('#tabelaRepresentantes')) {
      await sleep(200);
      $("#tabelaRepresentantes").DataTable().columns.adjust().draw(false);
    }
  });

  $('#btnAdicionarRepresentante').on('click', async function () {
    const obj = {
      CODREP: pegaChave('#txtAddRepresentante'),
      NOME: pegaDescricao('#txtAddRepresentante'),
      COM1: pegaValor('#txtAddComFat'),
      COM2: pegaValor('#txtAddComRec')
    }

    if (pegaChave('#txtAddRepresentante') === pegaChave('#txtRepresentante')) {
      msgAlerta('Não pode inserir duas vezes o mesmo representante, verifique!')
      return;
    }

    if (($.fn.DataTable.isDataTable('#tabelaRepresentantes')) && ($("#tabelaRepresentantes").DataTable().data().count() > 0)) {
      $('#tabelaRepresentantes').DataTable().rows().data().toArray().filter((item) => {
        let codigoTabela = item.CODREP ? item.CODREP.match(/\d+/)[0] : null;
        let codigoInput = pegaChave('#txtAddRepresentante');
        if (codigoTabela == codigoInput) {
          throw msgAlerta(`Não pode inserir duas vezes o mesmo representante (${codigoInput}), verifique!`);
        }
      });

      if (!$('#txtAddRepresentante').val()) {
        throw msgAlerta('Código do representante não preenchido, impossível continuar!')
      }

      $('#tabelaRepresentantes')
        .DataTable()
        .row
        .add(obj).draw(false);

      $('#txtAddRepresentante').val('');
      $('#txtAddComFat').val(0.00);
      $('#txtAddComRec').val(0.00);

      return;
    };


    const titulosRepresentantes = [
      { title: "Codigo", data: "CODREP" },
      { title: "Nome", data: "NOME" },
      { title: "Com. Fat.", data: "COM1" },
      { title: "Com. Rec.", data: "COM2" }
    ];

    $("#tabelaRepresentantes").DataTable({
      destroy: true,
      filter: false,
      paging: false,
      scrollX: true,
      autoWidth: true,
      columns: titulosRepresentantes,
      data: [obj],
      columnDefs: [
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            })
          },
          "targets": [2, 3],
          "className": 'pr-4 text-right'
        },
        {
          targets: [0],
          render: function (data, type, row) {
            return '<div style="text-align:start;"> ' +
              '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
              '      ' + data + ' ' +
              '    </button> ' +
              '    <div class="dropdown-menu"> ' +
              '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
              '</div>';
          },
        },
      ]
    });

    $('#txtAddRepresentante').val('');
    $('#txtAddComFat').val(0.00);
    $('#txtAddComRec').val(0.00);
  });

  function buscaDadosRepresentantes() {
    let dados;
    if ($.fn.DataTable.isDataTable('#tabelaRepresentantes')) {
      const tabelaRepresentantes = $('#tabelaRepresentantes').DataTable().rows().data().toArray();

      dados = tabelaRepresentantes.map((item) => ({
        numero: pegaValor('#txtNumero'),
        codRep: item.CODREP ? item.CODREP.match(/\d+/)[0] : '',
        com1: parseFloat(item.COM1),
        com2: parseFloat(item.COM2)
      }))
    } else {
      dados = []
    }

    return dados
  }

  $('#tabelaRepresentantes').on('click', '#btn-excluir', async function () {
    msgAlerta('Você realmente deseja excluir esse registro?', async () => {
      const data = $("#tabelaRepresentantes").DataTable().row($(this).parents("tr"));
      data.remove().draw(false);
    });
  });

  async function buscaDadosCliente(sCliente) {
    const dadosSelect = {
      tabela: 'ENTIDADE',
      camposSelect: ['ENTIDADE.NATUREZA', 'ENTIDADE.CLASSE', 'ENTIDADE.TABELA', 'ENTIDADE.CODREP',
        'NATUREZA.DESCRICAO DESC_NATUREZA', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'REGIAO.DESCRICAO DESC_TABELA', 'REPRESEN.NOME NOME_REP',
        'ENTIDADE.HISTORICO', 'HISTCP.DESCRICAO DESC_HISTORICO', 'ENTIDADE.MOEDA', 'MOEDA.DESCRICAO DESC_MOEDA', 'ENTIDADE.CONDICAO_PAGAMENTO', 'CONDICAO.DESCRICAO AS DESC_CONDPAGTO',
        'ENTIDADE.CONDICAO'],
      leftJoin: [
        { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = ENTIDADE.NATUREZA' },
        { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = ENTIDADE.CLASSE' },
        { tabela: 'REGIAO', condicao: 'REGIAO.REGIAO = ENTIDADE.TABELA' },
        { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP = ENTIDADE.CODREP' },
        { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO = ENTIDADE.HISTORICO' },
        { tabela: 'MOEDA', condicao: 'MOEDA.CODMOE = ENTIDADE.MOEDA' },
        { tabela: 'CONDICAO', condicao: 'CAST(CONDICAO.CODCOND AS VARCHAR(10)) = ENTIDADE.CONDICAO_PAGAMENTO' }
      ],
      where: [`ENTIDADE.CODCLI = '${sCliente}'`]
    };
    const dados = (await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect)))[0];

    insereValor('#txtRepresentante', dados.CODREP, dados.NOME_REP);
    insereValor('#txtCfop', dados.NATUREZA, dados.DESC_NATUREZA);
    if ($('#txtTabelaPreco').val() == '') {
      insereValor('#txtTabelaPreco', dados.TABELA, dados.DESC_TABELA);
    }
    insereValor('#txtClasseGer', dados.CLASSE, dados.DESC_CLASSE);
    insereValor('#txtHistorico', dados.HISTORICO, dados.DESC_HISTORICO);
    await verificaCondicaoNaMoeda(dados.MOEDA, dados.DESC_MOEDA, dados.CONDICAO_PAGAMENTO, dados.DESC_CONDPAGTO);
    if (dados.CONDICAO != '') {
      await preencheCondicao(dados.CONDICAO)
    }
  };

  async function verificaCondicaoNaMoeda(sMoeda, sMoedaDesc, sCondicao, sCondicaoDesc) {
    let PesquisaCodCond = '';

    if (sCondicao != '' && sCondicao != null && sMoeda != '' && sMoeda != null) {
      PesquisaCodCond = {
        tabela: 'COND_MOEDA',
        camposSelect: ['COND_MOEDA.MOEDA', 'COND_MOEDA.CODCOND'],
        where: [`COND_MOEDA.MOEDA = '${sMoeda}' AND COND_MOEDA.CODCOND = '${sCondicao}'`]
      };

      if (PesquisaCodCond != '') {
        const retornoPesquisa = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaCodCond));

        if (retornoPesquisa.length > 0) {
          temCondicaoEntidade = true;
          $('#txtMoeda').val(`[${sMoeda}] - ${sMoedaDesc}`);
          $('#txtCondicao').val(`[${sCondicao}] - ${sCondicaoDesc}`);
          $('#txtMoeda').trigger('blur');
        } else {
          $('#txtMoeda').val(`[${sMoeda}] - ${sMoedaDesc}`);
          $('#txtMoeda').trigger('blur');
        }
      }
    } else if (sMoeda != '' && sMoeda != null) {
      $('#txtMoeda').val(`[${sMoeda}] -  ${sMoedaDesc}`);
      $('#txtMoeda').trigger('blur');
    }
  };

  async function retornaDadosPedCom(sNumero, sRepCapa) {
    const pesquisa = {
      tabela: 'PED_COM',
      camposSelect: ["PED_COM.CODREP", "REPRESEN.NOME", "PED_COM.COM1", "PED_COM.COM2"],
      leftJoin: [{ tabela: "REPRESEN", condicao: "PED_COM.CODREP = REPRESEN.CODREP" }],
      where: [`PED_COM.NUMERO = '${sNumero}' AND PED_COM.CODREP <> '${sRepCapa}'`],
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    return retornoSelect;
  }

  async function retornaCondicoes(sNumero) {
    const dadosSelect = {
      tabela: 'COND_PAGTO',
      camposSelect: ['COND_PAGTO.DIAS', 'COND_PAGTO.DT_VENCTO', 'COND_PAGTO.MOEDA', 'COND_PAGTO.VALOR', 'COND_PAGTO.CODCOND', 'CONDICAO.DESCRICAO DESCCOND'],
      leftJoin: [{ tabela: "CONDICAO", condicao: "COND_PAGTO.CODCOND = CONDICAO.CODCOND" }],
      where: [`COND_PAGTO.NUMERO = '${sNumero}' AND TIPO = 'P'`],
      orderBy: [`COND_PAGTO.ORDEM`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar as condições de pagamento.');
      return;
    }
    return retornoSelect;
  };

  async function retornaDadosPedido(sNumero) {
    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect: [
        'PEDIDO.NUMERO', 'PEDIDO.CODCLI', 'ENTIDADE.NOME', 'PEDIDO.OBS', 'PEDIDO.PED_CLI', 'PEDIDO.DTDIGITA', 'PEDIDO.EMP_FAT',
        'PEDIDO.COM1', 'PEDIDO.COM2', 'PEDIDO.CODREP', 'REPRESEN.NOME NOME_REP', 'PEDIDO.CIF', 'PEDIDO.TAB_TRANS',
        '(SELECT REDESPACHO.NOME FROM [TABTRAN] REDESPACHO WHERE REDESPACHO.CODIGO = PEDIDO.TAB_REDES) NOME_REDES',
        '(SELECT RESPONSAVEL.NOME FROM [ENTIDADE] RESPONSAVEL WHERE RESPONSAVEL.CODCLI = PEDIDO.RESPONSAVEL) NOME_RESP',
        '(SELECT PERIODOPROD.DESCRICAO FROM [TABPRZ] PERIODOPROD WHERE PERIODOPROD.PRAZO = PEDIDO.PERIODOPROD) DESC_PRZPROD',
        'TABTRAN.NOME NOME_TRAN', 'PEDIDO.TAB_REDES', 'PEDIDO.RESPONSAVEL', 'PEDIDO.COLECAO', 'COLECAO.DESCRICAO DESC_COLECAO',
        'PEDIDO.REDESP_CIF', 'PEDIDO.BONIFICACAO', 'PEDIDO.NATUREZA', 'NATUREZA.DESCRICAO DESC_NATUREZA', 'PEDIDO.PERIODO',
        'TABPRZ.DESCRICAO DESC_PRZENT', 'PEDIDO.PERIODOPROD', 'PEDIDO.DT_EMISSAO', 'PEDIDO.DT_FATURA', 'PEDIDO.ENTREGA',
        'PEDIDO.DT_SAIDA', 'PEDIDO.TAB_PRE', 'REGIAO.DESCRICAO DESC_REGIAO', 'PEDIDO.MOEDA', 'MOEDA.DESCRICAO DESC_MOEDA',
        'PEDIDO.CLASSE_GER', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'PEDIDO.HISTORICO', 'HISTCP.DESCRICAO DESC_HISTORICO',
        'PEDIDO.PGTO', 'PEDIDO.DESCONTO', 'PEDIDO.TAXA', 'PEDIDO.FRETE', 'PEDIDO.BONIF', 'PEDIDO.TAB_PRE2', 'PEDIDO.DEPOSITO',
        'DEPOSITO.DESCRICAO DESC_DEPOSITO', 'PEDIDO.COMPRADOR', 'CONTATO.NOME NOME_COMPRADOR', 'PEDIDO.GRUPO', 'PEDIDO.STATUS',
        'GRUPO_PED.DESCRICAO DESC_GRUPO', 'SITPROD.DESCRICAO DESC_STATUS', 'PEDIDO.ESPECIE', 'ESPECIE.DESCRICAO DESC_ESPECIE',
        'PEDIDO.OPERACAO', 'OPER_FISCAL.DESCRICAO DESC_OPERACAO', 'PEDIDO.DEPTO', 'PEDIDO.PRZ_DIAS', 'PEDIDO.ORCAMENTO',
        'PEDIDO.ID_TIPO', 'TIPO.DESCRICAO DESC_TIPO', 'PEDIDO.VAL_DESC_EMPENHO', 'IND_QTDE', 'PEDIDO.PERC_DESC_EMPENHO',
        'PEDIDO.SIT_DUP', 'TABSIT.DESCRICAO DESC_SIT', 'PEDIDO.QUALIDADE', 'TABQUL.DESCRICAO DESC_QUALIDADE', 'PEDIDO.OBS2',
        'PEDIDO.VLR_FRETE_TRANSP', 'PEDIDO.DESPESA', 'PEDIDO.FATURA', 'PEDIDO.PER_DESC'
      ],
      leftJoin: [
        { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI       = PEDIDO.CODCLI' },
        { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP       = PEDIDO.CODREP' },
        { tabela: 'TABTRAN', condicao: 'TABTRAN.CODIGO         = PEDIDO.TAB_TRANS' },
        { tabela: 'COLECAO', condicao: 'COLECAO.CODIGO         = PEDIDO.COLECAO' },
        { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA     = PEDIDO.NATUREZA' },
        { tabela: 'TABPRZ', condicao: 'TABPRZ.PRAZO            = PEDIDO.PERIODO' },
        { tabela: 'REGIAO', condicao: 'REGIAO.REGIAO           = PEDIDO.TAB_PRE' },
        { tabela: 'MOEDA', condicao: 'MOEDA.CODMOE             = PEDIDO.MOEDA' },
        { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO   = PEDIDO.CLASSE_GER' },
        { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO        = PEDIDO.HISTORICO' },
        { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO       = PEDIDO.DEPOSITO' },
        { tabela: 'CONTATO', condicao: 'CONTATO.CODCLI         = PEDIDO.COMPRADOR' },
        { tabela: 'GRUPO_PED', condicao: 'GRUPO_PED.CODIGO     = PEDIDO.GRUPO' },
        { tabela: 'SITPROD', condicao: 'SITPROD.CODIGO         = PEDIDO.STATUS' },
        { tabela: 'ESPECIE', condicao: 'ESPECIE.CODIGO         = PEDIDO.ESPECIE' },
        { tabela: 'OPER_FISCAL', condicao: 'OPER_FISCAL.CODIGO = PEDIDO.OPERACAO' },
        { tabela: 'TIPO', condicao: 'TIPO.ID              = PEDIDO.ID_TIPO' },
        { tabela: 'TABSIT', condicao: 'TABSIT.CODIGO           = PEDIDO.SIT_DUP' },
        { tabela: 'TABQUL', condicao: 'TABQUL.CODIGO           = PEDIDO.QUALIDADE' }
      ],
      where: [`PEDIDO.NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados do pedido.');
      return;
    }
    return retornoSelect[0];
  };

  async function retornaPrecoProduto(sTabPreco, sCodProd) {
    const dadosSelect = {
      tabela: 'TABPRECO',
      camposSelect: ['PRECO_00'],
      where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    if (retornoSelect.length == 0) {
      return;
    }
    return retornoSelect[0].PRECO_00;
  };

  async function retornaPrecoCorTamProduto(sTabPreco, sCodProd) {
    const dadosSelect = {
      tabela: 'PRECO_COR_TAM',
      camposSelect: ['PRECO'],
      where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    if (retornoSelect.length == 0) {
      return;
    }

    let retorno = 0;

    retornoSelect.map(item => {
      if (item.PRECO > 0) {
        retorno = item.PRECO;
      }
    });

    return retorno;
  };

  async function retornaPrecoCorTamMaterial(sTabPreco, sCodProd) {
    const cor = pegaChave('#txtCor');

    const dadosSelect = {
      tabela: 'PRECO_COR_TAM',
      camposSelect: ['PRECO'],
      where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}'`]
    };

    if (cor != '') {
      dadosSelect.where.push(` COR = '${cor}' `)
    }

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    if (retornoSelect.length == 0) {
      return;
    }

    let retorno = 0;

    retornoSelect.map(item => {
      if (item.PRECO > 0) {
        retorno = item.PRECO;
      }
    });

    return retorno;
  };

  async function habilitaCondicoes() {
    let habilita = await contemCondicao();
    $('#txtCondicao').prop('disabled', habilita);
    $('#btn-Condicao').prop('disabled', habilita);
    $('#btn-limpa-Condicao').prop('disabled', habilita);
    $('#txtNrParcelas').prop('disabled', habilita);
    $('#txtIntervaloDias').prop('disabled', habilita);
    $('#dtPrimeiroVencto').prop('disabled', habilita);
    $('#btnLimpar').prop('disabled', habilita);
    $('#btnAtualizar').prop('disabled', habilita);

    if (habilita) {
      limparTabelaCondicoes();
    }
  };

  async function contemCondicao() {
    const moeda = pegaChave('#txtMoeda');

    if ((moeda == '') || (moeda == 'null')) {
      return true;
    };

    const dadosSelect = {
      tabela: 'CONDICAO',
      camposSelect: ['COND_MOEDA.CODCOND'],
      innerJoin: [{ tabela: 'COND_MOEDA', condicao: 'COND_MOEDA.CODCOND = CONDICAO.CODCOND' }],
      where: [`COND_MOEDA.MOEDA = '${moeda}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return true;
    }
    if (retornoSelect.length == 0) {
      return true;
    }
    return false;
  };

  $('#voltarItens').on('click', function () {
    $("#tabelaItens").DataTable().columns.adjust().draw(false);
  })

  function validaGravar() {
    if ($('#tabelaItens').DataTable().data().length == 0) {
      msgAlerta('Nenhum item informado, impossível continuar!');
      $('#voltarItens').trigger('click');
      return
    }
    let validator = $("#msform").validate();
    validator.element("#txtMoeda");
    validator.element("#txtCondPagto1");
    if (!(validator.element("#txtMoeda") && validator.element("#txtCondPagto1"))) {
      return false;
    }

    let totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });

    let frete = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
    frete += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
    const despesas = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;

    if ((totalCondPagto != 0) && (TruncaDecimaisNova(2, totalCondPagto) != TruncaDecimaisNova(2, (parseFloat(pegaValor('#txtValorLiq'))) + parseFloat(frete) + parseFloat(despesas)))) {
      msgAlerta('Valor das duplicatas geradas não condiz com o total do pedido.');
      return false;
    }

    if (camposObrigatorios) {
      if (camposObrigatorios.length > 0) {
        for (let i = 0; i < camposObrigatorios.length; i++) {
          const campo = $(`#${camposObrigatorios[i]}`);
          const nomeCampo = campo.parents('.form-group').children('label').text();
          if (!campo.val()) {
            msgAlerta(`O campo "${nomeCampo}" não pode estar vazio! Tente novamente.`)
            return false
          }
        };
      };
    }

    return true;
  };

  async function gravaDados() {
    $.LoadingOverlay('show');
    try {
      let libComercial = statusLibComercial
      let libFinanceiro = statusLibFinanceiro
      const sPedido = $(window.location.href.split('/')).get(-1);

      if (sPedido != 'create') {
        const pesquisaParam = {
          tabela: 'PEDIDO',
          camposSelect: ['BLOQUEIO', 'FINANCEIRO'],
          where: [`NUMERO = '${$('#txtNumero').val()}'`],
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        libComercial = bloqueiaPedidoNovamente == '1' || bloqueiaPedidoNovamente == '3' ? '0' : jsonStr[0].BLOQUEIO
        libFinanceiro = bloqueiaPedidoNovamente == '2' || bloqueiaPedidoNovamente == '3' ? '0' : jsonStr[0].FINANCEIRO
      }

      $(window).unbind('beforeunload');

      const pedido = {
        NUMERO: pegaValor('#txtNumero'),
        BLOQUEIO: libComercial,
        FINANCEIRO: libFinanceiro,
        PED_CLI: pegaValor('#txtPedCliente'),
        DTDIGITA: pegaValor('#dtDigita'),
        CODCLI: pegaChave('#txtCliente'),
        COM1: pegaValor('#txtComFat'),
        COM2: pegaValor('#txtComRec'),
        FATURA: pegaValor('#txtIndiceFat'),
        CODREP: pegaChave('#txtRepresentante'),
        TAB_TRANS: pegaChave('#txtTransportadora'),
        TAB_REDES: pegaChave('#txtRedesp'),
        RESPONSAVEL: pegaChave('#txtResponsavel'),
        COLECAO: pegaChave('#txtColecao'),
        NATUREZA: pegaChave('#txtCfop'),
        PERIODO: pegaChave('#txtPrazoEnt'),
        PERIODOPROD: pegaChave('#txtPrazoProd'),
        DT_EMISSAO: pegaValor('#dtEmissao'),
        DT_FATURA: pegaValor('#dtFatura'),
        ENTREGA: pegaValor('#dtEntrega'),
        DT_SAIDA: pegaValor('#dtSaida'),
        TAB_PRE: pegaChave('#txtTabelaPreco'),
        MOEDA: pegaChave('#txtMoeda'),
        SIT_DUP: pegaChave('#txtSitDup'),
        CLASSE_GER: pegaChave('#txtClasseGer'),
        HISTORICO: pegaChave('#txtHistorico'),
        TAXA: pegaValor('#txtTaxa'),
        FRETE: pegaValor('#txtFrete'),
        DESPESA: pegaValor('#txtDespesas'),
        VLR_FRETE_TRANSP: pegaValor('#txtFreteTrans'),
        BONIF: pegaValor('#txtBonif'),
        TAB_PRE2: pegaValor('#rgPrazo'),
        DEPOSITO: pegaChave('#txtDeposito'),
        COMPRADOR: pegaChave('#txtComprador'),
        GRUPO: pegaChave('#txtGrupoPed'),
        STATUS: pegaChave('#txtStatus'),
        ESPECIE: pegaChave('#txtEspecie'),
        OPERACAO: pegaChave('#txtOperacao'),
        ID_TIPO: pegaChave('#txtTpVenda'),
        DEPTO: pegaValor('#txtDepto'),
        PRZ_DIAS: pegaValor('#txtPrzAdicional'),
        ORCAMENTO: pegaValor('#txtOrcamento'),
        EMP_FAT: pegaValor('#selectEmpresa'),
        CIF: pegaValor('#rgTransportador'),
        OBS: pegaValor('#txtObservacao'),
        OBS2: pegaValor('#txtObservacao2'),
        REDESP_CIF: $('#radioCIF').prop('checked') ? '1' : '2',
        BONIFICACAO: $('#checkBonificacao').prop('checked') ? 'S' : 'N',
        EMP_ID: getCookie('emp_id'),
        PGTO: retornaCondicoesPgto(),
        DESCONTO: retornaDesconto(),
        COND_PAGTOS: retornaCondPagto(),
        REC_SIMULA: retornaRecSimula(),
        VAL_DESC_EMPENHO: retornaValDescEmpenho(),
        IND_QTDE: pegaValor('#txtIndice'),
        PERC_DESC_EMPENHO: retornaPercDesc(),
        ITENS: retornaItens(),
        COND_PAGTO: pegaChave('#txtCondicao'),
        QUALIDADE: pegaChave('#txtQualidadeCapa'),
        PEDCOM: buscaDadosRepresentantes()
      };

      await deletaReservaProduto();

      const response = await requisicao('POST', '/sisplan/pedido/v1/pedido?', `&BARRAS_LOG=${encodeURIComponent(JSON.stringify({ BARRAS: listaBarrasLog }))}`, encodeURIComponent(JSON.stringify(pedido)), 90000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');
      msgAlerta('Deseja imprimir o pedido?',
        async () => { await imprimirPedido(pedido.NUMERO); callBack(); },
        () => { callBack(); },
        () => { },
        () => { callBack(); });

      function callBack() {
        criaMensagemSucesso(`Pedido ${pegaValor('#txtNumero')} gravado com sucesso!`, () => { window.location.href = `${BASE_URI}/pedido`; });
      }

    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados do pedido: ${error}`);
    }
  };

  async function imprimirPedido(numero) {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/acesso_pedido?`;

        const ordem = `&TELA_ORDENACAO=acesso_pedido&ORDEM_ORDENACAO=1`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoA');
        let arquivo = await GeraRelatorio(`${url}&NUMERO='${numero}'${ordem}`, 'GET', 1000000, false, 'RelPedidoA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function validaPedidoExistente(sNumero) {
    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect: ['NUMERO'],
      where: [`NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    if (retornoSelect.length == 0) {
      return false;
    }
    return true;
  };

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  async function unidadeInteiraProduto(codigo) {
    const dadosSelect = {
      tabela: 'PRODUTO',
      camposSelect: ['UNIDADE.UNID_INTEIRA'],
      leftJoin: [
        { tabela: "UNIDADE", condicao: "UNIDADE.UNIDADE = PRODUTO.UNIDADE" }
      ],
      where: [`PRODUTO.CODIGO = '${codigo}'`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

    if (!retornoSelect) {
      return false;
    }

    if (retornoSelect.length == 0) {
      return false;
    }

    return (retornoSelect[0].UNID_INTEIRA == 'S');
  };

  async function explodeGradeProduto(codigo) {
    $.LoadingOverlay('show');
    try {
      let tam;
      if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
        $('#tabelaGradeProduto').DataTable().destroy();
        $('#tabelaGradeProduto').empty();
      };

      const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}`, null);
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
      }

      for (let i = 0; i < parseInt(jsonStr.length); i++) {
        const colunas = Object.keys(jsonStr[i]);
        let tamanhos = [];
        colunas.forEach((coluna) => {
          if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
            tamanhos.push(coluna);
          }
        });

        function compareStringsByFirstNumber(a, b) {
          const aNumber = parseInt(a.split("HIFEN")[0]);
          const bNumber = parseInt(b.split("HIFEN")[0]);

          return aNumber - bNumber;
        }

        tamanhos = tamanhos.sort(compareStringsByFirstNumber);

        const jsonObject = jsonStr.map(obj => {
          const newObject = { ...obj };
          delete newObject.CODIGO;
          delete newObject.POSICAO;
          Object.keys(obj).forEach(key => {
            tam = RetornaIdTamFormatado(key);
            if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(tam)) {
              newObject[tam] = `<input type="text" class="input-default focus form-control camposGrade text-right" id="${newObject.COR.replace('.', '') + tam}" value="${jsonStr[i][tam]}">`;
              newObject[tam.split('HIFEN')[1]] = `<input type="text" cor="${newObject.COR}" tam="${tam.split('HIFEN')[1]}" style="width: 60px" class="input-default focus form-control camposGrade text-right" id="${newObject.COR.replace('.', 'dot') + tam}" value="0">`;
              delete newObject[tam];
            }
          });
          return { ...newObject };
        });

        if (i == 0) {
          const titulosFixos = ['COR', 'DESC_COR'];
          const titulosGeral = [...titulosFixos, ...tamanhos];
          const titulos = titulosGeral.map(titulo => {
            const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
            const objeto = { title: coluna, data: RetornaIdTamFormatado(coluna) };
            return objeto;
          });
          criaDataTablePadrao('#tabelaGradeProduto', false, true, false, false, true, true, '250px', jsonObject, titulos);
        }
      }

      if (pegaChave('#txtTabelaPreco') != '999') {
        let preco = '';
        if (BuscaPorCorETam == 1) {
          preco = await retornaPrecoCorTamProduto(pegaChave('#txtTabelaPreco'), codigo);
        } else {
          preco = await retornaPrecoProduto(pegaChave('#txtTabelaPreco'), codigo);
        }
        if (preco > 0) {
          $('#txtValor').val((+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(preco, quantidadeCasasDecimaisCampo)) : preco);
          $('#txtValorOrig').val($('#txtValor').val());
        } else {
          if (bBloqueiaAddItemSemPreco) {
            msgAlerta('Produto sem preço cadastrado na tabela de preço, necessário cadastrar.');
            // if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
            //   $('#tabelaGradeProduto').DataTable().destroy();
            //   $('#tabelaGradeProduto').empty();
            // };
            limpaValor('#txtProduto');
            limpaValor('#txtQuantidadeEstoque');
            limpaValor('#txtValor');
          } else {
            msgAlerta('Produto não consta na tabela de preço informada, necessário informar preço manualmente.');
          }
        }
      }

    } finally {
      $.LoadingOverlay('hide');
      preencheComZero();
      $('#txtValor').focus();
    }
  };

  async function setaDatas() {
    await setarDataAtual('dtDigita');
    await setarDataAtual('dtEmissao');
    await setarDataAtual('dtFatura');
    await setarDataAtual('dtEntrega');
    await setarDataAtual('dtSaida');
    await setarDataAtual('dtPrimeiroVencto');
  };

  function insereCondicoesPgto(sPagto) {
    for (let i = 0; i < 36; i += 3) {
      const id = '#txtCondPagto' + (i == 0 ? 1 : ((i / 3) + 1));
      $(id).val(((sPagto.substring(i, 3 + i)).replace(/^(0+)(\d)/g, "$2")).trim());
    }
  };

  function limparCamposCondicoes() {
    let id;
    for (let i = 1; i <= 12; i++) {
      id = '#txtCondPagto' + i;
      if (id == '#txtCondPagto1') {
        $(id).val('0');
      } else {
        $(id).val('');
      }
    }
  };

  function limparCamposDias() {
    $("#txtNrParcelas, #txtIntervaloDias").val("")
  };

  async function atualizaData() {
    if ($('#txtIntervaloDias').val() !== '0' || $('#txtIntervaloDias').val() !== '') {
      let intervaloDias;
      let condicao;
      if ($('#txtCondicao').val() != '') {
        condicao = pegaChave('#txtCondicao');

        intervaloDias = await buscaValor('CONDICAO', 'PRAZOINI', 'CODCOND', condicao);

        if (intervaloDias != undefined) {
          intervaloDias = intervaloDias.PRAZOINI;
        }
      } else {
        intervaloDias = parseInt($('#txtIntervaloDias').val());
      }

      const dataAtual = new Date();
      const dataVencimento = new Date(dataAtual.setDate(dataAtual.getDate() + intervaloDias));
      $('#dtPrimeiroVencto').val(dataVencimento.toISOString().substr(0, 10));
    } else {
      await setarDataAtual('dtPrimeiroVencto')
    };
  }

  async function geraCondicoes() {
    // await atualizaData();
    const dtVencto = pegaValor('#dtPrimeiroVencto').split('-');
    let dataCondicoes = (new Date().toISOString().slice(0, 10)).split('-');
    let venctoTabela = new Date(dataCondicoes[0], dataCondicoes[1] - 1, dataCondicoes[2], 23, 59, 59);
    let vencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
    if (vencto < new Date()) {
      msgAlerta('Campo "1º Vencimento" menor que a data atual, impossível continuar!');
      return;
    };
    // limparTabelaCondicoes();
    let totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });

    let frete = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
    frete += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
    const despesas = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;

    if (totalCondPagto >= (parseFloat(pegaValor('#txtValorLiq')) + parseFloat(frete) + parseFloat(despesas))) {
      msgAlerta('Pagamento total do pedido já preenchido, para alterar necessário limpar as condições.');
      return;
    }

    limparCamposCondicoes();
    let data = new Date();
    let dias;
    let total = 0;
    let valor = 0;
    let novoVencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
    let novoVenctoTabela = new Date();
    data.setDate(novoVencto.getDate());
    data.setDate(novoVenctoTabela.getDate());
    const parcelas = pegaValor('#txtNrParcelas') == 0 ? 1 : pegaValor('#txtNrParcelas');
    const moeda = pegaChave('#txtMoeda');
    const condicao = pegaChave('#txtCondicao');
    const descCondicao = pegaDescricao('#txtCondicao');
    const intervalo = pegaValor('#txtIntervaloDias');
    const valorPed = pegaValor('#txtValorCondicao');
    let prazoini = parseFloat($('#txtIntervaloDias').val());
    if ($('#txtCondicao').val() != '') {
      prazoini = await buscaValor('CONDICAO', 'PRAZOINI', 'CODCOND', condicao);
      if (!!prazoini) {
        prazoini = prazoini.PRAZOINI;
      }
    }
    for (let i = 1; i <= parcelas;) {
      // Nesta primeira parte são calculados os dias dos inputs das condições de pagamento (parte superior)
      dias = diferencaDias(venctoTabela, data);
      dias += prazoini;
      valor = TruncaDecimaisNova(2, valorPed / parcelas);
      total += valor;
      if (i == parcelas) {
        valor = TruncaDecimaisNova(2, valor + (valorPed - total));
      };
      const id = '#txtCondPagto' + i;
      i == 1 && --dias;
      $(id).val(dias);
      // Nesta segunda parte são calculados as datas de vencimento a partir do que estiver informado nos campos intervalo de dias, nr. parcelas e 1º vencimento
      // Estas informações são adicionadas na tabela
      const inputData = `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataRec-${$('#tabelaCondicao').DataTable().rows().count() + 1}" name="txtDataRec-${$('#tabelaCondicao').DataTable().rows().count() + 1}" value="${formataData(vencto)}"></input>`
      $('#tabelaCondicao').DataTable().row.add([
        dias,
        inputData,
        moeda,
        condicao,
        descCondicao,
        valor
      ]).draw(false);
      novoVenctoTabela.setDate(venctoTabela.getDate() + parseInt(intervalo));
      venctoTabela = novoVenctoTabela;
      novoVencto.setDate(vencto.getDate() + parseInt(intervalo));
      vencto = novoVencto;
      i++
    }
    atualizaValorCondicao();
    totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });
    let freteCondicao = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
    freteCondicao += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
    const despesaCondicao = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;
    $('#txtValorCondicao').val(((parseFloat(pegaValor('#txtValorLiq')) + parseFloat(freteCondicao) + parseFloat(despesaCondicao)) - totalCondPagto).toFixed(2));
  };

  function atualizaValorCondicaoTotal() {
    totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });
    let freteCondicao = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
    freteCondicao += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
    const despesaCondicao = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;
    $('#txtValorCondicao').val(((parseFloat(pegaValor('#txtValorLiq')) + parseFloat(freteCondicao) + parseFloat(despesaCondicao)) - totalCondPagto).toFixed(2));
  }

  $("#txtIntervaloDias").blur(function () {
    atualizaData(); // substitua "minhaFuncao" pelo nome da sua função
  });

  function limparTabelaCondicoes() {
    if ($('#tabelaCondicao').DataTable().rows().count() > 0) {
      $('#tabelaCondicao').empty();
      criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px', null, null, [], [], [], [5]);
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    };
    // $("#dtPrimeiroVencto").val(ne)
  };

  function diferencaDias(data1, data2) {
    const diferenca = Math.abs(data1.getTime() - data2.getTime());
    const result = Math.ceil(diferenca / (1000 * 60 * 60 * 24));
    return result;
  };

  function retornaCondicoesPgto() {
    let sCondicoes = '';
    for (let i = 1; i <= 12;) {
      if ((sCondicoes.length % 3) != 0) {
        sCondicoes += ' ';
      } else {
        sCondicoes += $('#txtCondPagto' + i).val();
        i++;
      }
    }
    return sCondicoes;
  }

  function inserePedCom(pedCom) {
    const titulosRepresentantes = [
      { title: "Codigo", data: "CODREP" },
      { title: "Nome", data: "NOME" },
      { title: "Com. Fat.", data: "COM1" },
      { title: "Com. Rec.", data: "COM2" }
    ];

    $("#tabelaRepresentantes").DataTable({
      destroy: true,
      filter: false,
      paging: false,
      scrollX: true,
      autoWidth: true,
      columns: titulosRepresentantes,
      data: pedCom,
      columnDefs: [
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          "targets": [2, 3],
          "className": 'pr-4 text-right'
        },
        {
          targets: [0],
          render: function (data, type, row) {
            return '<div style="text-align:start;"> ' +
              '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
              '      ' + data + ' ' +
              '    </button> ' +
              '    <div class="dropdown-menu"> ' +
              '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
              '</div>';
          },
        },
      ]
    });
  }

  function insereDesconto(sDesconto) {
    for (let i = 0; i < 30; i += 5) {
      const id = '#txtDesconto' + (i == 0 ? 1 : ((i / 5) + 1));
      $(id).val(((sDesconto.substring(i, 5 + i)).trim()).replaceAll(',', '.'));
    }
  }

  function retornaDesconto() {
    let sDesconto = '';
    for (let i = 1; i <= 6;) {
      if ((sDesconto.length % 5) != 0) {
        sDesconto += ' ';
      } else {
        sDesconto += $('#txtDesconto' + i).val();
        i++;
      }
    }
    return (sDesconto.replaceAll('.', ','));
  }

  function retornaItens() {
    let arrItens = [];
    $('#tabelaItens').DataTable().rows().data().map((item, index) => {
      arrItens.push({
        CODIGO: item[0],
        DESCRICAO: item[1],
        COR: item[2],
        DESC_COR: item[2],
        TAM: item[4],
        QTDE: item[7],
        QTDE_ORIG: item[7],
        QTDE_F: item[12],
        QTDE_CANC: item[13],
        PRECO: item[8],
        PRECO_ORIG: item[8],
        TIPO: item[9],
        OBSERVACAO: item[11],
        QUALIDADE: item[19],
        ORDEM: item[14],
        ORDEM_DIG: item[14],
        PRECO_ORIG: item[15],
        DESC_ITEM: item[17] * item[7],
        LOTE: retornaLoteDeposito(item[6]),
        DEPOSITO: retornaLoteDeposito(item[5])
      })
    });
    return arrItens;
  };

  function retornaLoteDeposito(lote) {
    const tempDiv = $("<div>").html(lote);
    const inputId = tempDiv.find("input").attr("id");

    return pegaValor(`#${inputId}`);
  }

  function retornaCondPagto() {
    let arrCondicoes = [];
    let i = 1;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      arrCondicoes.push({
        DIAS: item[0],
        DT_VENCTO: $('#txtDataRec-' + i).val(),
        MOEDA: item[2],
        CODCOND: item[3],
        VALOR: item[5],
        TIPO: 'P',
        NUMERO: pegaValor('#txtNumero'),
        ORDEM: i++
      })
    });
    return arrCondicoes;
  };

  function retornaRecSimula() {
    let arrRec_Simula = [];
    let i = 1;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      arrRec_Simula.push({
        PEDIDO: pegaValor('#txtNumero'),
        VENCTO: $('#txtDataRec-' + i).val(),
        VALOR_PARCELA: item[5],
        VALOR_TOTAL: pegaValor('#txtValorLiq'),
        TIPO_LOTE: 'PEDIDO',
        NUM_PARCELA: i++,
        DT_FATURA: pegaValor('#dtDigita')
      })
    });
    return arrRec_Simula;
  };

  async function retornaTotal() {
    try {
      let total = 0;
      let desconto = 0;
      let desc = '';
      let frete = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
      frete += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
      const despesas = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;
      desc = retornaDesconto();
      desconto = await reqRetornaDesconto(desc);
      const percDesc = retornaPercDesc();
      $('#tabelaItens').DataTable().rows().data().map(item => {
        total += (parseFloat(item[7]) * item[8]);
      });
      desconto = (total * ((desconto + percDesc) / 100));
      total = total - desconto;
      insereValor('#txtValorLiq', total.toFixed(2));
      insereValor('#txtValorCondicao', (parseFloat(total) + parseFloat(frete) + parseFloat(despesas)).toFixed(2));
    } catch (error) {
      console.log(error);
    } finally {
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    }
  };

  function atualizaValorCondicao() {
    let valParcelas = 0;
    const valCondicao = parseFloat(pegaValor('#txtValorCondicao'));
    let frete = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
    frete += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
    const despesas = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;
    const valTotal = parseFloat(pegaValor('#txtValorLiq')) + parseFloat(frete) + parseFloat(despesas);
    // const valTotal = parseFloat(pegaValor('#txtValorLiq'));

    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      valParcelas += item[5];
    });

    if ((valCondicao + valParcelas) > valTotal) {
      insereValor('#txtValorCondicao', (valTotal - valParcelas).toFixed(2));
    }
  }

  function preencheComZero() {
    setTimeout(() => {
      $('.camposGrade').map((index) => {
        if ($($('.camposGrade')[index]).val() == '') {
          $($('.camposGrade')[index]).val('0');
        }

        $($('.camposGrade')[index]).on('focus', function () {
          if ($($('.camposGrade')[index]).val() == '0') {
            $($('.camposGrade')[index]).val('');
          }
        });

        $($('.camposGrade')[index]).on('focusout', function () {
          if ($($('.camposGrade')[index]).val() == '') {
            $($('.camposGrade')[index]).val('0');
          }
        });
      });
    }, 100);
  };

  function retornaPercDesc() {
    try {
      let desconto = parseFloat($('#txtDescontoEmprenho').val());
      let percDesconto = parseFloat($('#txtPercDesconto').val());
      if (desconto > 0) {
        let total = 0;
        $('#tabelaItens').DataTable().rows().data().map(item => {
          total += (item[7] * item[8]);
        });
        desconto = (desconto * 100) / total;
        return desconto;
      } else if (percDesconto > 0) {
        return percDesconto
      } else {
        return 0
      }
    } catch (error) {
      console.log(error);
    }
  }

  async function confirmaProduto() {
    $.LoadingOverlay('show');
    try {
      if ($('#cbRegraPromocao').prop('checked') && pegaChave('#txtTabelaPreco') === '999') {
        msgErro('Não é possível aplicar um desconto de uma regra de promoção se o preço for informado manualmente, favor informar uma tabela de preço.')
        return;
      }

      const valorUnit = $('#txtValor').val();

      if ($('#txtProduto').val() == '') {
        msgAlerta('Produto não informado, impossível continuar');
        return;
      }

      if (await produtoComStatusBloqueio(pegaChave('#txtProduto'))) {
        msgAlerta('Produto com Status de bloqueio para digitação de pedidos.');
        return;
      }

      if ($('#tabelaGradeProduto').DataTable().rows().count() == 0) {
        $('#modalItem').modal('hide');
        return;
      }

      if ((valorUnit == '') || (valorUnit == 0)) {
        msgAlerta('Preço não informado, impossível continuar.');
        return;
      }


      let grade = [];
      const listaDados = $('#tabelaGradeProduto').DataTable().data().toArray();
      listaDados.forEach(dado => {
        const objeto = Object.entries(dado);
        let coluna;
        const colunas = objeto.map(prop => prop[0]);

        for (let i = 0; i < colunas.length; i++) {
          if ((!['COR', 'DESC_COR'].includes(colunas[i])) && (colunas[i].indexOf('/') == -1)) {
            coluna = RetornaIdTamFormatado(colunas[i], true);
            const idSemFormatacao = dado[colunas[i]].split('id="')[1].replace('"', '');
            const idFormatado = idSemFormatacao.split(" value=")[0];
            const retorno = {
              CODIGO: pegaChave('#txtProduto'),
              DESCRICAO: pegaDescricao('#txtProduto'),
              COR: dado.COR,
              DESC_COR: dado.DESC_COR,
              TAM: coluna,
              QTDE: parseFloat($(`#${idFormatado}`).val().replaceAll(",", ".")),
              PRECO: valorUnit,
              TIPO: 'P',
              OBSERVACAO: pegaValor('#txtObsItem')
            };
            grade.push(retorno);
          }
        }
      });

      let listaValidaEstoque = [];

      const dataAdd = $('#tabelaItens').DataTable().data().toArray();

      for (i = 0; i < grade.length; i++) {
        let item = grade[i];
        if (item.QTDE > 0) {
          listaValidaEstoque.push({
            CODIGO: item.CODIGO,
            COR: item.COR,
            TAM: item.TAM,
            QTDE: item.QTDE,
            DEPOSITO: pegaChave('#txtDeposito'),
            NUMERO: $('#txtNumero').val()
          });
          try {
            const validaItemExistente = dataAdd.find(e => e[0] == item.CODIGO &&
              e[2] == item.COR &&
              e[4] == item.TAM &&
              e[8] == parseFloat(item.PRECO));

            if (validaItemExistente != undefined) {
              msgErro(`Código: ${item.CODIGO}\nCor: ${item.COR}\nTamanho: ${item.TAM}\nItem já adicionado ao pedido, caso queira alterar a quantidade é necessário excluí-lo e adicioná-lo novamente.`);
              return;
            }
          } catch (e) {
            console.log(e);
          }
        }
      }
      const parametroValidaEstoque = await CopiaParametro('PEDIDO', 3);
      if (parametroValidaEstoque != '0' && listaValidaEstoque.length > 0) {

        let response = await requisicao("POST", `/Sisplan/pedido/V1/validaestoque?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify({ LISTAITENSPEDIDO: listaValidaEstoque }))}&PARAMETRO_ESTOQUE=${parametroValidaEstoque}`);

        if (!response) {
          return;
        }

        let msgResposta = await response.json();
        if (response.status != 200) {
          msgErro(msgResposta.mensagem);
          return;
        }
      }
      if ($('#cbRegraPromocao').prop('checked')) {
        grade = await aplicaRegraPromocao(grade)
      }

      let listaPrecosZerados = [];

      const desconto = parseFloat(coalesce($('#txtDescontoProd').val()));
      const precoOrig = parseFloat(coalesce($('#txtValorOrig').val()));

      for (i = 0; i < grade.length; i++) {
        let item = grade[i];
        if (parseFloat(item.QTDE) > 0) {
          if (BuscaPorCorETam == '1' && !$('#cbRegraPromocao').prop('checked')) {
            let precoBusca = await buscaValor('PRECO_COR_TAM', 'PRECO', `REGIAO = '${pegaChave('#txtTabelaPreco')}' AND CODIGO = '${item.CODIGO}' AND COR = '${item.COR}' AND TAM`, item.TAM);
            item.PRECO = precoBusca != '' ? precoBusca.PRECO : 0;
          }
          if (item.PRECO == 0) {
            item.PRECO = valorUnit;
            listaPrecosZerados.push({ cor: item.COR, tam: item.TAM });
          }
          item.QTDE_F = 0;
          item.QTDE_CANC = 0;
          item.PRECO_ORIG = parseFloat(valorUnit);
          item.DESC_ITEM = desconto;
          if (item.DESC_ITEM > 0) {
            item.PRECO_ORIG = precoOrig;
            item.PRECO = valorUnit;
          }
          item.QUALIDADE = '1';
          addItem(item);
        }
      };

      let precosZerados = '';
      let corAnterior = '';

      try {
        listaPrecosZerados.map((e) => {
          if (e.cor != corAnterior) {
            if (corAnterior != '') {
              precosZerados = precosZerados.substring(0, precosZerados.length - 2);
              precosZerados += '\n';
            }
            precosZerados += `Cor: ${e.cor} - Tamanho(s): `;
          }
          precosZerados += `${e.tam}, `;
          corAnterior = e.cor;
        })

        precosZerados = precosZerados.substring(0, precosZerados.length - 2);
        if (precosZerados != '' && listaPrecosZerados.length > 0) {
          msgErro(`Os preços das seguintes cores e tamanhos estão zerados em seus cadastros na tabela de preço, portanto foram substituídos pelo Valor Unitário (${valorUnit}): \n${precosZerados}`);
        }
      } catch (e) {
        console.log(e);
      }

      $('#modalItem').modal('hide');

      var customTooltip = $('<span class="custom-tooltip"></span>').appendTo('body');
      $('#tabelaItens tbody tr').mouseover(async function () {
        let obs = $('#tabelaItens').DataTable().row($(this)).data()[11]
        // function sleep(ms) {
        //   return new Promise(resolve => setTimeout(resolve, ms));
        // }
        // await sleep(50);
        if (obs) {
          customTooltip.text(obs)
            .css({
              top: $(this).offset().top - customTooltip.outerHeight(),
              left: $(this).offset().left,
            })
            .show();
        }
      })

      $('#tabelaItens tbody').on('mouseout', 'tr', function () {
        customTooltip.hide();
      });

    } finally {
      // $('#txtValor').val('');
      $.LoadingOverlay('hide');
    }
  };

  async function confirmaProdutoLote() {
    $.LoadingOverlay('show');
    let fechaModal = true;
    try {
      const valorUnit = parseFloat(coalesce($('#txtValorLote').val()));

      if (await produtoComStatusBloqueio(pegaChave('#txtProdutoLote'))) {
        msgAlerta('Produto com Status de bloqueio para digitação de pedidos.');
        return;
      }

      if ($('#tabelaItensLote').DataTable().rows().count() == 0) {
        $('#modalItemLote').modal('hide');
        return;
      }

      if ((valorUnit == '') || (valorUnit == 0)) {
        msgAlerta('Preço não informado, impossível continuar.');
        fechaModal = false;
        return;
      }

      const itensAdd = [];

      $('#tabelaItensLote').DataTable().rows().every(function () {
        var $linha = $(this.node());
        var input = $linha.find('.campoQtdeLote');
        var val = parseFloat(input.val());

        if (!isNaN(val) && val > 0) {
          this.data().QTDE = val;
          itensAdd.push(this.data());
        }
      });

      if (itensAdd.length == 0) {
        msgAlerta('Necessário colocar quantidade em algum lote, favor verificar.');
        return;
      }

      const dataAdd = $('#tabelaItens').DataTable().data().toArray();

      for (i = 0; i < itensAdd.length; i++) {
        let item = itensAdd[i];
        if (item.QTDE > 0) {
          try {
            const validaItemExistente = dataAdd.find((e, idx) => (e[0] == item.CODIGO) && (e[2] == item.COR) && (e[19] == pegaValor('#rgQualidade')) && (e[4] == item.TAM) && (pegaValor(`#txtLote_${idx + 1}`) == item.LOTE));
            if (validaItemExistente) {
              msgErro(`Código: ${item.CODIGO}\nCor: ${item.COR}\nTamanho: ${item.TAM}\nLote: ${item.LOTE}\nItem já adicionado ao pedido, caso queira alterar a quantidade ou o preço é necessário editar o mesmo.`);
              return;
            }
          } catch (e) {
            console.log(e);
          }
        }
      }

      itensAdd.map(async item => {
        await reservaProduto(item.ID, item.QTDE);
        addItem({
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          TAM: item.TAM,
          DEPOSITO: item.DEPOSITO,
          LOTE: item.LOTE,
          QTDE: item.QTDE,
          PRECO: pegaValor('#txtValorLote'),
          TIPO: 'P',
          OBSERVACAO: '',
          QTDE_F: 0,
          QTDE_CANC: 0,
          PRECO_ORIG: pegaValor('#txtValorLote'),
          DESC_ITEM: 0,
          QUALIDADE: pegaValor('#rgQualidade')
        });
      });

    } finally {
      if (fechaModal) {
        $('#modalItemLote').modal('hide');
      }
      $.LoadingOverlay('hide');
    }
  };

  async function reservaProduto(idEstoque, qtde) {
    try {
      await requisicao(
        "POST",
        "/sisplan/vendas/v1/reservaproduto?",
        `ID_ESTOQUE=${idEstoque}&QUANTIDADE=${qtde}`
      );
    } catch (error) {
      console.error(error);
    }
  }

  async function deletaReservaProduto() {
    try {
      await requisicao(
        "DELETE",
        "/sisplan/vendas/v1/deletareserva?",
        ''
      );
    } catch (error) {
      console.error(error);
    }
  }

  async function aplicaRegraPromocao(grade) {
    try {

      const objGrade = grade.map(e => {
        const obj = { ...e, DESCCOR: e.DESC_COR }
        delete obj.DESC_COR
        return obj
      })

      const pedido = {
        ITENS: objGrade,
        TAB_PRE: pegaChave('#txtTabelaPreco')
      }
      const response = await requisicao('POST', '/Sisplan/pedido/V1/aplicaregrapromocao?', '', JSON.stringify(pedido))

      const jsonStr = await response.json()

      return jsonStr

    } catch (e) {
      msgErro('Ocorreu um problema ao aplicar o desconto da regra de promoção, tente novamente.')
    }
  }

  async function confirmaMaterial() {
    try {

      if ($('#txtQtde').val() == '') {
        msgAlerta('Quantidade não informada, impossível continuar.');
        return;
      }

      if ($('#txtMaterial').val() == '') {
        msgAlerta('Material não informado, impossível continuar.');
        return;
      }

      if ($('#txtCor').val() == '') {
        msgAlerta('Cor não informada, impossível continuar.');
        return;
      }

      if (($('#txtValorMat').val() == '') || ($('#txtValorMat').val() == 0)) {
        msgAlerta('Preço não informado, impossível continuar.');
        return;
      }

      const dataAdd = $('#tabelaItens').DataTable().data().toArray();

      if ($('#txtQtde').val() > 0) {
        try {
          const validaItemExistente = dataAdd.find(e => e[0] == pegaChave('#txtMaterial') && e[2] == pegaChave('#txtCor'));

          if (validaItemExistente != undefined) {
            msgErro(`Item já adicionado ao pedido, caso queira alterar a quantidade é necessário excluí-lo e adicioná-lo novamente.`);
            return;
          }
        } catch (e) {
          console.log(e);
        }
      }

      const parametroValidaEstoque = await CopiaParametro('PEDIDO', 3);

      if (parametroValidaEstoque != '0') {

        let qtdeEstoqueMat = (await buscaValor('MAT_ITEN', 'COALESCE(SUM(QTDE), 0) QTDE', `CODIGO = '${pegaChave('#txtMaterial')}' AND COR = '${pegaChave('#txtCor')}' AND DEPOSITO`, pegaChave('#txtDeposito'))).QTDE;
        let qtdePendente = 0;

        if (parametroValidaEstoque == '1') {
          qtdePendente = (await buscaValor('PED_ITEN', 'COALESCE(SUM(QTDE), 0) QTDE', `CODIGO = '${pegaChave('#txtMaterial')}' AND COR = '${pegaChave('#txtCor')}' AND NUMERO <> '${$('#txtNumero').val()}' AND DEPOSITO`, pegaChave('#txtDeposito'))).QTDE;
        }

        const qtdeDisponivel = qtdeEstoqueMat - qtdePendente;

        if (qtdeDisponivel < (parseFloat($('#txtQtde').val()))) {
          msgErro(`Quantidade informada é maior que a disponível. Impossível continuar.`);
          return;
        }
      }

      addItem({
        CODIGO: pegaChave('#txtMaterial'),
        DESCRICAO: pegaDescricao('#txtMaterial'),
        COR: pegaChave('#txtCor'),
        DESC_COR: pegaDescricao('#txtCor'),
        TAM: '0',
        QTDE: $('#txtQtde').val(),
        PRECO: $('#txtValorMat').val(),
        PRECO_ORIG: $('#txtValorMatOrig').val(),
        TIPO: 'M',
        OBSERVACAO: pegaValor('#txtObsItem'),
        QTDE_F: 0,
        QTDE_CANC: 0,
        DESC_ITEM: coalesce($('#txtDescMat').val()),
        QUALIDADE: '1'
      });

    } finally {
      $('#modalItem').modal('hide');
    }
  };

  $('#txtDescMat').on('blur', function () {
    const desconto = parseFloat(coalesce($('#txtDescMat').val()));
    const preco = parseFloat(coalesce($('#txtValorMatOrig').val()));
    const novoPreco = preco - desconto;

    if (novoPreco < 0) {
      $('#txtDescMat').val('0');
      msgAlerta('Preço - desconto não pode ser menor que zero.');
      return;
    }

    $('#txtValorMat').val(novoPreco);
  });

  $('#txtDescontoProd').on('blur', function () {
    const desconto = parseFloat(coalesce($('#txtDescontoProd').val()));
    const preco = parseFloat(coalesce($('#txtValorOrig').val()));
    const novoPreco = preco - desconto;

    if (novoPreco < 0) {
      $('#txtValor').val('0');
      msgAlerta('Preço - desconto não pode ser menor que zero.');
      return;
    }

    $('#txtValor').val(novoPreco);
  });

  function bloqueiaCampoNumero() {
    $('#txtNumero').prop('disabled', true);
    $('#txtNumero').prop('readonly', true);
  }

  function bloqueiaCampoTabela() {
    if ($('#tabelaItens').DataTable().rows().count() > 0) {
      $('#txtTabelaPreco').prop('disabled', true);
      $('#txtTabelaPreco').prop('readonly', true);
      $('#btn-limpa-TabelaPreco').prop('disabled', true);
      $('#btn-limpa-TabelaPreco').prop('readonly', true);
      $('#btn-TabelaPreco').prop('disabled', true);
      $('#btn-TabelaPreco').prop('readonly', true);
      $('#checkPrecoManual').prop('disabled', true);
      $('#checkPrecoManual').prop('readonly', true);
    }
  }

  function addItem(sItem, precoTabPreco = 0) {
    const table = $('#tabelaItens').DataTable();

    const rowNode = table.row.add([
      sItem.CODIGO,
      sItem.DESCRICAO,
      sItem.COR,
      sItem.DESC_COR,
      sItem.TAM,
      retornaInputDeposito(sItem?.DEPOSITO),
      retornaInputLote(sItem?.ID, sItem?.LOTE),
      sItem.QTDE,
      sItem.PRECO,
      sItem.TIPO,
      retornaFotoProduto(sItem.CODIGO, sItem.COR + sItem.TAM),
      sItem.OBSERVACAO,
      sItem.QTDE_F,
      sItem.QTDE_CANC,
      sItem.ORDEM ?? 1,
      precoTabPreco != 0 ? precoTabPreco : sItem.PRECO_ORIG,
      0,
      coalesce(sItem.DESC_ITEM),
      retornaFotoCorProduto(sItem.CODIGO, sItem.COR + sItem.TAM, sItem.COR),
      sItem.QUALIDADE || '1'
    ]).draw(false).node();

    const input = $(rowNode).find('[id^="txtLote_"]');
    const inputDeposito = $(rowNode).find('[id^="txtDeposito_"]');

    if (input.length) {
      const idItem = input.attr('id').split('_')[1];
      const codigo = sItem.CODIGO;
      const cor = sItem.COR;
      const tam = sItem.TAM;

      pesquisaLote(input, idItem, sItem.TIPO, codigo, cor, tam, inputDeposito.val())
    }

    if (inputDeposito.length) {
      const idItemDeposito = inputDeposito.attr('id').split('_')[1];
      pesquisaDeposito(inputDeposito, idItemDeposito);
    }

    atualizaValorTotalPedido();
  }

  function retornaPesquisaDeposito() {
    const selectLote = {
      tabela: "DEPOSITO",
      camposSelect: [
        "CODIGO",
        "DESCRICAO"
      ]
    };

    return `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(selectLote)}`;
  }

  function retornaPesquisaLote(tipo, codigo, cor, tam, deposito) {
    let tabela = 'PED_ITEN';
    const sDeposito = deposito ? deposito : pegaChave('#txtDeposito');

    if (bReserva) {
      tabela = 'PED_RESERVA';
    }

    let selectLote = {
      tabela: "MAT_ITEN",
      camposSelect: [
        "MAT_ITEN.LOTE",
        "MAT_ITEN.QTDE ESTOQUE",
        `SUM(COALESCE(${tabela}.QTDE, 0)) RESERVA`,
        `(MAT_ITEN.QTDE - SUM(COALESCE(${tabela}.QTDE, 0))) EST_DISPONIVEL`
      ],
      leftJoin: [{
        tabela: tabela,
        condicao: `${tabela}.CODIGO = MAT_ITEN.CODIGO AND ${tabela}.COR = MAT_ITEN.COR AND ${tabela}.LOTE = MAT_ITEN.LOTE AND ${tabela}.DEPOSITO = MAT_ITEN.DEPOSITO AND ${tabela}.TIPO = 'M'`
      }],
      where: [
        `MAT_ITEN.CODIGO = '${codigo}'`,
        `MAT_ITEN.COR = '${cor}'`,
        `MAT_ITEN.DEPOSITO = '${sDeposito}'`,
        `MAT_ITEN.QTDE > 0`
      ],
      groupBy: [
        "MAT_ITEN.LOTE",
        "MAT_ITEN.QTDE"
      ],
      having: [`(MAT_ITEN.QTDE - SUM(COALESCE(${tabela}.QTDE, 0))) > 0`]
    };

    if (tipo == 'P') {
      selectLote = {
        tabela: "PA_ITEN",
        camposSelect: [
          "PA_ITEN.LOTE",
          "PA_ITEN.QUANTIDADE ESTOQUE",
          `SUM(COALESCE(${tabela}.QTDE, 0)) RESERVA`,
          `(PA_ITEN.QUANTIDADE - SUM(COALESCE(${tabela}.QTDE, 0))) EST_DISPONIVEL`
        ],
        leftJoin: [{
          tabela: tabela,
          condicao: `${tabela}.CODIGO = PA_ITEN.CODIGO AND ${tabela}.COR = PA_ITEN.COR AND ${tabela}.LOTE = PA_ITEN.LOTE AND ${tabela}.TAM = PA_ITEN.TAM AND ${tabela}.DEPOSITO = PA_ITEN.DEPOSITO AND ${tabela}.TIPO = 'P'`

        }],
        where: [
          `PA_ITEN.CODIGO = '${codigo}'`,
          `PA_ITEN.COR = '${cor}'`,
          `PA_ITEN.TAM = '${tam}'`,
          `PA_ITEN.DEPOSITO = '${sDeposito}'`,
          `PA_ITEN.QUANTIDADE > 0`
        ],
        groupBy: [
          "PA_ITEN.LOTE",
          "PA_ITEN.QUANTIDADE"
        ],
        having: [`(PA_ITEN.QUANTIDADE - SUM(COALESCE(${tabela}.QTDE, 0))) > 0`]
      };
    }

    return `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(selectLote)}`;
  }


  function addCondicao(sItem) {
    const inputData = `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataRec-${$('#tabelaCondicao').DataTable().rows().count() + 1}" name="txtDataRec-${$('#tabelaCondicao').DataTable().rows().count() + 1}" value="${sItem.DT_VENCTO}"></input>`;
    $('#tabelaCondicao').DataTable().row.add(
      [
        sItem.DIAS,
        inputData,
        sItem.MOEDA,
        sItem.CODCOND,
        sItem.DESCCOND,
        sItem.VALOR
      ]).draw(false);
  };

  async function buscaFotoProduto(codigo, ordem) {
    const codigoFormatado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    try {
      const urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
      const response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        return;
      }

      const sBase64 = jsonStr;
      $(`#${codigoFormatado}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

    } catch (error) {
      console.error(error);
      $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
  };

  function retornaFotoProduto(codigo, ordem) {
    buscaFotoProduto(codigo, ordem);
    const codigoCriptografado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    return `<img class="imagem" id="${codigoCriptografado}" src="dist/img/prod-1.png" loading="lazy" alt="" height="75" width="75"/>`
  };

  function criptografaCodigo(codigo) {
    return btoa(codigo).replaceAll('=', '');
  };

  function retornaFotoCorProduto(codigo, ordem, cor) {
    buscaFotoCorProduto(codigo, ordem, cor);
    const codigoCriptografado = criptografaCodigo('img_cor_prod_' + codigo + '_' + ordem);
    return `<img class="imagem" id="${codigoCriptografado}" src="dist/img/prod-1.png" loading="lazy" alt="" height="75" width="75"/>`
  };

  async function buscaFotoCorProduto(codigo, ordem, cor) {
    const codigoFormatado = criptografaCodigo('img_cor_prod_' + codigo + '_' + ordem);
    try {
      const urlRequisicao = '/Sisplan/Funcoes/v1/FotoCorVenda?';
      const response = await requisicao('GET', urlRequisicao, `codigo=${codigo}&cor=${cor}`, null);

      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if ((response.status != 200) || (jsonStr.codigo == 400)) {
        $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        return;
      }

      const sBase64 = jsonStr;
      $(`#${codigoFormatado}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

    } catch (error) {
      console.error(error);
      $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
  };

  function botaoExcluir() {
    return '<div class="divBtnOpcoes"> ' +
      '       <button class="botaoOpcoes btn-excluir" type="button" title="Excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     </div>';
  };

  async function validacaoElemento(validator, index) {
    const form = $($("#msform fieldset")[index])
    camposObrigatorios = await retornaCamposObrigatorios('pedido');

    if (camposObrigatorios) {
      if (camposObrigatorios.length > 0) {
        for (let i = 0; i < camposObrigatorios.length; i++) {
          const campo = $(`#${camposObrigatorios[i]}`);
          if (form.find(campo).length > 0) {
            if (!campo.val()) {
              validator.element(campo)
              return false
            }
          }
        };
      };
    }

    return true
  }

  let contaFs = 1;
  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let pedido = parametros[parametros.length - 1];

  if (pedido != '' && pedido != 'create') {

    $('#personal').css('cursor', 'pointer');
    $('#infoicon').css('cursor', 'pointer');
    $('#payment').css('cursor', 'pointer');
    $('#confirm').css('cursor', 'pointer');
    $('#account').css('cursor', 'pointer');

  };

  $('#account').on('click', function () {
    if (pedido != 'create') {
      if (contaFs == 2) {
        $('#VoltarGeral').trigger('click');
      }
      if (contaFs == 3) {
        $('#voltarComercial').trigger('click');
        $('#VoltarGeral').trigger('click');
      }
      if (contaFs == 4) {
        $('#ultimoVoltar').trigger('click');
        $('#voltarComercial').trigger('click');
        $('#VoltarGeral').trigger('click');
      }
      if (contaFs == 5) {
        $('#voltarItens').trigger('click');
        $('#ultimoVoltar').trigger('click');
        $('#voltarComercial').trigger('click');
        $('#VoltarGeral').trigger('click');
      }
    }
  });

  $('#personal').on('click', function () {
    if (pedido != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
      }
      if (contaFs == 3) {
        $('#voltarComercial').trigger('click');
      }
      if (contaFs == 4) {
        $('#ultimoVoltar').trigger('click');
        $('#voltarComercial').trigger('click');
      }
      if (contaFs == 5) {
        $('#voltarItens').trigger('click');
        $('#ultimoVoltar').trigger('click');
        $('#voltarComercial').trigger('click');
      }
    }
  });

  $('#infoicon').on('click', function () {
    if (pedido != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
        $('#avancarComercial').trigger('click');
      }
      if (contaFs == 2) {
        $('#avancarComercial').trigger('click');
      }
      if (contaFs == 4) {
        $('#ultimoVoltar').trigger('click');
      }
      if (contaFs == 5) {
        $('#voltarItens').trigger('click');
        $('#ultimoVoltar').trigger('click');
      }
    }
  });

  $('#payment').on('click', function () {
    if (pedido != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
        $('#avancarComercial').trigger('click');
        $('#avancarItens').trigger('click');
      }
      if (contaFs == 2) {
        $('#avancarComercial').trigger('click');
        $('#avancarItens').trigger('click');
      }
      if (contaFs == 3) {
        $('#avancarItens').trigger('click');
      }
      if (contaFs == 5) {
        $('#voltarItens').trigger('click');
      }
    }
  });

  $('#confirm').on('click', async function () {
    if (pedido != 'create') {
      if (contaFs == 1) {
        await avancarComDelay('#avancar1');
        await avancarComDelay('#avancarComercial');
        await avancarComDelay('#avancarItens');
        await avancarComDelay('#avancarPagamento');
        $($('fieldset')[0]).css('display', 'none');
      }
      if (contaFs == 2) {
        await avancarComDelay('#avancarComercial');
        await avancarComDelay('#avancarItens');
        await avancarComDelay('#avancarPagamento');
      }
      if (contaFs == 3) {
        await avancarComDelay('#avancarItens');
        await avancarComDelay('#avancarPagamento');
      }
      if (contaFs == 4) {
        await avancarComDelay('#avancarPagamento');
      }
    }
  });

  async function avancarComDelay(selector) {
    $(selector).trigger('click');
    return new Promise(resolve => setTimeout(resolve, 80));
  }

  async function adicionaPaginacao() {
    $(".next").click(async function () {
      let validator = $("#msform").validate();
      let liberado = true;

      if ($(this).attr("id") == "avancar1") {
        validator.element("#txtNumero");
        validator.element("#txtCliente");
        validator.element("#txtRepresentante");
        validator.element("#rgTransportador");
        const validacaoObrigatorios = await validacaoElemento(validator, 0);
        if (!(validator.element("#txtNumero") && validator.element("#txtCliente") && validator.element("#txtRepresentante") && validator.element("#rgTransportador") && validacaoObrigatorios)) {
          liberado = false;
        }
        if (parametroObrigaResponsavel == 1) {
          if ($('#txtResponsavel').val() == '') {
            throw msgAlerta('Necessário informar um responsável, verifique!')
          }
        }
      }

      if ($(this).attr("id") == "avancarComercial") {
        validator.element("#txtTabelaPreco");
        validator.element("#dtEmissao");
        validator.element("#dtFatura");
        validator.element("#dtEntrega");
        validator.element("#dtSaida");
        const validacaoObrigatorios = await validacaoElemento(validator, 1);
        if (!(validator.element("#txtTabelaPreco") && validator.element("#dtEmissao") && validator.element("#dtFatura") && validator.element("#dtEntrega") && validator.element("#dtSaida") && validacaoObrigatorios)) {
          liberado = false;
        }
      }

      if ($(this).attr("id") == "avancarItens") {
        validator.element("#txtDeposito");
        validator.element("#txtStatus");
        const validacaoObrigatorios = await validacaoElemento(validator, 2);
        if (!(validator.element("#txtDeposito") && validator.element("#txtStatus") && validacaoObrigatorios)) {
          liberado = false;
        }
      }

      if (liberado) {
        contaFs += 1;

        let validator = $("#msform").validate();
        validator.form();

        currentFs = $(this).parent();
        nextFs = $(this).parent().next();

        // $("#progressbar li").eq($(".msfieldset").index(currentFs)).addClass("active");
        $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

        nextFs.show();
        currentFs.animate({
          opacity: 0
        }, {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600
        });

      }
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      contaFs -= 1;
      currentFs = $(this).parent();
      previousFs = $(this).parent().prev();

      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");

      previousFs.show();

      currentFs.animate({
        opacity: 0,
      }, {
        step(now) {
          opacity = 1 - now;

          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      });
    });
  };

  function adicionaValidacoes() {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtNumero: {
          required: true,
        },
        txtCliente: {
          required: true,
        },
        txtRepresentante: {
          required: true,
        },
        rgTransportador: {
          required: true,
        },
        txtTabelaPreco: {
          required: true,
        },
        txtMoeda: {
          required: true,
        },
        dtEmissao: {
          required: true,
        },
        dtFatura: {
          required: true,
        },
        dtEntrega: {
          required: true,
        },
        dtSaida: {
          required: true,
        },
        txtCondPagto1: {
          required: true,
        },
        txtDeposito: {
          required: true,
        },
        txtStatus: {
          required: true,
        }
      },
      messages: {
        txtNumero: {
          required: "Informe um número.",
        },
        txtCliente: {
          required: "Informe um cliente.",
        },
        txtRepresentante: {
          required: "Informe um representante.",
        },
        rgTransportador: {
          required: "Informe um transportador.",
        },
        txtTabelaPreco: {
          required: "Informe uma tabela de preço.",
        },
        txtMoeda: {
          required: "Informe uma moeda.",
        },
        dtEmissao: {
          required: "Informe uma data.",
        },
        dtFatura: {
          required: "Informe uma data.",
        },
        dtEntrega: {
          required: "Informe uma data.",
        },
        dtSaida: {
          required: "Informe uma data.",
        },
        txtCondPagto1: {
          required: "Informe um vencimento.",
        },
        txtDeposito: {
          required: "Informe um depósito.",
        },
        txtStatus: {
          required: "Informe um status.",
        }
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });
  };

  function adicionaMascaraCampos() {
    $('.maskDecimais').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.maskDecimaisParametro').maskMoney({
      decimal: ".",
      thousands: "",
      precision: quantidadeCasasDecimaisCampo > 2 ? quantidadeCasasDecimaisCampo : 2,
    });

    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0.00');
      }
    });

    $('.maskDecimaisParametro').on('blur', function () {
      if ($(this).val() == '' && quantidadeCasasDecimaisCampo > 2) {
        const zero = 0;
        $(this).val(zero.toFixed(quantidadeCasasDecimaisCampo));
      } else if ($(this).val() == "") {
        $(this).val('0.00');
      }
    });
  };

  if (parametroObrigaResponsavel == 1) {
    $('#labelResponsavel').html('Responsável *');
  }

  $('#txtAlterarDesconto').on('blur', function () {
    const desconto = parseFloat(coalesce($('#txtAlterarDesconto').val()));
    const preco = parseFloat(coalesce($('#txtPrecoOriginal').val()));
    const novoPreco = preco - desconto;

    if (novoPreco < 0) {
      $('#txtAlterarDesconto').val('0');
      msgAlerta('Preço - desconto não pode ser menor que zero.');
      return;
    }

    $('#txtAlterarPreco').val(novoPreco);
  });

  $('#btnConfirmarQtde').on('click', async function () {
    try {
      const novaQtde = $('#txtAlterarQtde').val() !== '' ? $('#txtAlterarQtde').val() : '0';
      const desconto = coalesce($('#txtAlterarDesconto').val());

      const table = $('#tabelaItens').DataTable();
      const rowNode = $('#txtIdAlterarQtde').data('rowNode');
      let data = table.row(rowNode).data();

      const tipo = data[9];

      const parametroValidaEstoque = await CopiaParametro('PEDIDO', 3);
      if (parametroValidaEstoque != '0') {
        if (tipo == 'P') {
          let listaValidaEstoque = [{
            CODIGO: data[0],
            COR: data[2],
            TAM: data[4],
            QTDE: parseFloat(novaQtde),
            DEPOSITO: $(rowNode).find('.txtDeposito').val() || pegaChave('#txtDeposito'),
            LOTE: $(rowNode).find('.txtLote').val() || '000000',
            NUMERO: $('#txtNumero').val()
          }];

          if (listaValidaEstoque.length > 0) {
            const response = await requisicao(
              "POST",
              `/Sisplan/pedido/V1/validaestoque?&CODUSUARIO=${getCookie('cod_usuario')}`,
              `&EMPRESA=${getCookie('empresa')}`,
              `JSON=${encodeURIComponent(JSON.stringify({ LISTAITENSPEDIDO: listaValidaEstoque }))}&PARAMETRO_ESTOQUE=${parametroValidaEstoque}`
            );

            if (!response) return;

            const msgResposta = await response.json();
            if (response.status != 200) {
              msgErro(msgResposta.mensagem);
              return;
            }
          }
        } else {
          const qtdeEstoqueMat = (await buscaValor(
            'MAT_ITEN',
            'COALESCE(SUM(QTDE), 0) QTDE',
            `CODIGO = '${data[0]}' AND COR = '${data[2]}' AND DEPOSITO`,
            pegaChave('#txtDeposito')
          )).QTDE;

          let qtdePendente = 0;
          if (parametroValidaEstoque == '1') {
            qtdePendente = (await buscaValor(
              'PED_ITEN',
              'COALESCE(SUM(QTDE), 0) QTDE',
              `CODIGO = '${data[0]}' AND COR = '${data[2]}' AND NUMERO <> '${$('#txtNumero').val()}' AND DEPOSITO`,
              pegaChave('#txtDeposito')
            )).QTDE;
          }

          const qtdeDisponivel = qtdeEstoqueMat - qtdePendente;

          if (qtdeDisponivel < parseFloat(novaQtde)) {
            msgErro('Quantidade informada é maior que a disponível. Impossível continuar.');
            return;
          }
        }
      }

      let precoRegra = '', precoFinal = '', precoTabelaAtual = '';
      const precoPromocionalAplicadoAnteriormente = data[16] ?? 0;
      const precoOriginal = data[15];
      const precoInput = $('#txtAlterarPreco').val() !== '' ? $('#txtAlterarPreco').val() : '0';

      if (precoInput <= 0) return msgAlerta('O preço não pode ser menor ou igual a zero. Verifique!');

      if (BuscaPorCorETam == 1) {
        precoTabelaAtual = await retornaPrecoCorTamProduto(pegaChave('#txtTabelaPreco'), data[0]);
      } else {
        precoTabelaAtual = await retornaPrecoProduto(pegaChave('#txtTabelaPreco'), data[0]);
      }

      if ($('#cbRegraPromocao').prop('checked')) {
        const obj = [{
          CODIGO: data[0],
          DESCRICAO: data[1],
          COR: data[2],
          DESC_COR: data[3],
          TAM: data[4],
          QTDE: novaQtde,
          PRECO: precoTabelaAtual,
          TIPO: data[9],
        }];
        precoRegra = await aplicaRegraPromocao(obj);
        if (precoRegra[0]?.PRECO) precoRegra[0].PRECO = TruncaDecimaisNova(2, precoRegra[0]?.PRECO);
      }

      if ((precoRegra[0]?.PRECO) && (precoPromocionalAplicadoAnteriormente != 0) && (precoPromocionalAplicadoAnteriormente != precoRegra[0]?.PRECO)) {
        precoFinal = precoInput != precoOriginal && precoInput != precoRegra[0]?.PRECO ? precoInput : precoRegra[0]?.PRECO;
        if (precoFinal === precoRegra[0]?.PRECO) data[16] = precoRegra[0]?.PRECO;
      } else if (precoInput != precoOriginal && precoInput != precoRegra[0]?.PRECO) {
        precoFinal = precoInput;
      } else if (precoRegra[0]?.PRECO) {
        data[15] = precoRegra[0]?.PRECO;
        precoFinal = precoRegra[0]?.PRECO;
      } else {
        precoFinal = precoTabelaAtual;
      }

      if (!precoFinal) precoFinal = precoInput;

      data[7] = novaQtde;
      data[8] = precoFinal;
      data[10] = retornaFotoProduto(data[0], data[2] + data[4]);
      data[17] = desconto;
      data[18] = retornaFotoCorProduto(data[0], data[2] + data[4], data[2]);

      if ($('#txtContemExpedicao').val() == 'S' && $('#txtQtdeOrig').val() > novaQtde) {
        msgErro(`Quantidade informada não pode ser menor que a quantidade anterior (${$('#txtQtdeOrig').val()}), pois o item contém expedição, impossível continuar.`);
        $('#txtAlterarQtde').val($('#txtQtdeOrig').val());
        data[7] = $('#txtQtdeOrig').val();
        return;
      }

      table.row(rowNode).data(data).draw(false);

      const input = $(rowNode).find('[id^="txtLote_"]');
      const inputDeposito = $(rowNode).find('[id^="txtDeposito_"]');

      if (input.length) {
        const idItem = input.attr('id').split('_')[1];
        pesquisaLote(input, idItem, data[9], data[0], data[2], data[4], inputDeposito.val());
      }

      if (inputDeposito.length) {
        const idItemDeposito = inputDeposito.attr('id').split('_')[1];
        pesquisaDeposito(inputDeposito, idItemDeposito);
      }

      $('#tabelaItens').DataTable().$('tr.selected').removeClass('selected');
      $('#modal-alterar-qtde').modal('hide');
      await atualizaValorTotalPedido();

    } catch (e) {
      msgErro(`Não foi possível alterar a quantidade: ${e}`);
      console.log(e);
    }
  });


  $('#tabelaItens tbody').unbind('click');
  $('#tabelaItens tbody').on('click', 'tr', function (event) {
    if ($('#tabelaItens').DataTable().data().length > 0) {
      if ($(this).hasClass('selected')) {
        if ($(event.target).is('input[id^="txtDeposito_"]')) return; //se o click for no input de depósito não deve remover a seleção por conta de eventos que utilizam o registro selecionado
        $(this).removeClass('selected');
        $('#txtValorTotalItem').val('');
      } else {
        $('#tabelaItens').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        calculaValorItem($("#tabelaItens").DataTable().row($(this)).data());
      }
    }
  });

  $('#txtRepresentante').on('blur', async function () {
    let represen = pegaChave('#txtRepresentante')
    let deposito = ''
    let regiao = ''

    if (represen) {
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"REPRESEN", 
        "camposSelect":["REGIAO, DEPOSITO, COMISSAO, COMISSAO2"], 
        "where": ["CODREP = '${represen}'"]}`, null);

      let jsonRepresen = await response.json();

      deposito = jsonRepresen.RESULT[0][0].DEPOSITO
      regiao = jsonRepresen.RESULT[0][0].REGIAO
      $('#txtComFat').val(jsonRepresen.RESULT[0][0].COMISSAO)
      $('#txtComRec').val(jsonRepresen.RESULT[0][0].COMISSAO2)
    }

    pegaChave('#txtDeposito') == '' ? deposito != '' ? insereValor('#txtDeposito', deposito, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: deposito }) : '' : ''
    pegaChave('#txtTabelaPreco') == '' ? regiao != '' ? insereValor('#txtTabelaPreco', regiao, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: regiao }) : '' : ''
  })

  function calculaValorItem(data) {
    try {
      $('#txtValorTotalItem').val(parseFloat(parseFloat(data[7]) * data[8]).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));
    } catch (e) {
      console.log(e);
    }
  };

  async function atualizaValorTotalPedido() {
    try {
      let total = 0;
      let desconto = 0;
      let desc = '';
      let qtdeTotal = 0
      desc = retornaDesconto();
      desconto = await reqRetornaDesconto(desc);
      const percDesc = retornaPercDesc();
      $('#tabelaItens').DataTable().rows().data().map(item => {
        total += (parseFloat(item[7]) * item[8]);
        qtdeTotal += (parseFloat(item[7]))
      });
      desconto = (total * ((desconto + percDesc) / 100));
      total = total - desconto;
      insereValor('#txtValorTotal', total.toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));
      insereValor('#txtQtdeTotal', isNaN(qtdeTotal) ? '0.00' : qtdeTotal.toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));
    } catch (error) {
      console.log(error);
    }
  }

  function adicionaEventosCampoQtdeGradeItens() {
    $('.camposGrade').off('blur');
    $('.camposGrade').on('blur', function () {
      preencheComZero();
    });

    $('.camposGrade').off('input');
    $(".camposGrade").on("input", function () {
      let inputValue = $(this).val();
      inputValue = inputValue.replace(/[^0-9.,]/g, '');
      const countCommaDot = (inputValue.match(/[.,]/g) || []).length;
      if (countCommaDot > 1) {
        inputValue = inputValue.replace(/[.,]$/, '');
      }
      $(this).val(inputValue);
      calculaTotalSelecionado()
      calculaValorSelecionado($(this).val(), pegaChave('#txtProduto'), $(this).attr('cor'), $(this).attr('tam'))
    })

    $('.camposGrade').off('focus')
    $('.camposGrade').on('focus', function () {
      calculaTotalSelecionado()
      calculaValorSelecionado($(this).val(), pegaChave('#txtProduto'), $(this).attr('cor'), $(this).attr('tam'))
    })
  }

  $('#btnCancelarQtde').on('click', function () {
    $('#modal-alterar-qtde').modal('hide');
  })

  async function preencheCondicao(condicao) {
    $.LoadingOverlay('show')
    try {
      $('#txtCondPagto1').val(condicao.substring(0, 3).replace(' ', ''))
      $('#txtCondPagto2').val(condicao.substring(3, 6).replace(' ', ''))
      $('#txtCondPagto3').val(condicao.substring(6, 9).replace(' ', ''))
      $('#txtCondPagto4').val(condicao.substring(9, 12).replace(' ', ''))
      $('#txtCondPagto5').val(condicao.substring(12, 15).replace(' ', ''))
      $('#txtCondPagto6').val(condicao.substring(15, 18).replace(' ', ''))
      $('#txtCondPagto7').val(condicao.substring(18, 21).replace(' ', ''))
      $('#txtCondPagto8').val(condicao.substring(21, 24).replace(' ', ''))
      $('#txtCondPagto9').val(condicao.substring(24, 27).replace(' ', ''))
      $('#txtCondPagto10').val(condicao.substring(27, 30).replace(' ', ''))
      $('#txtCondPagto11').val(condicao.substring(30, 33).replace(' ', ''))
      $('#txtCondPagto12').val(condicao.substring(33, 36).replace(' ', ''))
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  async function adicionaPesquisaAutocompleta() {

    $("#txtAddRepresentante").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": [] }`);
    $("#btnAddRepresentante").pesquisa("#txtAddRepresentante", "CODREP", "NOME", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', "Pesquisa Representante", "REPRESEN");
    $("#btnLimpaAddRepresentante").on('click', function () { $('#txtAddRepresentante').val(''); });

    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
    $('#btn-cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, 'Pesquisa Cliente');
    $('#btn-limpa-cliente').on('click', function () { $('#txtCliente').val('') });

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
    $('#btn-representante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": ["ATIVO = 'S' "]}`, 'Pesquisa Representante', 'represen');
    $('#btn-limpa-representante').on('click', function () { $('#txtRepresentante').val('') });

    $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null}`);
    $('#btn-transportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Transportadora', 'tabtran');
    $('#btn-limpa-transportadora').on('click', function () { $('#txtTransportadora').val('') });

    $('#txtRedesp').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null}`);
    $('#btn-Redesp').pesquisa('#txtRedesp', 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Redesp', 'tabtran');
    $('#btn-limpa-Redesp').on('click', function () { $('#txtRedesp').val('') });

    $('#txtResponsavel').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
    $('#btn-Responsavel').pesquisa_serverside(['#txtResponsavel', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, 'Pesquisa Responsável');
    $('#btn-limpa-Responsavel').on('click', function () { $('#txtResponsavel').val('') });

    $('#txtPrazoEnt').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PrazoEnt').pesquisa('#txtPrazoEnt', 'PRAZO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO" ], "where": null}', 'Pesquisa Prazo', 'tabprz');
    $('#btn-limpa-PrazoEnt').on('click', function () { $('#txtPrazoEnt').val('') });

    $('#txtPrazoProd').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PrazoProd').pesquisa('#txtPrazoProd', 'PRAZO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO" ], "where": null}', 'Pesquisa Prazo', 'tabprz');
    $('#btn-limpa-PrazoProd').on('click', function () { $('#txtPrazoProd').val('') });

    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S'"]}`);
    $('#btn-Colecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Coleção', 'colecao');
    $('#btn-limpa-Colecao').on('click', function () { $('#txtColecao').val('') });

    if (!existeValorEmpValor('REGIAO')) {
      $('#txtTabelaPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
      $('#btn-TabelaPreco').pesquisa('#txtTabelaPreco', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}', 'Pesquisa Tabela de Preço', 'REGIAO');
      $('#btn-limpa-TabelaPreco').on('click', function () { $('#txtTabelaPreco').val('') });
    } else {
      $('#txtTabelaPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO.REGIAO CHAVE, REGIAO.DESCRICAO"], "innerjoin": [{"tabela": "EMP_VALOR", "alias": "EMP", "condicao": "EMP.VALOR = REGIAO.REGIAO AND EMP.TABELA = 'REGIAO' AND EMP.EMP_ID = ${getCookie('emp_id')}"}], "where": null}`);
      $('#btn-TabelaPreco').pesquisa('#txtTabelaPreco', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "innerjoin": [{"tabela": "EMP_VALOR", "alias": "EMP", "condicao": "EMP.VALOR = REGIAO.REGIAO AND EMP.TABELA = 'REGIAO' AND EMP.EMP_ID = ${getCookie('emp_id')}"}], "where": null}`, 'Pesquisa Tabela de Preço', 'REGIAO');
      $('#btn-limpa-TabelaPreco').on('click', function () { $('#txtTabelaPreco').val('') });
    }

    const listaMoedasEmpresa = await retornaMoedasEmpresa();

    let where = ''
    if (listaMoedasEmpresa.length > 0) {
      where = `AND CODMOE IN (${listaMoedasEmpresa.toString()})`;
    }

    $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S' ${where}"]}`);
    $('#btn-Moeda').pesquisa('#txtMoeda', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": ["ativo = 'S' ${where}"]}`, 'Pesquisa Moeda', 'moeda');
    $('#btn-limpa-Moeda').on('click', function () { $('#txtMoeda').val('') });

    $('#txtCondicao').on('focusout', async function () {
      // geraCondicoes();

      let habilita = pegaChave('#txtCondicao') != '';
      if (habilita) {
        await buscaCondicao(pegaChave('#txtCondicao'));
      };
      $('#txtNrParcelas').prop('disabled', habilita);
      $('#txtNrParcelas').prop('disabled', habilita);
      $('#txtIntervaloDias').prop('disabled', habilita);
      atualizaData();
      // $('#btnAtualizar').trigger('click');
    });

    $('#txtMoeda').on('blur', async function () {
      if (!$(this).val()) {
        return
      }
      if (temCondicaoEntidade) {
        temCondicaoEntidade = false;
      }
      $('#txtNrParcelas').val('0');
      $('#txtIntervaloDias').val('0');
      await atualizaData();
      $('#txtCondicao').unbind('autocompleta');
      $('#txtCondicao').autocompleta(1, `JSON={ "tabela":"COND_MOEDA", "camposSelect":["COND_MOEDA.CODCOND CHAVE, CONDICAO.DESCRICAO DESCRICAO"], "innerjoin": [{ "tabela" : "CONDICAO", "condicao" : "COND_MOEDA.CODCOND = CONDICAO.CODCOND" }],"where": [] }`, [], [], []);
      $('#btn-Condicao').off();
      $('#btn-Condicao').unbind('pesquisa');
      $('#btn-Condicao').pesquisa_array(['#txtCondicao'], ['CODCOND'], ['DESCRICAO'],
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"COND_MOEDA", 
                                    "camposSelect":[ "COND_MOEDA.CODCOND", "CONDICAO.DESCRICAO" ],
                                    "innerjoin": [{ "tabela" : "CONDICAO", "condicao" : "COND_MOEDA.CODCOND = CONDICAO.CODCOND" }], 
                                    "where": ["COND_MOEDA.MOEDA = '${pegaChave('#txtMoeda')}'"]}`, 'Pesquisa Condição', 'COND_MOEDA');
      habilitaCondicoes();

      $.LoadingOverlay('show')
      try {
        const dadosSelect = {
          tabela: 'MOEDA',
          camposSelect: ['HISTORICO', 'CODSIT', 'CLASSE'],
          where: [`CODMOE = ${pegaChave('#txtMoeda')}`]
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
          return;
        }
        if (retornoSelect.length == 0) {
          return;
        }

        insereValor('#txtSitDup', retornoSelect[0].CODSIT, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: retornoSelect[0].CODSIT });
        insereValor('#txtHistorico', retornoSelect[0].HISTORICO, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: retornoSelect[0].HISTORICO });
        insereValor('#txtClasseGer', retornoSelect[0].CLASSE, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: retornoSelect[0].CLASSE });
      } catch (error) {
        console.error(error)
        msgAlerta(error.message)
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#txtMoeda').on('change', function () {
      $('#txtCondicao').val('');
    });


    $('#btn-limpa-Condicao').on('click', function () {
      $('#txtCondicao').val('');
      $('#txtNrParcelas').prop('disabled', false);
      $('#txtIntervaloDias').prop('disabled', false);
    });

    $('#txtClasseGer').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-ClasseGer').pesquisa('#txtClasseGer', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Classe Gerencial', 'CLASSE_GER');
    $('#btn-limpa-ClasseGer').on('click', function () { $('#txtClasseGer').val('') });

    $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":["HISTORICO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Historico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}', 'Pesquisa Histórico', 'HISTCP');
    $('#btn-limpa-Historico').on('click', function () { $('#txtHistorico').val('') });

    $('#txtSitDup').autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-SitDup').pesquisa('#txtSitDup', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Situação de Duplicata', 'TABSIT');
    $('#btn-limpa-SitDup').on('click', function () { $('#txtSitDup').val('') });

    const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));
    const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));
    if (depositoUsuario != 'null') {
      $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${depositoUsuario}}`);
      $('#btn-Deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO');
    } else if (depositosEmpresaLogada != '') {
      $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`);
      $('#btn-Deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
    } else {
      $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
      $('#btn-Deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Depósito', 'DEPOSITO');
    }
    $('#btn-limpa-Deposito').on('click', function () { $('#txtDeposito').val('') });

    $('#txtComprador').autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": null}`);
    $('#btn-Comprador').pesquisa('#txtComprador', 'CODCLI', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CONTATO", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'Pesquisa Comprador', 'contato');
    $('#btn-limpa-Comprador').on('click', function () { $('#txtComprador').val('') });

    $('#txtGrupoPed').autocompleta(1, `JSON={ "tabela":"GRUPO_PED", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-GrupoPed').pesquisa('#txtGrupoPed', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"GRUPO_PED", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo Ped', 'GRUPO_PED');
    $('#btn-limpa-GrupoPed').on('click', function () { $('#txtGrupoPed').val('') });

    if (existeStatusTipoPed) {
      $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["TIPO = 'PED'"]}`);
      $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["TIPO = 'PED'"]}`, 'Pesquisa Status', 'SITPROD');
      $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val('') });
    } else {
      $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
      $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
      $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val('') });
    }


    $('#txtEspecie').autocompleta(1, `JSON={ "tabela":"ESPECIE", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Especie').pesquisa('#txtEspecie', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ESPECIE", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Espécie', 'ESPECIE');
    $('#btn-limpa-Especie').on('click', function () { $('#txtEspecie').val('') });

    const sWhereOperFiscal = await retornaWhereOperFiscalUsuario(getCookie('cod_usuario'));
    $('#txtOperacao').autocompleta(1, `JSON={ "tabela":"OPER_FISCAL", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${sWhereOperFiscal}}`);
    $('#btn-Operacao').pesquisa('#txtOperacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ${sWhereOperFiscal}}`, 'Pesquisa Operação', 'OPER_FISCAL');
    $('#btn-limpa-Operacao').on('click', function () { $('#txtOperacao').val('') });

    $('#txtQualidadeCapa').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-QualidadeCapa').pesquisa('#txtQualidadeCapa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Qualidade', 'TABQUL');
    $('#btn-limpa-QualidadeCapa').on('click', function () { $('#txtQualidadeCapa').val('') });

    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    // $('#btn-Produto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Produto', 'PRODUTO');
    $("#btn-Produto").pesquisa_serverside(["#txtProduto"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO" ]}`, "Pesquisa Produto");
    $('#btn-limpa-Produto').on('click', function () { $('#txtProduto, #txtValor, #txtQuantidadeEstoque').val('') });

    $('#txtProdutoLote').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $("#btn-ProdutoLote").pesquisa_serverside(["#txtProdutoLote"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO" ]}`, "Pesquisa Produto");
    $('#btn-limpa-ProdutoLote').on('click', function () { $('#txtProdutoLote, #txtValorLote').val('') });

    $('#txtDepositoLote').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-DepositoLote').pesquisa('#txtDepositoLote', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Depósito', 'DEPOSITO');
    $('#btn-limpa-DepositoLote').on('click', function () { $('#txtDepositoLote').val('') });

    $('#txtCfop').autocompleta(1, `JSON={ "tabela":"NATUREZA", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Cfop').pesquisa('#txtCfop', 'NATUREZA', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"NATUREZA", "camposSelect":[ "NATUREZA", "DESCRICAO" ], "where": null}', 'Pesquisa Natureza', 'Natureza');
    $('#btn-limpa-Cfop').on('click', function () { $('#txtCfop').val('') });

    $('#txtTpVenda').autocompleta(1, `JSON={ "tabela":"TIPO", "camposSelect":["ID CHAVE, DESCRICAO DESCRICAO"], "where": ["AREA = 'COM'"]}`);
    $('#btn-TpVenda').pesquisa('#txtTpVenda', 'ID', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TIPO", "camposSelect":[ "ID", "DESCRICAO" ], "where": ["AREA = 'COM'"]}`, 'Pesquisa Tipo Venda', 'TIPO');
    $('#btn-limpa-TpVenda').on('click', function () { $('#txtTpVenda').val('') });

    $('#txtMaterial').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Material').pesquisa(
      '#txtMaterial',
      'CODIGO',
      'DESCRICAO',
      '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO", "UNI_COM" ], "where": null}',
      'Pesquisa Material',
      'MATERIAL',
      undefined,
      () => setTimeout(
        () => {
          const material = pegaChave('#txtMaterial')
          const cor = pegaChave('#txtCor')
          const deposito = pegaChave('#txtDeposito')
          const pedido = $('#txtNumero').val()
          buscaQuantidadeEmEstoqueMat(
            material,
            cor,
            deposito,
          )
          retornarQuantidadeDisponivelMaterial({
            pedido,
            material,
            cor,
            deposito,
          }).then((quantidade) => {
            $('#txtQuantidadeDisponivelMat').val(quantidade)
          })
        },
        0,
      ),
    );
    $('#btn-limpa-Material').on('click', function () { $('#txtMaterial').val('') });

    $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Cor').pesquisa(
      '#txtCor',
      'COR',
      'DESCRICAO',
      '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}',
      'Pesquisa Cor',
      'CADCOR',
      undefined,
      () => setTimeout(
        () => {
          const material = pegaChave('#txtMaterial')
          const cor = pegaChave('#txtCor')
          const deposito = pegaChave('#txtDeposito')
          const pedido = $('#txtNumero').val()
          buscaQuantidadeEmEstoqueMat(
            material,
            cor,
            deposito,
          )
          retornarQuantidadeDisponivelMaterial({
            pedido,
            material,
            cor,
            deposito,
          }).then((quantidade) => {
            $('#txtQuantidadeDisponivelMat').val(quantidade)
          })
        },
        100,
      ),
    );
    $('#btn-limpa-Cor').on('click', function () { $('#txtCor').val('') });
  };

  function retornaValDescEmpenho() {
    try {
      let desconto = parseFloat($('#txtDescontoEmprenho').val());
      let percDesconto = parseFloat($('#txtPercDesconto').val());
      if (desconto > 0) {
        return desconto;
      } else if (percDesconto > 0) {
        let total = 0;
        $('#tabelaItens').DataTable().rows().data().map(item => {
          total += (item[7] * item[8]);
        });
        desconto = (total * (percDesconto / 100))
        return desconto.toFixed(2)
      } else {
        return 0
      }
    } catch (error) {
      console.log(error);
    }
  }

  $('#txtBarra').on('blur', async function () {
    const barra = $(this).val()
    if (barra && barra !== '') {
      await bipaBarra(barra);
    }
  })

  $('#txtBarra').on('keydown', function (e) {
    if (e.key === 'Enter') {
      $('#txtBarra').trigger('blur')
    }
  })

  $('#txtObservacao').on('keydown', function (e) {
    if (e.key === 'Enter') {
      e.preventDefault()
      var cursorPos = this.selectionStart;
      var value = $(this).val();
      $(this).val(value.substring(0, cursorPos) + "\n" + value.substring(cursorPos));
      this.selectionStart = this.selectionEnd = cursorPos + 1;
    }
  });

  $('#txtObservacao2').on('keydown', function (e) {
    if (e.key === 'Enter') {
      e.preventDefault()
      var cursorPos = this.selectionStart;
      var value = $(this).val();
      $(this).val(value.substring(0, cursorPos) + "\n" + value.substring(cursorPos));
      this.selectionStart = this.selectionEnd = cursorPos + 1;
    }
  });

  async function bipaBarra(barra) {
    $.LoadingOverlay('show')
    try {
      if (barra == '') {
        return;
      }
      const tabPreco = pegaChave('#txtTabelaPreco')
      if (!tabPreco || tabPreco === '' || tabPreco === '999') {
        msgErro('Tabela de preço não informada ou o checkbox de Preço Manual está marcado, impossível continuar.')
        return
      }

      const bBarraLog = await CopiaParametro('SISTEMA', 0);
      let barraLog = false;
      let barra28 = '';
      if ((bBarraLog === '1') || (bBarraLog === '2')) {
        barra28 = await extraiBarra28(barra);
        if (barra28 && (barra28 != '')) {
          barraLog = barra;
          barra = barra28;
        }
      }

      if (!barraLog && (bBarraLog == '2')) {
        msgAlerta('Necessário bipar uma barra log.', undefined, undefined, () => { $('#txtBarra').val('').focus() });
        $('#txtBarra').val('').focus();
        return;
      }

      await bipaBarraProduto(barraLog || barra, tabPreco);
    } catch (e) {
      console.log(e)
      msgErro('Ocorreu um problema ao bipar a barra, tente novamente.')
    } finally {
      $(`#txtBarra`).val('');
      $(`#txtBarra`).focus();
      atualizaValorTotalPedido()
      $.LoadingOverlay('hide')
    }
  }

  async function bipaBarraProduto(barra, tabelaPreco) {
    try {
      const tipoBarra = await retornaTipoBarra(barra)

      const dadosBarra = await retornaProdutoBarra(barra, tipoBarra === 'barra_log')
      if (dadosBarra && dadosBarra.length > 0) {
        const item = dadosBarra[0];
        if (await produtoComStatusBloqueio(item.CODIGO)) {
          msgAlerta('Produto com Status de bloqueio para digitação de pedidos.');
          return;
        }
        let precoTabPreco;
        if (BuscaPorCorETam == 1) {
          precoTabPreco = await retornaPrecoCorTamProdutoAoBiparBarra(tabelaPreco, item.CODIGO, item.COR, item.TAM);
        } else {
          precoTabPreco = await retornaPrecoProduto(tabelaPreco, item.CODIGO);
        }
        if (!precoTabPreco || precoTabPreco === 0) {
          msgErro('Preço na tabela de preço informada está zerado, impossível continuar.')
          return
        }

        const dados = $('#tabelaItens').DataTable().rows().data().toArray()
        const indiceProdutoEncontrado = dados.findIndex(e =>
          e[0] === item.CODIGO &&
          e[2] === item.COR &&
          e[4] === item.TAM
        )
        if (tipoBarra !== 'barra_log') {
          const parametroValidarEstoque = await CopiaParametro('PEDIDO', 3)
          if (parametroValidarEstoque !== '0') {
            const objProduto = {
              CODIGO: item.CODIGO,
              COR: item.COR,
              TAM: item.TAM,
              DEPOSITO: pegaChave('#txtDeposito'),
              QTDE: indiceProdutoEncontrado !== -1 ? dados[indiceProdutoEncontrado][7] : 0
            }
            let response = await requisicao("POST", `/Sisplan/pedido/V1/validaestoquebarra?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}&PARAMETRO_ESTOQUE=${parametroValidarEstoque}`, JSON.stringify(objProduto));

            if (!response) {
              return;
            }

            let msgResposta = await response.json();
            if (response.status != 200) {
              msgErro(msgResposta.mensagem);
              return;
            }
          }
        } else {
          if (listaBarrasLog.find(e => e.BARRA === barra)) {
            msgErro('Barra já foi bipada, favor verificar.')
            return;
          }

          if (!await validaBarraLogLiberada(barra.replaceAll('#', '[HASHTAG]'))) {
            msgErro('Barra já foi lida, favor verificar.')
            return;
          }

          listaBarrasLog.push({
            BARRA: barra,
            CODIGO: item.CODIGO,
            COR: item.COR,
            TAM: item.TAM
          })
        }

        if (indiceProdutoEncontrado !== -1) {
          const dadosIndice = $('#tabelaItens').DataTable().row(indiceProdutoEncontrado).data()
          dadosIndice[7] = parseFloat(dadosIndice[7]) + 1
          let grade = [{
            CODIGO: dadosIndice[0],
            DESCRICAO: dadosIndice[1],
            COR: dadosIndice[2],
            DESC_COR: dadosIndice[3],
            TAM: dadosIndice[4],
            INPUT_DEPOSITO: dadosIndice[5],
            INPUT: dadosIndice[6],
            QTDE: dadosIndice[7],
            // caso não aplique a regra de promoção e o preço já existente não estiver zerado, mantém o preço já existente. Caso contrário, vai buscar o preço da tabela de preço para aplicar a regra de promoção
            PRECO: parseFloat(dadosIndice[8]) !== 0 && !$('#cbRegraPromocao').prop('checked') ? parseFloat(dadosIndice[8]) : precoTabPreco,
            TIPO: 'P',
            OBSERVACAO: '',
            QTDE_F: dadosIndice[12],
            QTDE_CANC: dadosIndice[13],
            ORDEM: dadosIndice[14],
            PRECO_ORIG: precoTabPreco,
          }]

          if ($('#cbRegraPromocao').prop('checked') && (tabelaPreco && tabelaPreco !== '' && tabelaPreco !== '999')) {
            grade = await aplicaRegraPromocao(grade)
          }

          grade[0] = { ...grade[0], ORDEM: 1 } // feito gravar como 1 pois é assim que está fixo nos outros lugares

          const table = $('#tabelaItens').DataTable();

          const rowNode = table.row(indiceProdutoEncontrado).data([
            grade[0].CODIGO,
            grade[0].DESCRICAO,
            grade[0].COR,
            grade[0].DESC_COR,
            grade[0].TAM,
            grade[0].INPUT_DEPOSITO,
            grade[0].INPUT,
            grade[0].QTDE,
            grade[0].PRECO,
            grade[0].TIPO,
            retornaFotoProduto(grade[0].CODIGO, grade[0].COR + grade[0].TAM),
            grade[0].OBSERVACAO,
            grade[0].QTDE_F,
            grade[0].QTDE_CANC,
            grade[0].ORDEM,
            precoTabPreco,
            0,
            0,
            retornaFotoCorProduto(grade[0].CODIGO, grade[0].COR + grade[0].TAM, grade[0].COR),
            '1'
          ]).draw(false).node();

          const input = $(rowNode).find('[id^="txtLote_"]');
          const inputDeposito = $(rowNode).find('[id^="txtDeposito_"]');
          const idItem = input.attr('id').split('_')[1];
          const codigo = grade[0].CODIGO;
          const cor = grade[0].COR;
          const tam = grade[0].TAM;

          pesquisaLote(input, idItem, 'P', codigo, cor, tam, inputDeposito.val());
          const idItemDeposito = inputDeposito.attr('id').split('_')[1];
          pesquisaDeposito(inputDeposito, idItemDeposito);
        } else {
          let grade = [{
            CODIGO: item.CODIGO,
            DESCRICAO: item.DESCRICAO,
            COR: item.COR,
            DESC_COR: item.DESC_COR,
            TAM: item.TAM,
            QTDE: 1,
            PRECO: precoTabPreco,
            TIPO: 'P',
            FOTO: '',
            OBSERVACAO: '',
            QTDE_F: 0,
            QTDE_CANC: 0,
            ORDEM: 1,
            QUALIDADE: '1'
          }]

          if ($('#cbRegraPromocao').prop('checked') && (tabelaPreco && tabelaPreco !== '' && tabelaPreco !== '999')) {
            grade = await aplicaRegraPromocao(grade)
          }

          grade[0] = { ...grade[0], PRECO_ORIG: precoTabPreco }

          addItem(grade[0])
        }

        $('.selected').removeClass('selected')
        $($('#tabelaItens tbody tr')[indiceProdutoEncontrado !== -1 ? indiceProdutoEncontrado : $('#tabelaItens').DataTable().rows().count() - 1]).click();
        $('#tabelaItens').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));
      } else {
        msgErro('Barra não encontrada, favor verificar.')
        return
      }
    } finally {
      $(`#txtBarra`).val('');
      $(`#txtBarra`).focus();
    }
  }


  async function retornaProdutoBarra(sBarra, bBarraLog) {
    let barra28 = sBarra.substr(0, 6);
    if (bBarraLog) {
      barra28 = await extraiBarra28(sBarra);
    }
    const deposito = pegaChave('#txtDeposito');

    if (deposito == '') {
      msgAlerta('Depósito não informado, impossível continuar!');
      SomAlerta(BASE_URI, true);
      return;
    }

    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let params = encodeURIComponent(`JSON={"tabela":"PA_ITEN", "camposSelect":["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM"],
    "innerjoin": [
        { "tabela" : "PRODUTO", "condicao" : "PA_ITEN.CODIGO = PRODUTO.CODIGO" },
        { "tabela": "CADCOR", "condicao": "PA_ITEN.COR = CADCOR.COR"}
    ],
    "where": ["PA_ITEN.DEPOSITO = '${deposito}' AND (PA_ITEN.BARRA = '${sBarra}' OR PA_ITEN.BARRA28 = '${sBarra}' OR PA_ITEN.BARRA28 = '${barra28}' OR PA_ITEN.BARRACLI = '${sBarra}')"]}`);

    try {
      let response = await requisicao('GET', url, params, null);
      if (!response) {
        return '';
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        SomAlerta(BASE_URI, true);
        return '';
      }

      return jsonStr.RESULT[0];

    } catch (error) {
      console.error(error);
      SomAlerta(BASE_URI, true);
      msgErro('Não foi possível buscar os dados da barra.');
      return '';
    }
  }

  async function retornaPrecoCorTamProdutoAoBiparBarra(sTabPreco, sCodProd, sCor, sTam) {
    const dadosSelect = {
      tabela: 'PRECO_COR_TAM',
      camposSelect: ['PRECO'],
      where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}' AND COR = '${sCor}' AND TAM = '${sTam}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    if (retornoSelect.length == 0) {
      return;
    }

    return retornoSelect[0].PRECO;
  };

  function removeBarrasBipadas(codigo, cor, tam) {
    for (let i = listaBarrasLog.length - 1; i >= 0; i--) {
      const e = listaBarrasLog[i];
      if (e.CODIGO === codigo && e.COR === cor && e.TAM === tam) {
        listaBarrasLog.splice(i, 1);
      }
    }
  }

  $('#txtFrete').on('blur', function () {
    if ($(this).val() == '') {
      $(this).val('0.00')
    }

    retornaTotal()

    atualizaValorCondicao()
  })

  $('#txtFreteTrans').on('blur', function () {
    if ($(this).val() == '') {
      $(this).val('0.00')
    }

    retornaTotal()

    atualizaValorCondicao()
  })

  $('#txtDespesas').on('blur', function () {
    if ($(this).val() == '') {
      $(this).val('0.00')
    }
    retornaTotal();
    atualizaValorCondicao();
  });

  function retornaInputLote(id, lote) {
    const idItem = proximoId();
    const sLote = lote ? lote : '';

    const inputLote =
      '<div class="row dynamic-lote">' +
      '<div class="group-default form-group">' +
      '<div class="relative">' +
      '<input type="text" placeholder="Lote" id="txtLote_' + idItem +
      `" ${bParamLote ? 'disabled' : ''} class="input-default focus form-control txtLote" readonly value="` + sLote + '" style="min-width: 135px;">' +
      '</div>' +
      `<div class="input-group-append ${bParamLote ? 'd-none' : ''}">` +
      `<a id="btn-limpa-lote-${idItem}">` +
      '<i class="fas fa-trash text-red" style="font-weight: bold; font-size: 18px;"></i>' +
      '</a>' +
      '</div>' +
      '</div>' +
      '</div>';

    return inputLote;
  }

  function retornaInputDeposito(deposito) {
    const idItem = proximoId('Deposito');
    const sDeposito = deposito ? deposito : pegaChave('#txtDeposito');

    const inputDeposito =
      '<div class="row dynamic-lote">' +
      '<div class="group-default form-group">' +
      '<div class="relative">' +
      '<input type="text" placeholder="Deposito" id="txtDeposito_' + idItem +
      `" ${bParamLote ? 'disabled' : ''} class="input-default focus form-control txtDeposito" readonly value="` + sDeposito + '" style="min-width: 135px;">' +
      '</div>' +
      `<div class="input-group-append ${bParamLote ? 'd-none' : ''}">` +
      `<a id="btn-limpa-Deposito-${idItem}">` +
      '<i class="fas fa-trash text-red" style="font-weight: bold; font-size: 18px;"></i>' +
      '</a>' +
      '</div>' +
      '</div>' +
      '</div>';

    return inputDeposito;
  }

  function proximoId(campo = 'Lote') {
    let maxId = 0;

    $(`[id^="txt${campo}_"]`).each(function () {
      let idNum = parseInt($(this).attr('id').split('_')[1]);
      if (!isNaN(idNum) && idNum > maxId) {
        maxId = idNum;
      }
    });

    return maxId + 1;
  }

  async function pesquisaStatusTipoPed() {
    $.LoadingOverlay('show')
    try {
      const validaStatusPed = {
        tabela: "SITPROD",
        camposSelect: ["COUNT(*) AS QTDE"],
        where: [`TIPO = 'PED'`],
      };

      const jsonStrValidaStatusPed = await retornaJsonPesquisaPadrao(JSON.stringify(validaStatusPed));
      existeStatusTipoPed = jsonStrValidaStatusPed && parseInt(jsonStrValidaStatusPed[0].QTDE) > 0
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }
  async function verificaRegraStatusPedidoInclusao() {
    $.LoadingOverlay('show')
    try {
      const validaStatusPed = {
        tabela: "CONFIGSTATUS",
        camposSelect: ["CONFIGSTATUS.OPERACAO", "CONFIGSTATUS.STATUS", "SITPROD.DESCRICAO DESC_STATUS"],
        leftjoin: [{ tabela: "SITPROD", "condicao": "SITPROD.CODIGO = CONFIGSTATUS.STATUS" }],
        where: ["CONFIGSTATUS.OPERACAO = 'opIncPedido'"]
      };

      const jsonStrRegraStatusPedido = await retornaJsonPesquisaPadrao(JSON.stringify(validaStatusPed));

      const existeRegraStatusPedido = jsonStrRegraStatusPedido && jsonStrRegraStatusPedido[0]

      if (existeRegraStatusPedido) {
        insereValor('#txtStatus', jsonStrRegraStatusPedido[0].STATUS, jsonStrRegraStatusPedido[0].DESC_STATUS);
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function pesquisaDeposito(input, id) {
    input.off('pesquisa');
    input.pesquisa(
      '#txtDeposito_' + id,
      'CODIGO',
      'CODIGO',
      retornaPesquisaDeposito(),
      'Pesquisa Depósito',
      'DEPOSITO',
      'S',
      () => { $(`#txtDeposito_${id}`).trigger('change') }
    );

    $(`#btn-limpa-Deposito-${id}`).off('click');
    $(`#btn-limpa-Deposito-${id}`).on('click', () => {
      $(`#txtDeposito_${id}`).val('');
      $(`#txtLote_${id}`).val('');
    });

    input.off('change');
    input.on('change', () => {
      $(`#txtLote_${id}`).val('');
      if ($(`#txtDeposito_${id}`).val() != '') {
        const data = $('#tabelaItens').DataTable().row($($('#tabelaItens tr.selected')[0])).data();
        pesquisaLote($(`#txtLote_${id}`), id, data[9], data[0], data[2], data[4], $(`#txtDeposito_${id}`).val());
      }
    });
  }

  function pesquisaLote(input, id, tipo, codigo, cor, tam, deposito = '') {
    input.off('pesquisa');
    if (tipo == 'P') {
      input.pesquisa(
        '#txtLote_' + id,
        'LOTE',
        'LOTE',
        retornaPesquisaLote(tipo, codigo, cor, tam, deposito),
        'Pesquisa Lote',
        'PA_ITEN',
        'S'
      );
    } else {
      input.pesquisa(
        '#txtLote_' + id,
        'LOTE',
        'LOTE',
        retornaPesquisaLote(tipo, codigo, cor, tam),
        'Pesquisa Lote',
        'MAT_ITEN',
        'S'
      );
    }

    $(`#btn-limpa-lote-${id}`).off('click');
    $(`#btn-limpa-lote-${id}`).on('click', () => {
      $(`#txtLote_${id}`).val('');
    });
  }

  $('#modal-receberabertos').on('hidden.bs.modal', async function () {
    const bAtraso = paramsPedido[16].VALOR;
    const sPedido = $(window.location.href.split('/')).get(-1);

    if ($('#txtValDupVencida').html() > 0) {
      if (bAtraso == 0) {
        msgAlerta('Cliente possui duplicatas em atraso.');
        setTimeout(() => {
          $('#txtRepresentante').focus();
        }, 100);
      } else if (bAtraso == 1) {
        msgAlerta('Cliente possui duplicatas em atraso, impossível continuar.');
        $('#txtCliente').val('');
        setTimeout(() => {
          $('#txtCliente').focus()
        }, 100);
      } else if (bAtraso == 2) {
        await senhaSupervisor('Cliente possui duplicatas em atraso.', callbackSenha, $('#txtCliente').val(), false, undefined, undefined, undefined, false, 'PEDIDO', sPedido == 'create' || sPedido == 'create#' ? $('#txtNumero').val() : sPedido, pegaChave('#txtCliente'), 0);
        $('#txtCliente').val('');
      }
    }
  })

  function callbackSenha(cliente) {
    $('#txtCliente').val(cliente);
    setTimeout(() => {
      $('#txtRepresentante').focus();
    }, 100);
  }

  async function callbackDuplicatasAtraso() {
    $('#avancar1').attr('disabled', true);

    await msgAguardaConfirmacao("Cliente possui duplicatas em atraso, necessário efetuar a negociação antes de iniciar nova venda.",
      () => {
        $('#avancar1').attr('disabled', false);
        setTimeout(() => {
          $('#txtCliente').focus();
        }, 2000);
        window.open(`${BASE_URI}/receber`, "_blank");
      },
      () => {
        $('#avancar1').attr('disabled', false);
        $('#txtCliente').focus();
      }
    );
    $('#btn-msg-alerta').html('Abrir Receber (ALT+S)');
  };

  $('#txtCliente').on('blur', async function () {
    const cliente = pegaChave('#txtCliente');
    await blurCliente(cliente);
  });

  async function blurCliente(codcli) {
    await carregaDuplicatas(codcli, 'PEDIDO', callbackDuplicatasAtraso);
  };

  $('#btn-info-cliente').on('click', async function () {
    const infoCliente = $('#txtCliente').val();
    if (infoCliente === '') {
      msgAlertaSemConfirmacao('Favor informar um cliente para utilizar este botão!');
    } else {
      const clienteTitulo = $('#txtCliente').val().replace('[', '').replace(']', '').split('-');
      await informacoesCliente(pegaChave("#txtCliente"));
      $('#modal-info-cliente').modal('show');
      $('#txtCodigoTittle').html(`${clienteTitulo[0]}-${clienteTitulo[1]}`);
    }
  });

  async function informacoesCliente(sChave) {
    const pesquisaParam = {
      tabela: "ENTIDADE",
      camposSelect: [
        "ENTIDADE.CODCLI",
        "ENTIDADE.NOME",
        "ENTIDADE.CNPJ",
        "ENTIDADE.EMAIL",
        "ENTIDADE.DDD_FONE",
        "ENTIDADE.TELEFONE",
        "ENTIDADE.COD_PAIS",
        "ENTIDADE.CEP",
        "CIDADE.NOME CIDADE",
        "CIDADE.COD_UF ESTADO",
        "ENTIDADE.BAIRRO",
        "ENTIDADE.ENDERECO",
        "ENTIDADE.NUMERO",
        "ENTIDADE.COMPLEMENTO",
        "ENTIDADE.OBS",
        "ENTIDADE.INSCRICAO",
        "ENTIDADE.DATA_CAD",
        "ENTIDADE.CLASSIFICA",
        "ENTIDADE.PERFIL",
        "PERFIL.DESCRICAO AS DESC_PERFIL",
        "ENTIDADE.GRUPO",
        "GRUPO_CLI.DESCRICAO AS DESC_GRUPO",
        "ENTIDADE.DESCONTO",
        "ENTIDADE.DT_NASC"
      ],
      leftjoin: [{
        tabela: "CADCEP",
        condicao: "ENTIDADE.CEP = CADCEP.CEP"
      },
      {
        tabela: "CIDADE",
        condicao: "CADCEP.CODMUN = CIDADE.CODIGO"
      },
      {
        tabela: "GRUPO_CLI",
        condicao: "ENTIDADE.GRUPO = GRUPO_CLI.CODIGO"
      },
      {
        tabela: "PERFIL",
        condicao: "ENTIDADE.PERFIL = PERFIL.CODIGO"
      }
      ],
      where: [`ENTIDADE.CODCLI = '${sChave}'`],
      camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME", "CADCEP.ESTCEP"]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    $('#txtDataCadastroInfo').val(jsonStr[0].DATA_CAD.slice(0, 10));
    $('#txtDataNascimentoInfo').val(jsonStr[0].DT_NASC?.slice(0, 10));
    $('#txtCpfInfoCliente').val(jsonStr[0].CNPJ);
    $('#txtEmailInfoCliente').val(jsonStr[0].EMAIL);
    $('#txtDddInfoCliente').val(jsonStr[0].DDD_FONE);
    $('#txtTelefoneInfoCliente').val(jsonStr[0].TELEFONE);
    await concatenaPais(jsonStr[0].COD_PAIS);
    $('#txtCepInfoCliente').val(jsonStr[0].CEP);
    $('#txtMunicipioInfoCliente').val(jsonStr[0].CIDADE);
    $('#txtEstadoInfoCliente').val(jsonStr[0].ESTADO);
    $('#txtBairroInfoCliente').val(jsonStr[0].BAIRRO);
    $('#txtEnderecoInfoCliente').val(jsonStr[0].ENDERECO);
    $('#txtNumeroInfoCliente').val(jsonStr[0].NUMERO);
    $('#txtComplementoInfoCliente').val(jsonStr[0].COMPLEMENTO);
    $('#txtObsInfoCliente').val(jsonStr[0].OBS);
    $('#txtInscricaoInfoCliente').val(jsonStr[0].INSCRICAO);
    const classificacaoEntidadeInfo = jsonStr[0].CLASSIFICA.replace('    ', '');
    if (classificacaoEntidadeInfo != '' && classificacaoEntidadeInfo != 'null' && classificacaoEntidadeInfo != null) {
      $('#txtClassificacaoInfoCliente').val(classificacaoEntidadeInfo);
    }
    if (jsonStr[0].GRUPO != '' && jsonStr[0].GRUPO != null) {
      $('#txtGrupoInfoCliente').val(`[${jsonStr[0].GRUPO}] - ${jsonStr[0].DESC_GRUPO}`);
    };
    if (jsonStr[0].PERFIL != '' && jsonStr[0].PERFIL != null) {
      $('#txtPerfilInfoCliente').val(`[${jsonStr[0].PERFIL}] - ${jsonStr[0].DESC_PERFIL}`);
    };
    $('#txtPercDescontoInfoCliente').val(jsonStr[0].DESCONTO);
  }

  async function concatenaPais(sPais) {
    let retorno = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"CADPAIS",
            "camposSelect":["NOME"],
            "where": ["CODIGO = '${sPais}'"]}`,
      null
    );
    let jsonString = await retorno.json();
    if (jsonString.RESULT[0] != 0) {
      insereValor($("#txtPaisInfoCliente"), sPais, jsonString.RESULT[0][0].NOME);
    }
    return
  }

});
