$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#formPrincipal",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: "#formAprovador",
        popover: {
          title: "Aprovadores",
          description:
            "Aqui se encontram os aprovadores do fluxo.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui se encontra o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnSalvar',
        popover: {
          title: 'Gravar',
          description: 'Aqui se encontra o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  let currentFs;
  let nextFs;
  let previousFs;

  async function avancar() {
    const validator = $("#form").validate();
    const erros = validator.numberOfInvalids();
    if (erros) {
      return;
    }

    const arrayFs = $(".fieldset");
    currentFs = arrayFs.filter(":visible");
    nextFs = currentFs.next(".fieldset");

    if (nextFs.length === 0) return;

    if (currentFs.attr('id') === 'fieldset1') {
      const idComposicao = await retornarIdComposicao(pegaChave('#txtComposicao'))
      adicionarPesquisaPantone(idComposicao)
      if (!$.fn.DataTable.isDataTable('#tabelaPantones')) {
        criarTabelaPantones({ data: [] })
      }
      setTimeout(() => {
        $('#tabelaPantones').DataTable().columns.adjust()
      }, 150)
      setTimeout(() => {
        $('#tabelaPantones').DataTable().columns.adjust()
      }, 500)
      carregarServicos()
    }

    if (currentFs.attr('id') == 'fieldset2') {
      carregarDadosFinanceiro()
      setTimeout(() => {
        $('#tabelaFinanceiro').DataTable().columns.adjust()
      }, 150)
      setTimeout(() => {
        $('#tabelaFinanceiro').DataTable().columns.adjust()
      }, 500)
    }

    const currentIndex = arrayFs.index(currentFs);
    $("#progressbar li").eq(currentIndex + 1).addClass("active");

    nextFs.show();
    currentFs.animate(
      { opacity: 0 },
      {
        step(now) {
          const opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          nextFs.css({ opacity });
        },
        duration: 600,
      }
    );
  }

  function voltar() {
    const arrayFs = $(".fieldset");
    currentFs = arrayFs.filter(":visible");
    previousFs = currentFs.prev(".fieldset");

    if (previousFs.length === 0) return;

    const currentIndex = arrayFs.index(currentFs);
    $("#progressbar li").eq(currentIndex).removeClass("active");

    previousFs.show();
    currentFs.animate(
      { opacity: 0 },
      {
        step(now) {
          const opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({ opacity });
        },
        duration: 600,
      }
    );
  }

  function adicionarFormatacaoCampos() {
    $('.campoFloat').maskMoney({
      decimal: ",",
      thousands: "",
      precision: 2,
    })
  }

  $('#txtRepresentante').val(getCookie('usuario'))

  componenteFiltro('entidade', false, false, 'Cliente')
  componenteFiltro('grupoVenda', false, false, 'Tipo', ["CONSIDERA_ORCA = 'S'"])
  componenteFiltro('variante', false, false, 'Composicao')

  $('#txtServicos').off('pesquisa_variosServerside')
  $('#btnServicos').off('pesquisa_serversideSel')

  $('#txtServicos').pesquisa_variosServerside(
    1,
    `{}`,
    'CODIGO',
    'DESCRICAO',
  )
  $('#btnServicos').pesquisa_serversideSel('#txtServicos', `{}`, `Pesquisa Fase`)

  $('#btnLimpaCliente').on('click', function () {
    $('#txtSolicitante').val('')

    $('#txtSolicitante').prop('disabled', true)
    $('#btnSolicitante').prop('disabled', true)
    $('#btnLimpaSolicitante').prop('disabled', true)
    $('#btnAdicionarSolicitante').prop('disabled', true)
  })

  $('#txtTipo').on('focusout', function () {
    if (!this.value) {
      $('#txtServicos').prop('disabled', true)
      $('#btnServicos').prop('disabled', true)
      $('#btnLimpaServicos').prop('disabled', true)
      return
    }

    const pesquisa = {
      tabela: 'FASE',
      camposSelect: ['FASE.ID', 'FASE.DESCRICAO'],
      innerJoin: [{
        tabela: 'GRUPO_VENDA',
        condicao: 'FASE.ID_GRPVEN = GRUPO_VENDA.ID',
      }],
      where: [`GRUPO_VENDA.CODIGO = '${pegaChave(this)}'`],
      camposSelectSubSelect: ['ID', 'DESCRICAO'],
      groupBySubSelect: ['ID', 'DESCRICAO'],
    }

    $('#txtServicos').off('pesquisa_variosServerside')
    $('#btnServicos').off('pesquisa_serversideSel')

    $('#txtServicos').pesquisa_variosServerside(
      1,
      JSON.stringify(pesquisa),
      'ID',
      'DESCRICAO',
    );
    $('#btnServicos').pesquisa_serversideSel('#txtServicos', JSON.stringify(pesquisa), `Pesquisa Fase`);

    $('#txtServicos').prop('disabled', false)
    $('#btnServicos').prop('disabled', false)
    $('#btnLimpaServicos').prop('disabled', false)
  })

  $('#btnLimpaServicos').on('click', function () {
    $('#txtServicos').empty().trigger('change')
  })

  $('#btnLimpaTipo').on('click', function () {
    $('#txtServicos').empty().trigger('change')

    $('#txtServicos').prop('disabled', true)
    $('#btnServicos').prop('disabled', true)
    $('#btnLimpaServicos').prop('disabled', true)
  })

  $('#txtCliente').on('focusout', function () {
    const codcli = pegaChave(this)
    if (!codcli) {
      $('#txtSolicitante').prop('disabled', true)
      $('#btnSolicitante').prop('disabled', true)
      $('#btnLimpaSolicitante').prop('disabled', true)
      $('#btnAdicionarSolicitante').prop('disabled', true)
      return
    }

    componenteFiltro('contato', false, false, 'Solicitante', [`CODCLI = '${codcli}'`])
    $('#txtSolicitante').prop('disabled', false)
    $('#btnSolicitante').prop('disabled', false)
    $('#btnLimpaSolicitante').prop('disabled', false)
    $('#btnAdicionarSolicitante').prop('disabled', false)

    const empresaSelecionada = $('#selectEmpresa').val()
    carregarDadosCliente(codcli, empresaSelecionada)
  })

  async function buscarDadosCliente(codcli, empresaSelecionada) {
    const response = await requisicao('GET', `/sisplan/orcamento_tingimento/v1/cliente?`, `&CODCLI=${codcli}&EMPRESA_SELECIONADA=${empresaSelecionada}`, '', 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  async function carregarDadosCliente(codcli, empresaSelecionada) {
    try {
      $.LoadingOverlay('show')
      const dados = await buscarDadosCliente(codcli, empresaSelecionada)

      OrcamentoTingimento.indicesMarkup = dados.indicesMarkup
      OrcamentoTingimento.classificacao = dados.classificacao
      OrcamentoTingimento.mediaPagamento = dados.mediaPagamento
      OrcamentoTingimento.idMarkup = dados.idMarkup
      OrcamentoTingimento.cepCliente = dados.cep
      $('#txtPrazoPagamento').val(dados.condicao)
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao carregar os dados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#form').validate({
    rules: {
      cliente: {
        required: true,
      },
      tipo: {
        required: true,
      },
      composicao: {
        required: true,
      }
    },
    messages: {
      cliente: 'Cliente é obrigatório.',
      tipo: 'Tipo é obrigatório.',
      composicao: 'Composição é obrigatória.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      const quantidadeServicos = $('#txtServicos').val().length
      if (!quantidadeServicos || quantidadeServicos === 0) {
        msgErro('Nenhum serviço informado, impossível continuar.')
        return
      }
      avancar()
    }
  })

  $('#form2').validate({
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      const quantidadePantones = $('#tabelaPantones').DataTable().rows().count()
      if (!quantidadePantones || quantidadePantones === 0) {
        msgErro('Nenhum pantone informado, impossível continuar.')
        return
      }
      avancar()
    }
  })

  $('#formAdicionar').validate({
    rules: {
      pantone: {
        required: true,
      },
    },
    messages: {
      pantone: 'Pantone é obrigatório.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      const dadosAdicionar = retornarDadosPantone()

      const linhasSelecionadas = $('#tabelaPantones').DataTable().rows({ selected: true }).indexes().toArray()
      if (linhasSelecionadas.length === 0) {
        adicionarPantone(dadosAdicionar)
      } else {
        const [indice] = linhasSelecionadas
        alterarPantone(dadosAdicionar, indice)
      }
      $('#modalAdicionarPantone').modal('hide')
    }
  })

  $('#btnAdicionarPantone').on('click', function (e) {
    e.preventDefault()
    $('#tabelaPantones').DataTable().rows({ selected: true }).deselect()
    $('#modalAdicionarPantone').modal('show')
  })

  function criarTabelaPantones({ data }) {
    if ($.fn.DataTable.isDataTable('#tabelaPantones')) {
      $('#tabelaPantones').DataTable().destroy()
      $('#tabelaPantones').empty()
    }

    const columns = [
      {
        data: 'ordem',
        title: 'Ordem',
        render: function (data) {
          return '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Alterar" id="btnAlterar">Alterar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>  ' +
            '</div>'
        },
      },
      {
        data: 'tipo',
        title: 'Tipo',
      },
      {
        data: 'composicao',
        title: 'Composição',
      },
      {
        data: 'codigo',
        title: 'Pantone',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'tipoPantone',
        title: 'Tipo Pantone',
      },
      {
        data: 'codigoCliente',
        title: 'Código Cliente',
      },
      {
        data: 'amostra',
        title: 'Amostra',
        render: function (data) {
          if (data === true) {
            return 'Sim'
          }

          return 'Não'
        }
      },
      {
        data: 'custoIndustrial',
        title: 'Custo Industrial',
        className: 'text-right',
        render: function (data) {
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'idPantone',
        title: 'Id Pantone',
        visible: false,
      },
    ]

    $('#tabelaPantones').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '300px',
      select: {
        style: 'single',
        toggleable: false,
      },
    })
  }

  function adicionarPantone(dados) {
    const { ordem } = $('#tabelaPantones').DataTable().data().toArray().reduce((previous, current) => current.ordem > previous.ordem ? current : previous, { ordem: 0 })
    const dadosFinais = {
      ordem: ordem + 1,
      tipo: pegaDescricao('#txtTipo'),
      composicao: pegaDescricao('#txtComposicao'),
      codigo: dados.pantone.chave,
      descricao: dados.pantone.descricao,
      tipoPantone: dados.tipo,
      amostra: dados.amostra,
      codigoCliente: dados.codigoCliente,
      custoIndustrial: dados.custo,
      idPantone: safeParseInt(dados.id),
    }

    $('#tabelaPantones').DataTable().row.add(dadosFinais).draw(false)
  }

  function alterarPantone(dados, indice) {
    const dadosAntigos = $('#tabelaPantones').DataTable().row(indice).data()
    const dadosNovos = {
      ...dadosAntigos,
      codigo: dados.pantone.chave,
      descricao: dados.pantone.descricao,
      tipoPantone: dados.tipo,
      amostra: dados.amostra,
      codigoCliente: dados.codigoCliente,
      custoIndustrial: dados.custo,
      idPantone: safeParseInt(dados.id),
    }
    $('#tabelaPantones').DataTable().row(indice).data(dadosNovos).draw(false)
  }

  function retornarDadosPantone() {
    const id = $('#txtIdPantoneAdicionar').val()
    const custo = safeParseFloat($('#txtCustoPantoneAdicionar').val().replace(',', '.'))
    const pantone = retornarChaveDescricao('#txtPantoneAdicionar')
    const codigoCliente = $('#txtCodigoClienteAdicionar').val()
    const tipo = $('#selectTipoAdicionar').val()
    const amostra = $('#selectAmostraAdicionar').val() === '1'

    return {
      id,
      custo,
      pantone,
      codigoCliente,
      tipo,
      amostra,
    }
  }

  async function retornarIdComposicao(codigo) {
    const pesquisa = {
      tabela: 'VARIANTE',
      camposSelect: ['ID'],
      where: [`CODIGO = '${codigo}'`],
    }

    const resultado = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))

    if (!resultado || resultado.length === 0) {
      return 0
    }

    return resultado[0].ID
  }

  function adicionarPesquisaPantone(idComposicao) {
    const pesquisa = {
      tabela: "CUSTOPANTONE",
      camposSelect: ["CUSTOPANTONE.ID", "CADCOR.PANTONE CODIGO", "CADCOR.DESCRICAO", "CUSTOPANTONE.CUSTO_IND CUSTO"],
      innerJoin: [
        {
          tabela: "VARIANTE", condicao: "CUSTOPANTONE.ID_VARIANTE = VARIANTE.ID",
        },
        {
          tabela: "CADCOR", condicao: "CUSTOPANTONE.ID_COR = CADCOR.ID",
        },
      ],
      camposSelectSubSelect: ["CODIGO", "DESCRICAO", "ID", "CUSTO"],
      groupBySubSelect: ["CODIGO", "DESCRICAO", "ID", "CUSTO"],
      where: [`CUSTOPANTONE.ID_VARIANTE = ${idComposicao}`],
    }

    $('#txtPantoneAdicionar').off('autocompleta')
    $('#btnPantoneAdicionar').off('pesquisa_serverside')
    $('#txtPantoneAdicionar').autocompleta(1, `JSON=${JSON.stringify(pesquisa)}`, ['#txtIdPantoneAdicionar', '#txtCustoPantoneAdicionar'], ['ID', 'CUSTO'], ['ID', 'CUSTO'], undefined, [true, true])
    $('#btnPantoneAdicionar').pesquisa_serverside(['#txtPantoneAdicionar', '#txtIdPantoneAdicionar', '#txtCustoPantoneAdicionar'], ['CODIGO', 'ID', 'CUSTO'], ['DESCRICAO', 'ID', 'CUSTO'], JSON.stringify(pesquisa), 'Pesquisa Pantone', undefined, [false, true, true])

    $('#btnLimpaPantoneAdicionar').on('click', function () {
      $('#txtPantoneAdicionar').val('')
      $('#txtIdPantoneAdicionar').val('')
      $('#txtCustoPantoneAdicionar').val('')
    })
  }

  $('#tabelaPantones').on('click', '#btnAlterar', function () {
    const data = $('#tabelaPantones').DataTable().row($(this).parents('tr')).data()
    $('#txtIdPantoneAdicionar').val(data.idPantone)
    $('#txtCustoPantoneAdicionar').val(data.custoIndustrial)
    insereValor('#txtPantoneAdicionar', data.codigo, data.descricao)
    $('#txtCodigoClienteAdicionar').val(data.codigoCliente)
    $('#selectTipoAdicionar').val(data.tipoPantone)
    $('#selectAmostraAdicionar').val(data.amostra ? '1' : '0')
    $('#modalAdicionarPantone').modal('show')
  })

  $('#tabelaPantones').on('click', '#btnExcluir', function () {
    $('#tabelaPantones').DataTable().row($(this).parents('tr')).remove().draw(false)
    recalcularOrdens()
  })

  function recalcularOrdens() {
    const dados = $('#tabelaPantones').DataTable().data().toArray()
    const novosDados = dados.map((it, idx) => {
      return {
        ...it,
        ordem: idx + 1,
      }
    })
    criarTabelaPantones({ data: novosDados })
  }

  $('#modalAdicionarPantone').on('hide.bs.modal', function () {
    limparCamposAdicionarPantone()
  })

  function limparCamposAdicionarPantone() {
    $('#txtIdPantoneAdicionar').val('')
    $('#txtCustoPantoneAdicionar').val('')
    $('#txtPantoneAdicionar').val('')
    $('#txtCodigoClienteAdicionar').val('')
    $('#selectTipoAdicionar').val('TPG')
    $('#selectAmostraAdicionar').val('0')
  }

  async function carregarServicos() {
    const servicos = await formataListas($('#txtServicos').val().toString())
    if (!servicos) {
      return
    }

    const pesquisa = {
      tabela: 'FASE',
      camposSelect: ['CODIGO', 'DESCRICAO', 'CUSTO_SERV_ADIC'],
      where: [`ID IN (${servicos})`]
    }

    const dados = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa))

    if (!dados || dados.length === 0) {
      return
    }

    criarTabelaServicos({ data: dados })
  }

  function criarTabelaServicos({ data }) {
    if ($.fn.DataTable.isDataTable('#tabelaServicos')) {
      $('#tabelaServicos').DataTable().destroy()
      $('#tabelaServicos').empty()
    }

    const columns = [
      {
        data: 'CODIGO',
        title: 'Código',
      },
      {
        data: 'DESCRICAO',
        title: 'Descrição',
      },
      {
        data: 'CUSTO_SERV_ADIC',
        title: 'Custo Serviço Adicional',
        className: 'text-right',
        render: function (data, _1, _2, _3, _4) {
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
    ]

    $('#tabelaServicos').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '200px',
    })
  }

  function criarTabelaFinanceiro({ data }) {
    if ($.fn.DataTable.isDataTable('#tabelaFinanceiro')) {
      $('#tabelaFinanceiro').DataTable().destroy()
      $('#tabelaFinanceiro').empty()
    }

    const columns = [
      {
        data: 'ordem',
        title: 'Ordem',
        visible: false,
      },
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'comissao1',
        title: `Comissão ${OrcamentoTingimento.classificacao.comissao1}%`,
        className: 'text-right',
        render: function (data) {
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'comissao2',
        title: `Comissão ${OrcamentoTingimento.classificacao.comissao2}%`,
        className: 'text-right',
        render: function (data) {
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'comissao3',
        title: `Comissão ${OrcamentoTingimento.classificacao.comissao3}%`,
        className: 'text-right',
        render: function (data) {
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'comissao4',
        title: `Comissão ${OrcamentoTingimento.classificacao.comissao4}%`,
        className: 'text-right',
        render: function (data) {
          return retornarFloatFormatadoEmMonetario({ valor: data })
        },
      },
      {
        data: 'preco',
        title: 'Preço',
        className: 'text-right',
        render: function (data, _, _2, { row }) {
          return retornarInputQtde('Preco', row, false, '0,00')
        }
      },
      {
        data: 'comissao',
        title: 'Comissão',
        className: 'text-right',
        render: function (data, _, _2, { row }) {
          return retornarInputQtde('Comissao', row, true, '0,00%')
        }
      }
    ]

    $('#tabelaFinanceiro').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '300px',
    })

    $('.inputPreco').on('focusout', function () {
      const preco = safeParseFloat(this.value.replace(',', '.'))
      const dados = $('#tabelaFinanceiro').DataTable().row($(this).closest('tr')).data()
      const indiceLinha = $(this).attr('id').replace('txtPreco_', '')
      if (preco > dados.comissao4) {
        $(`#txtComissao_${indiceLinha}`).val(retornarFloatFormatadoEmMonetario({ valor: OrcamentoTingimento.classificacao.comissao4 }) + '%')
        return
      }
      if (preco > dados.comissao3) {
        $(`#txtComissao_${indiceLinha}`).val(retornarFloatFormatadoEmMonetario({ valor: OrcamentoTingimento.classificacao.comissao3 }) + '%')
        return
      }
      if (preco > dados.comissao2) {
        $(`#txtComissao_${indiceLinha}`).val(retornarFloatFormatadoEmMonetario({ valor: OrcamentoTingimento.classificacao.comissao2 }) + '%')
        return
      }
      if (preco > dados.comissao1) {
        $(`#txtComissao_${indiceLinha}`).val(retornarFloatFormatadoEmMonetario({ valor: OrcamentoTingimento.classificacao.comissao1 }) + '%')
        return
      }
      $(`#txtComissao_${indiceLinha}`).val('0,00%')
    })

    adicionarFormatacaoCampos()
  }

  function retornarInputQtde(input, col, disabled, valor) {
    return `<div
              class="flex justify-content-end">
                <input
                  ${disabled && 'disabled'}
                  type="text"
                  value="${valor}"
                  class="input-default focus form-control validate text-right campoFloat input${input}"
                  id="txt${input}_${col}"
                  placeholder="0,00"
                  style="max-width: 120px"
                >
            </div>`
  }

  function carregarDadosFinanceiro() {
    const dadosPantone = $('#tabelaPantones').DataTable().data().toArray()

    const dadosFinanceiro = dadosPantone.map((item) => {
      return {
        ordem: item.ordem,
        codigo: item.codigo,
        descricao: item.descricao,
        comissao1: retornarComissao(OrcamentoTingimento.classificacao.lucro1, OrcamentoTingimento.classificacao.comissao1, item.custoIndustrial),
        comissao2: retornarComissao(OrcamentoTingimento.classificacao.lucro2, OrcamentoTingimento.classificacao.comissao2, item.custoIndustrial),
        comissao3: retornarComissao(OrcamentoTingimento.classificacao.lucro3, OrcamentoTingimento.classificacao.comissao3, item.custoIndustrial),
        comissao4: retornarComissao(OrcamentoTingimento.classificacao.lucro4, OrcamentoTingimento.classificacao.comissao4, item.custoIndustrial),
        preco: 0,
        comissao: 0,
      }
    })

    criarTabelaFinanceiro({ data: dadosFinanceiro })
  }

  function retornarComissao(lucro, comissao, custo) {
    const totalMarkup = OrcamentoTingimento.indicesMarkup?.reduce((acc, it) => acc + it.indice, 0) ?? 0
    const taxaJuros = 2 * (OrcamentoTingimento.mediaPagamento / 30)
    const indiceFinal = totalMarkup + taxaJuros + lucro + comissao

    return custo / (1 - (indiceFinal / 100))
  }

  $('#btnSalvar').on('click', function () {
    msgAlerta('Deseja gravar os dados?',
      () => { },
      () => { },
      () => {
        const dados = retornarDadosSalvar()
        salvar(dados)
      },
    )
  })

  function retornarDadosSalvar() {
    const codCli = pegaChave('#txtCliente')
    const email = $('#txtEmail').val()
    const codTipo = pegaChave('#txtTipo')
    const fases = $('#txtServicos').val().map((id) => ({ id, descricao: '' }))
    const codUsuario = getCookie('cod_usuario')
    const codComposicao = pegaChave('#txtComposicao')
    const idSolicitante = pegaChave('#txtSolicitante')
    const descricao = $('#txtDescricao').val()
    const emissao = $('#txtEmissao').val()
    const validade = $('#txtValidade').val()
    const prazoPagamento = $('#txtPrazoPagamento').val()
    const observacao = $('#txtObservacao').val()
    const situacao = $('#selectSituacao').val()
    const empresa = $('#selectEmpresa').val()
    const idMarkup = OrcamentoTingimento.idMarkup
    const itens = retornarItensSalvar()

    return {
      codCli,
      email,
      codTipo,
      fases,
      codUsuario,
      codComposicao,
      idSolicitante,
      descricao,
      emissao,
      validade,
      prazoPagamento,
      observacao,
      situacao,
      empresa,
      idMarkup,
      itens,
    }
  }

  function retornarItensSalvar() {
    const dadosPantone = $('#tabelaPantones').DataTable().data().toArray()
    const dadosFinanceiro = $('#tabelaFinanceiro').DataTable().data().toArray().map((it, idx) => {
      return {
        ...it,
        preco: safeParseFloat($(`#txtPreco_${idx}`).val().replace(',', '.')),
        comissao: safeParseFloat($(`#txtComissao_${idx}`).val().replace(',', '.')),
      }
    })

    const itens = dadosPantone.map((it) => {
      const itemFinanceiro = dadosFinanceiro.find((itFinan) => itFinan.ordem === it.ordem)

      return {
        ordem: it.ordem,
        codigoCliente: it.codigoCliente,
        tipo: it.tipo,
        amostra: !!it.amostra,
        idPantone: it.idPantone,
        preco: itemFinanceiro?.preco ?? 0,
        comissao: itemFinanceiro?.comissao ?? 0,
      }
    })

    return itens
  }

  async function salvar(dados) {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao('POST', `/sisplan/orcamento_tingimento/v1/orcamento?`, ``, JSON.stringify(dados), 3600000)
      const json = await response.json()

      if (!json) {
        throw new Error()
      }
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      toastr.success("Dados gravados com sucesso! Número: " + resultado, "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/orcamento_tingimento`
        }
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    } catch (error) {
      console.error(error)
      msgErro(error || 'Ocorreu um erro ao gravar os dados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnAdicionarCliente').on('click', async function () {
    $('#modal-cliente').modal('show');
    $('#txtCNPJModalCli').focus();
  })

  $('#btnVoltar2, #btnVoltar3').on('click', function () {
    voltar()
  })

  $('#btnVoltar1').on('click', function () {
    window.location.href = `${BASE_URI}/orcamento_tingimento`
  })

  $('#btnAdicionarSolicitante').on('click', function () {
    $('#modalAdicionarSolicitante').modal('show')
  })

  $('#txtCPFCNPJContatoSolicitante').on('focus', function () {
    let options = {
      onKeyPress(cpf, ev, el, op) {
        let masks = ["000.000.000-000", "00.000.000/0000-00"];
        $("#txtCPFCNPJContatoSolicitante").mask(cpf.length > 14 ? masks[1] : masks[0], op);
      },
    };

    if ($("#txtCPFCNPJContatoSolicitante").val().length > 11) {
      $("#txtCPFCNPJContatoSolicitante").mask("00.000.000/0000-00", options);
    } else {
      $("#txtCPFCNPJContatoSolicitante").mask("000.000.000-00#", options);
    }
  });

  const SPMaskBehavior = function (val) {
    return val.replace(/\D/g, "").length === 9 ? "00000-0000" : "0000-00009";
  }
  const spOptions = {
    onKeyPress(val, e, field, options) {
      field.mask(SPMaskBehavior.apply({}, arguments), options);
    },
  }

  $("#txtTelefoneContatoSolicitante").mask(SPMaskBehavior, spOptions);

  $('#btnFormataNumeroSolicitante').on('click', async function (e) {
    e.preventDefault()
    if (!OrcamentoTingimento.cepCliente) {
      msgAlerta('Cliente não possui CEP informado em seu cadastro, impossível continuar.')
      return
    }
    const sCEPEntidade = OrcamentoTingimento.cepCliente
    const pesquisaDDD = {
      camposSelect: [
        "CIDADE.DDD"
      ],
      tabela: "CADCEP",
      innerJoin: [{
        tabela: 'CIDADE',
        alias: "CIDADE",
        condicao: 'CIDADE.CODIGO=CADCEP.CODMUN'
      },],
      where: [`CADCEP.CEP = '${sCEPEntidade}'`],
    }
    const jsonStrDDD = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDDD));
    let numeroCelular = $('#txtCelularContatoSolicitante').val();
    let numeroDDD = jsonStrDDD[0].DDD;
    if (numeroDDD === '') {
      numeroDDD = '47'
    }
    if (numeroCelular.length >= 9) {
      if (numeroCelular.substring(0, 2) !== '55') {
        if (numeroCelular.substring(0, 2) !== numeroDDD) {
          numeroCelular = '55' + numeroDDD + numeroCelular;
        } else {
          numeroCelular = '55' + numeroCelular;
        }
      } else if (numeroCelular.substring(2, 4) !== numeroDDD) {
        numeroCelular = numeroCelular.replace('55', '55' + numeroDDD);
      }
    } else {
      msgErro('Por favor, insira um número de celular válido! Ex.: 5547988888888.')
    }

    $('#txtCelularContatoSolicitante').val(numeroCelular);
  });

  $('#formAdicionarSolicitante').validate({
    rules: {
      nome: {
        required: true,
      },
    },
    messages: {
      nome: 'Nome é obrigatório.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      const dados = retornarDadosSalvarSolicitante()
      if (!validarDadosSalvarSolicitante(dados)) {
        return
      }
      salvarSolicitante(dados)
    }
  })

  function retornarDadosSalvarSolicitante() {
    const ENTIDADECONTATONOVO = pegaChave('#txtCliente')
    const NOMECONTATONOVO = $('#txtNomeContatoSolicitante').val()
    const TELEFONECONTATONOVO = $('#txtTelefoneContatoSolicitante').val()
    const CELULARCONTATONOVO = $('#txtCelularContatoSolicitante').val()
    const CPFCNPJCONTATONOVO = $('#txtCPFCNPJContatoSolicitante').val()
    const EMAILCONTATONOVO = $('#txtEmailContatoSolicitante').val()
    const OBSERVACAOCONTATONOVO = $('#txtObsContatoEntidade').val()
    const MALADIRETACONTATONOVO = $('#cbMaladiretaSolicitante').is(':checked') ? 'S' : 'N'
    const ATIVOCONTATONOVO = true
    const TIPOCONTATONOVO = $('#cbPessoaJuridicaSolicitante').is(':checked') ? '1' : '0'
    const NUMEROCONTATOID = 0
    const COD_PAIS = OrcamentoTingimento.paisCliente
    const AUTORIZA_WHATSAPP = $('#cbWhatsAppSolicitante').prop('checked') ? 'S' : 'N'
    const AUTORIZA_EMAIL = $('#cbEmailSolicitante').prop('checked') ? 'S' : 'N'
    const TEXTOCONTATONOVO = $('#txtDoContatoSolicitante').val()
    const TIPO = $('#selectModificacao2').val()

    return {
      ENTIDADECONTATONOVO,
      NOMECONTATONOVO,
      TELEFONECONTATONOVO,
      CELULARCONTATONOVO,
      CPFCNPJCONTATONOVO,
      EMAILCONTATONOVO,
      OBSERVACAOCONTATONOVO,
      MALADIRETACONTATONOVO,
      ATIVOCONTATONOVO,
      TIPOCONTATONOVO,
      NUMEROCONTATOID,
      COD_PAIS,
      AUTORIZA_WHATSAPP,
      AUTORIZA_EMAIL,
      TEXTOCONTATONOVO,
      TIPO,
    }
  }

  async function validarDadosSalvarSolicitante(dados) {
    let validaCelular = dados.CELULARCONTATONOVO
    if (validaCelular !== '') {
      const paisEntidade = dados.COD_PAIS
      validaCelular = validaCelular.replace(/[^0-9]/g, '');
      if (paisEntidade === '' || paisEntidade === '1058') {
        if (validaCelular.substring(0, 3) === '550') {
          msgErro('DDD incorreto, não pode ter o digito zero! Verifique!');
          return false
        }
        if (validaCelular.length < 12 || !validaCelular.startsWith('55')) {
          msgErro('Sua empresa utiliza o WhatsApp, campo celular precisa ter código do país + DDD + número do telefone. Verifique! Ex.: 5547988888888.');
          return false
        }
        if (validaCelular.length > 13) {
          msgErro('Sua empresa utiliza o WhatsApp, campo celular está com números a mais, precisa ter código do país + DDD + número do telefone. Verifique! Ex.: 5547988888888.');
          return false
        }
      }
    }

    if (dados.NOMECONTATONOVO === '') {
      msgErro('Campo nome é obrigatório! Favor verifique.');
      return false
    }

    if (dados.EMAILCONTATONOVO !== '') {
      if (!await validarEmail(dados.EMAILCONTATONOVO)) {
        msgErro('Por favor, insira um endereço de e-mail válido.')
        $('#txtEmailContatoSolicitante').val('')
        return false
      }
    }

    return true
  }

  async function salvarSolicitante(dados) {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao('POST', `/sisplan/cliente/v1/incluicontato?`, ``, `JSON=${JSON.stringify(dados)}`, 3600000)

      if (response?.status !== 200) {
        throw new Error()
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          limparCamposAdicionarSolicitante()
          $('#modalAdicionarSolicitante').modal('hide')
        }
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    } catch (error) {
      msgErro('Ocorreu um erro ao gravar os dados.')
      console.error(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function limparCamposAdicionarSolicitante() {
    $('#txtNomeContatoSolicitante').val('');
    $('#txtTelefoneContatoSolicitante').val('');
    $('#txtCelularContatoSolicitante').val('');
    $('#txtCPFCNPJContatoSolicitante').val('');
    $('#txtEmailContatoSolicitante').val('');
    $('#selectModificacao2Solicitante').val(0);
    $('#txtObsContatoEntidadeSolicitante').val('');
    $('#txtDoContatoSolicitante').val('');
    $('#cbMalaDiretaSolicitante').prop('checked', true);
    $('#cbPessoaFisicaSolicitante').prop('checked', true);
    $('#cbWhatsAppSolicitante').prop('checked', false);
    $('#cbEmailSolicitante').prop('checked', false);
  }

  async function validarEmail(email) {
    const regex = /^[\w-\.]+@([\w-]+\.)+[\w-]{2,4}$/
    return regex.test(email)
  }
})

window.OrcamentoTingimento = window.OrcamentoTingimento || {}

OrcamentoTingimento.indicesMarkup = []
OrcamentoTingimento.classificacao = {}
OrcamentoTingimento.mediaPagamento = 0
OrcamentoTingimento.idMarkup = 0
OrcamentoTingimento.cepCliente = ''
OrcamentoTingimento.paisCliente = ''