$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o Grupo Centro de Custo.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o Grupo Centro de Custo.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('GRUPOCENTROCUSTO', getCookie('usuario'), grupocentrocusto);
        window.location.href = `${BASE_URI}/grupocentrocusto`;
    });

    $('#txtCodigo').prop('disabled', true);

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let grupocentrocusto = parametros[parametros.length - 1];

    if (grupocentrocusto != '' && grupocentrocusto != 'create') {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"GRUPO_CCUSTO", 
                    "camposSelect":["codigo", "descricao"], 
                    "where": ["codigo = '${grupocentrocusto}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $("#gravar").click(async function () {
        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            try {
                $.LoadingOverlay("show");
                const pGrupoCentroCusto = {
                    CODIGO: $('#txtCodigo').val() == '' ? await RetornaProximo('GRUPO_CCUSTO', 'GRUPO_CCUSTO', 'CODIGO', 0) : $('#txtCodigo').val(),
                    DESCRICAO: $('#txtDescricao').val().toUpperCase()
                }

                let response = await requisicao('POST', '/Sisplan/Cadastros/v1/grupocentrocusto?', `JSON=${encodeURIComponent(JSON.stringify(pGrupoCentroCusto))}`, null);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };
                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/grupocentrocusto` })
            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados: ${error}`);
            }
        }
    });
});