window.GraficosFormacaoCustos = window.GraficosFormacaoCustos || {}

GraficosFormacaoCustos.criarGraficoPizza = ({ container, data, grafico3d }) => {
  Highcharts.chart(container, {
    credits: {
      enabled: false,
    },
    chart: {
      type: 'pie',
      height: 410,
      custom: {},
      options3d: grafico3d && {
        enabled: true,
        alpha: 45,
      },
      backgroundColor: 'transparent',
      plotBackgroundColor: 'transparent',
    },
    accessibility: {
      point: {
        valueSuffix: '%',
      },
    },
    title: {
      text: null,
    },
    tooltip: {
      pointFormat: '{series.name}: <b>{point.percentage:.0f}%</b>',
      formatter: function () {
        return this.series.name + ': <b>' + retornarFloatFormatadoEmMonetario({ valor: this.percentage }) + '%</b>'
      },
    },
    legend: {
      enabled: true,
      useHTML: true,
      labelFormatter: function () {
        return this.name
      },
      itemStyle: {
        color: 'var(--font-color)',
        fontWeight: 'bold',
      },
    },
    plotOptions: {
      pie: {
        allowPointSelect: true,
        cursor: 'pointer',
        dataLabels: {
          enabled: false,
        },
        showInLegend: true,
        depth: grafico3d ? 45 : null,
      },
      series: {
        allowPointSelect: true,
        cursor: 'pointer',
        borderWidth: 2,
        borderColor: 'var(--borda-grafico)',
        dataLabels: [
          {
            enabled: true,
            distance: 20,
            formatter: function () {
              return `${retornarFloatFormatadoEmMonetario({ valor: this.y })}%`
            },
            style: {
              color: 'var(--font-color)',
              fontSize: '14px',
              fontWeight: 'bold',
              textOutline: 'none',
            },
          },
          {
            enabled: false,
            distance: -17.5,
            format: '{point.percentage:.0f}%',
            style: {
              fontSize: '0.8rem',
            },
            filter: {
              operator: '>',
              property: 'percentage',
              value: 5,
            },
          },
        ],
      },
    },
    series: [
      {
        name: 'Percentual',
        colorByPoint: true,
        data,
      },
    ],
    exporting: {
      buttons: {
        contextButton: {
          menuItems: ['viewFullscreen', 'downloadPNG']
        }
      }
    },
    navigation: {
      buttonOptions: {
        enabled: true
      }
    }
  })
}