/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#campostour',
                popover: {
                    title: 'Dados Gerais',
                    description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                    position: 'top'
                }
            },
            {
                element: '#tutLeft',
                popover: {
                    title: 'Campos para cadastro',
                    description: 'Neste campos, adicionamos os dados para incluir na tabela.',
                    position: 'top'

                }
            },
            {
                element: '#tabelatuto',
                popover: {
                    title: 'Tabela de tamanhos',
                    description: 'Nesta tabela constará as faixas adicionadas.',
                    position: 'top'

                }
            },
            {
                element: '#checkAtivo',
                popover: {
                    title: 'Ativo',
                    description: 'Aqui, definimos a faixa de tamanho como ativa.',
                    position: 'top'

                }
            },
            {
                element: '#txtCodigo',
                popover: {
                    title: 'Campos Obrigatórios',
                    description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                    position: 'top'

                }
            },
            {
                element: '#txtDescricao',
                popover: {
                    title: 'Descrição',
                    description: 'O campo de descrição é preenchido automaticamente com os tamanhos após gravar o registro.',
                    position: 'top'

                }
            },
            {
                element: '#txtTamanho',
                popover: {
                    title: 'Tamanhos',
                    description: 'Neste campo, adicionamos os tamanhos, podemos consultar os tamanhos clicando na lupa.',
                    position: 'top'

                }
            },
            {
                element: '#txtPerc',
                popover: {
                    title: 'Percentual',
                    description: 'Aqui adicionamos a porcentagem por tamanho.',
                    position: 'top'

                }
            },
            {
                element: '#btnIncluir',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Ao clicar, adicionamos o tamanho na tabela.',
                    position: 'top'

                }
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar a faixa.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

const colunasFaixa = [
    { data: 'POSICAO', title: 'Posição' },
    { data: 'TAMANHO', title: 'Tamanho' },
    {
        data: 'PERCENTUAL',
        title: 'Percentual',
        render(data) {
            return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
            });
        },
        className: 'pr-4 text-right'
    }
]

$(document).ready(async function () {
    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let faixa = parametros[parametros.length - 1];
    criaPesquisa()

    $('#tabelaPrecos').DataTable({
        paging: false,
        filter: false,
        info: false,
        ordering: true,
        destroy: true,
        scrollY: "215px",
        scrollCollapse: true,
        autowidth: true,
        columns: colunasFaixa
    });

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('FAIXATAMANHO', getCookie('usuario'), faixa);
        window.location.href = `${BASE_URI}/faixatamanho`;
    });

    $("#btnIncluir").on('click', function () {
        if (($("#msform").validate().element("#txtTamanho"))) {
            limpaCampos();
        }
    });

    if (faixa != '' && faixa != 'create') {
        if (await liberarRegistro('FAIXATAMANHO', faixa) == false) {
            window.location.href = '../faixatamanho';
        } else {
            carregaDados(faixa);
        }
    }

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtDescricao: {
                required: true,
            }
        },
        messages: {
            txtDescricao: {
                required: "Informe um tamanho.",
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    async function carregaDados(faixaUrl) {
        $.LoadingOverlay("show");
        if ($.fn.DataTable.isDataTable('#tabelaPrecos')) {
            $('#tabelaPrecos').DataTable().destroy()
            $('#tabelaPrecos').empty()
        }
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                        "tabela":"faixa", 
                        "camposSelect":["codigo", "descricao", "ativo", "descricao2"], 
                        "where": ["codigo = '${faixaUrl}'"]}`, null);
            if (!response) {
                return;
            }
            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            };

            $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
            $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
            $('#txtDescricao2').val(jsonStr.RESULT[0][0].DESCRICAO2);
            $('#checkAtivo').prop('checked', jsonStr.RESULT[0][0].ATIVO == 'S');
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados do preço: ${error}`);
        };

        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                        "tabela":"faixa_iten", 
                        "camposSelect":["posicao", "tamanho", "percentual"], 
                        "where": ["faixa = '${faixaUrl}'"]}`, null);
            if (!response) {
                return;
            }
            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            };

            $('#tabelaPrecos').DataTable({
                paging: false,
                filter: false,
                info: false,
                ordering: true,
                destroy: true,
                scrollY: "215px",
                scrollCollapse: true,
                autowidth: true,
                columns: colunasFaixa,
                data: jsonStr.RESULT[0]
            });

            $('#tabelaPrecos tbody').on('click', 'tr', function () {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                } else {
                    $('#tabelaPrecos').DataTable().$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados do preço: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function limpaCampos() {
        $.LoadingOverlay("show");
        try {
            if ($('#txtTamanho').val() != '') {
                addTamanho();
                $('#txtTamanho').val('');
                $('#txtPerc').val('');
            } else {
                msgAlerta('Informe um tamanho para incluir.');
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function addTamanho() {
        const dados = $('#tabelaPrecos').DataTable().rows().data().toArray();
        const tamanho = pegaChave('#txtTamanho');
        const percentual = parseFloat($('#txtPerc').val() || 0);

        const existe = dados.some(row => row.TAMANHO == tamanho);
        if (existe) {
            msgAlerta('Tamanho já está na faixa.');
            return;
        }

        const posicao = dados.length + 1;

        $('#tabelaPrecos').DataTable().row.add({
            POSICAO: posicao,
            TAMANHO: tamanho,
            PERCENTUAL: percentual
        }).draw(false);

        const todosTamanhos = $('#tabelaPrecos').DataTable().rows().data().toArray().map(tamanho => tamanho.TAMANHO);
        $('#txtDescricao').val(todosTamanhos.join('/'));
    }

    $('#btnSobeUmaLinha').on('click', async function () {
        await sobeLinha();
    });

    $('#btnDesceUmaLinha').on('click', async function () {
        await desceLinha();
    });

    async function sobeLinha() {
        const linhaSelecionada = $('tr.selected');

        if (!linhaSelecionada.length) {
            msgAlerta('Selecione uma linha primeiro!');
            return;
        }

        const indice = linhaSelecionada[0].rowIndex - 1;

        if (indice <= 0) {
            return;
        }

        const dados = $('#tabelaPrecos').DataTable().rows().data().toArray();

        [dados[indice - 1], dados[indice]] = [dados[indice], dados[indice - 1]];

        dados.forEach((d, i) => d.POSICAO = i + 1);

        $('#tabelaPrecos').DataTable().clear().rows.add(dados).draw(false);

        const novaLinha = $('#tabelaPrecos tbody tr').eq(indice - 1);
        novaLinha.addClass('selected');
    }

    async function desceLinha() {
        const linhaSelecionada = $('tr.selected');

        if (!linhaSelecionada.length) {
            msgAlerta('Selecione uma linha primeiro!');
            return;
        }

        const dados = $('#tabelaPrecos').DataTable().rows().data().toArray();
        const indice = linhaSelecionada[0].rowIndex - 1;

        if (indice >= dados.length - 1) {
            return;
        }

        [dados[indice + 1], dados[indice]] = [dados[indice], dados[indice + 1]];

        dados.forEach((d, i) => d.POSICAO = i + 1);

        $('#tabelaPrecos').DataTable().clear().rows.add(dados).draw(false);

        const novaLinha = $('#tabelaPrecos tbody tr').eq(indice + 1);
        novaLinha.addClass('selected');
    }

    $(".submit").on('click', function () {
        return false;
    });

    $("#btnGravar").on('click', async function () {
        try {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                $.LoadingOverlay("show");

                const faixaClasse = {};

                faixaClasse.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('faixa', 'faixa', 'CODIGO', 2) : $('#txtCodigo').val();
                faixaClasse.DESCRICAO = $('#txtDescricao').val();
                faixaClasse.DESCRICAO2 = $('#txtDescricao2').val();
                faixaClasse.ATIVO = $('#checkAtivo').is(':checked') ? 'S' : 'N';
                faixaClasse.TAMANHOS = $('#tabelaPrecos').DataTable().data().toArray();

                const arrayTamanhos = [];
                for (let i = 0; i < $('#tabelaPrecos').DataTable().data().toArray().length; i++) {
                    const data = $('#tabelaPrecos').DataTable().data().toArray()[i];
                    const tamanho = {
                        FAIXA: faixaClasse.CODIGO,
                        ...data
                    };
                    arrayTamanhos.push(tamanho);
                }
                faixaClasse.TAMANHOS = arrayTamanhos;

                const response = await requisicao('POST', '/Sisplan/Cadastros/v1/faixa?', `JSON=${encodeURIComponent(JSON.stringify(faixaClasse))}`, null);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };

                const jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr.success(
                    `Cadastro efetuado com sucesso!
                         Faixa: ${faixaClasse.CODIGO}`,
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/faixatamanho`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });
            };
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados da região: ${error}`);
        }
    });

    function criaPesquisa() {
        $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"tabtam", "camposSelect":[ "TAM chave", "ID descricao"], "where": null}`);

        $('#btnTamanho').pesquisa('#txtTamanho', 'TAM', 'ID', `/sisplan/funcoes/v1/pesquisa?JSON={ 
        "tabela":"tabtam", "camposSelect":[ "TAM", "ID"]}`, 'Pesquisa Tamanho', 'tabtam');
        $('#btnATamanho').on('click', function () {
            $('#txtTamanho').val('');
        });

        $('#txtPerc').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
    }
});