$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: '#txtProduto',
                popover: {
                    title: 'Produto',
                    description: 'Informe o código do produto.',
                    position: 'top'
                }
            },
            {
                element: '#txtTabPreco',
                popover: {
                    title: 'Tabela de Preço',
                    description: 'Informe a tabela de preço.',
                    position: 'top'
                }
            },
            {
                element: '#txtParte',
                popover: {
                    title: 'Parte',
                    description: 'Informe a parte do produto.',
                    position: 'top'
                }
            },
            {
                element: '#txtSetor',
                popover: {
                    title: 'Setor',
                    description: 'Informe o setor.',
                    position: 'top'
                }
            },
            {
                element: '#btnConsultar',
                popover: {
                    title: 'Consultar',
                    description: 'Clique aqui para consultar a grade do produto.',
                    position: 'top'
                }
            },
        ]);
        driver.start();
    });
});

const colunasTabelaFac = [
    { data: "COR", title: "Cor" },
    { data: "DESC_COR", title: "Desc. Cor" },
];

const colunasTabelaCusto = [
    { data: "COR", title: "Cor" },
    { data: "DESC_COR", title: "Desc. Cor" },
];

$(document).ready(async function () {
    let filtrado = false;
    let todasCores = false;
    let jaExiste = false;
    let editar = false;

    let listaTamanhos = [];
    let listaCores = [];
    let listaIds = [];

    let parametros = window.location.href.split("/");
    let produto = parametros[parametros.length - 1];

    if (produto !== "create") {
        $.LoadingOverlay('show')
        editar = true;
        try {
            let infoProd = JSON.parse(atob(produto));
            preencheCampos(infoProd);
        } catch (error) {
            console.error(error.message);
        } finally {
            validaCamposPreenchidos();
            $.LoadingOverlay('hide');
        };
    };

    // #region Eventos
    $('#btnProduto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', montaPesquisa(1, "PRODUTO", '["CODIGO","DESCRICAO"]'), 'Pesquisa Produto', 'PRODUTO');
    $('#txtProduto').autocompleta(3, montaPesquisa(2, "PRODUTO", '["CODIGO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaProduto').on("click", function () { $("#txtProduto").val("") })

    $('#btnTabPreco').pesquisa('#txtTabPreco', 'REGIAO', 'DESCRICAO', montaPesquisa(1, "REGIAO", '["REGIAO","DESCRICAO"]'), 'Pesquisa Tabela de Preço', 'REGIAO');
    $('#txtTabPreco').autocompleta(2, montaPesquisa(2, "REGIAO", '["REGIAO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaTabPreco').on("click", function () { $("#txtTabPreco").val("") })

    $('#btnSetor').pesquisa('#txtSetor', 'CODIGO', 'DESCRICAO', montaPesquisa(1, "CADFLUXO", '["CODIGO","DESCRICAO"]'), 'Pesquisa Setor', 'CADSETOR');
    $('#txtSetor').autocompleta(1, montaPesquisa(2, "CADFLUXO", '["CODIGO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaSetor').on("click", function () { $("#txtSetor").val("") });

    $('#btnParte').pesquisa('#txtParte', 'CODIGO', 'DESCRICAO', montaPesquisa(1, "TIPO_APL", '["CODIGO","DESCRICAO"]'), 'Pesquisa Setor', 'CADSETOR');
    $('#txtParte').autocompleta(1, montaPesquisa(2, "TIPO_APL", '["CODIGO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaParte').on("click", function () { $("#txtParte").val("") });

    $("#btnConsultar").on("click", async function (e) {
        e.preventDefault();
        validaCamposPreenchidos();
    });

    $("#btnGravar").on("click", function (e) {
        e.preventDefault();

        if (!filtrado) {
            msgAlerta("Necessário filtrar um produto antes de gravar!");
            return;
        };

        gravarPreco();
    });

    $("#btnVoltar").on("click", function () {
        if (filtrado) {
            msgAguardaConfirmacao(
                `O progresso será perdido, tem certeza que deseja voltar?`,
                () => { voltar(); },
                () => { }
            );
        } else {
            voltar();
        };
    });

    $("#btnExcluir").on("click", async function (e) {
        e.preventDefault();
        msgAguardaConfirmacao(
            "Tem certeza que deseja deletar esse registro? Essa ação é irreversível, deseja continuar?",
            async () => {
                await deletaRegistro();
            },
            () => {

            }
        );
    });

    $("#btnConfirmaAtalhoPrecoFac").on("click", function (e) {
        e.preventDefault();
        todasCores = $("#txtCorAtalhoPrecoFac").val() === '';

        if (todasCores) {
            msgAguardaConfirmacao(
                `Será informado para todas as cores e tamanhos, tem certeza que deseja continuar?`,
                () => { preencheCamposAtalho(true); },
                () => { }
            );
        } else {
            preencheCamposAtalho(true);
        };
    });

    let atalhoPrecoCustoAberto = false;
    $("#btnAtalhoPrecoCusto").on("click", function (e) {
        e.preventDefault();
        atalhoPrecoCustoAberto = abreAtalho("#atalhoPrecoCusto", "#btnAtalhoPrecoCusto", atalhoPrecoCustoAberto);
    });

    $("#btnConfirmaAtalhoPrecoCusto").on("click", function (e) {
        e.preventDefault();
        todasCores = $("#txtCorAtalhoPrecoCusto").val() === '';

        if (todasCores) {
            msgAguardaConfirmacao(
                `Será informado para todas as cores e tamanhos, tem certeza que deseja continuar?`,
                () => { preencheCamposAtalho(false); },
                () => { }
            );
        } else {
            preencheCamposAtalho(false);
        };
    });

    // #region Funções
    function preencheCampos(infoProd) {
        insereValor("#txtProduto", infoProd.CODIGO, infoProd.DESC_PROD);
        insereValor("#txtTabPreco", infoProd.TABELA, infoProd.DESC_TABELA);
        insereValor("#txtSetor", infoProd.SETOR, infoProd.DESC_SETOR);
        insereValor("#txtParte", infoProd.PARTE, infoProd.DESC_PARTE);
    };

    function bloqueiaCampos(campos, value = true) {
        for (let x = 0; x < campos.length; x++) {
            $(campos[x]).prop("disabled", value);
        };
    };

    function voltar() {
        $.LoadingOverlay('show');
        try {
            window.location.href = `${BASE_URI}/fac_preco_cor_tam`;
        } finally {
            $.LoadingOverlay('hide');
        };
    };

    function montaPesquisa(tipo, tabela, campos) {
        if (tipo === 1)
            return `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"${tabela}", "camposSelect":${campos}  }`;

        if (tipo === 2)
            return `JSON={ "tabela":"${tabela}", "camposSelect":${campos} }`

        if (tipo === 3)
            return `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"${tabela}", "camposSelect":${campos}, "where": ${JSON.stringify(pegaWhereCores())} }`;

        if (tipo === 4)
            return `JSON={ "tabela":"${tabela}", "camposSelect":${campos}, "where": ${JSON.stringify(pegaWhereCores())} }`
    };

    function pegaWhereCores() {
        let where = ["1=1"];
        let coresWhere = '';
        if (listaCores.length > 0) {
            for (let x = 0; x < listaCores.length; x++) {
                coresWhere += `${x === 0 ? "COR IN (" : ","}'${listaCores[x]}'${x === (listaCores.length - 1) ? ")" : ""}`;
            };
            where.push(coresWhere)
        };
        return where;
    };

    async function deletaRegistro() {
        $.LoadingOverlay('show');
        try {
            let filtros = JSON.stringify({
                PRODUTO: pegaChave("#txtProduto"),
                TABELA: pegaChave("#txtTabPreco"),
                SETOR: pegaChave("#txtSetor"),
                PARTE: pegaChave("#txtParte")
            });

            const response = await requisicao('DELETE', '/sisplan/facprecocortam/v1/deletar?', `JSON=${filtros}`, '', 600000);

            if (!response)
                throw new Error("Ocorreu um erro ao excluir os dados, tente novamente mais tarde.");

            const responsoStr = await response.json();

            if (response.status !== 200)
                throw new Error("Ocorreu um erro ao excluir os dados: " + responsoStr.mensagem);

            criaMensagemSucesso("Deletado com sucesso!", () => { voltar() })
        } catch (error) {
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function validaCamposPreenchidos() {
        $.LoadingOverlay('show');
        try {
            if ($("#txtProduto").val() === '')
                throw new Error("Necessário informar o campo: PRODUTO");

            if ($("#txtTabPreco").val() === '')
                throw new Error("Necessário informar o campo: TABELA");

            if ($("#txtSetor").val() === '')
                throw new Error("Necessário informar o campo: SETOR");

            if ($("#txtParte").val() === '')
                throw new Error("Necessário informar o campo: PARTE");

            const validaContinuacao = await validaContinuacaoF();

            if (validaContinuacao) {
                msgAguardaConfirmacao(
                    "Se o produto for alterado nessa tela, não poderá mais utilizar preço somente por produto ou cor, deseja continuar?",
                    () => { finalFunc(); },
                    () => { }
                );
            } else {
                finalFunc();
            };

            async function finalFunc() {
                bloqueiaCampos(
                    [
                        "#txtProduto", "#btnProduto", "#btnLimpaProduto",
                        "#txtTabPreco", "#btnTabPreco", "#btnLimpaTabPreco",
                        "#txtSetor", "#btnSetor", "#btnLimpaSetor",
                        "#txtParte", "#btnParte", "#btnLimpaParte"
                    ]
                );

                $("#atalhoPreenchimentoPrecoFac").removeClass("d-none")
                $("#atalhoPreenchimentoPrecoCusto").removeClass("d-none")
                $("#btnGravar").removeClass("d-none")
                if (jaExiste)
                    $("#btnExcluir").removeClass("d-none")
                $("#btnConsultar").prop("disabled", true)

                await buscarDados();
                await validaContinuacaoF();
                filtrado = true;
            };
        } catch (error) {
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
        };
    };

    async function validaContinuacaoF() {
        let validado = [];
        try {
            const filtros = JSON.stringify(await retornaFiltros(true));
            const response = await requisicao('GET', '/sisplan/facprecocortam/v1/buscadados?', `JSON=${filtros}&TELA_ACESSO=N`, '', 600000);

            if (!response)
                throw new Error("Ocorreu um erro ao buscar os dados, tente novamente mais tarde.");

            const dadosProdutos = await response.json();

            if (response.status !== 200)
                throw new Error("Ocorreu um erro ao buscar os dados: " + dadosProdutos.mensagem);

            const dados = dadosProdutos.RESULT;

            if (jaExiste) {
                if (!editar)
                    msgAlerta("Já existe registro para esse PRODUTO, TABELA, SETOR e PARTE. Será aberto o cadastro já existente.")

                for (let x = 0; x < dados.length; x++) {
                    $(`#input_${dados[x].COR}_${dados[x].TAMANHO}_Fac`).val(pontoPorVirgula(dados[x].PRECOFAC));
                    $(`#input_${dados[x].COR}_${dados[x].TAMANHO}_Custo`).val(pontoPorVirgula(dados[x].PRECOCUSTO));
                    $("#txtObs").val(decodeURIComponent(dados[x].OBSERVACAO.replaceAll("  ", "\n")));
                };
            } else {
                if (dados.length > 0) {
                    for (let x = 0; x < dados.length; x++) {
                        if (dados[x].TIPO !== "2") {
                            validado.push(true);
                        } else {
                            validado.push(false);
                        };
                    };
                    jaExiste = true;
                };
            };
        } finally {
            if (validado.includes(true))
                return true;
            else
                return false;
        };
    };

    async function retornaFiltros(lista = false) {
        let filtros = []
        if (lista) {
            filtros = {
                PRODUTO: await formataListas(pegaChave("#txtProduto")),
                TABELA: await formataListas(pegaChave("#txtTabPreco")),
                SETOR: await formataListas(pegaChave("#txtSetor")),
                PARTE: await formataListas(pegaChave("#txtParte"))
            };
        } else {
            filtros = {
                PRODUTO: pegaChave("#txtProduto"),
                TABELA: pegaChave("#txtTabPreco"),
                SETOR: pegaChave("#txtSetor"),
                PARTE: pegaChave("#txtParte")
            };
        };

        return filtros;
    };

    async function buscarDados() {
        $.LoadingOverlay('show');
        try {
            const filtros = await retornaFiltros();

            const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${filtros.PRODUTO}`, '', 600000);

            if (!response)
                throw new Error("Ocorreu um erro ao buscar os dados, tente novamente mais tarde.");

            const dadosProdutos = await response.json();

            if (response.status !== 200)
                throw new Error("Ocorreu um erro ao buscar os dados: " + dadosProdutos.mensagem);

            const dadosFormatadosFac = formatarTamanhos(dadosProdutos, 'Fac');
            const dadosFormatadosCusto = formatarTamanhos(dadosProdutos, 'Custo');

            criaTabelas(dadosFormatadosFac, dadosFormatadosCusto);
        } catch (error) {
            msgAlerta(error.message);
            console.error(error);
        } finally {
            pesquisaCamposCor(['Fac', 'Custo']);
            aplicaMascaraDinheiro();
            $.LoadingOverlay('hide');
        };
    };

    function pesquisaCamposCor(lista) {
        for (let x = 0; x < lista.length; x++) {
            $(`#btnAtalhoCorPreco${lista[x]}`).pesquisa(`#txtCorAtalhoPreco${lista[x]}`, 'COR', 'DESCRICAO', montaPesquisa(3, "CADCOR", '["COR","DESCRICAO"]'), 'Pesquisa Setor', 'CADSETOR');
            $(`#txtCorAtalhoPreco${lista[x]}`).autocompleta(1, montaPesquisa(4, "CADCOR", '["COR CHAVE","DESCRICAO DESCRICAO"]'));
            $(`#btnLimpaAtalhoCorPreco${lista[x]}`).on("click", function () { $(`#txtCorAtalhoPreco${lista[x]}`).val("") });
            aplicaMascaraDinheiro(`#txtPrecoAtalhoPreco${lista[x]}`);
        };
    };

    function formatarTamanhos(dados, tipo) {
        const precoFac = tipo === 'Fac';
        listaTamanhos = [];
        listaCores = [];
        let tamanhosAdicionados = new Set();
        let dadosFormatados = [];
        dadosFormatados = dados.map(item => {
            let novoItem = {
                COR: item.COR,
                DESC_COR: item.DESC_COR
            };

            listaCores.push(item.COR);

            Object.keys(item).forEach(chave => {
                if (chave.includes('HIFEN')) {
                    let nomeTamanho = chave.split('HIFEN')[1];
                    const id = `input_${item.COR}_${nomeTamanho}_${tipo}`
                    listaIds.push(id);

                    if (!tamanhosAdicionados.has(nomeTamanho)) {
                        if (precoFac)
                            colunasTabelaFac.push({ data: nomeTamanho, title: nomeTamanho });
                        else
                            colunasTabelaCusto.push({ data: nomeTamanho, title: nomeTamanho });

                        listaTamanhos.push(nomeTamanho);
                        tamanhosAdicionados.add(nomeTamanho);
                    };

                    novoItem[nomeTamanho] = `<input type="text" class="input-default focus form-control validate controle-edicao" style="text-align: end;" id="${id}" placeholder="0,00">`;
                };
            });

            return novoItem;
        });

        return dadosFormatados;
    };

    function aplicaMascaraDinheiro(id = null) {
        if (id === null) {
            for (let x = 0; x < listaIds.length; x++) {
                $(`#${listaIds[x]}`).maskMoney({
                    decimal: ',',
                    thousands: '',
                    precision: 2
                });
            };
        } else {
            $(id).maskMoney({
                decimal: ',',
                thousands: '',
                precision: 2
            });
        };
    };

    function preencheCamposAtalho(PrecoFac) {
        $.LoadingOverlay('show');

        const tipo = PrecoFac ? "Fac" : "Custo";

        try {
            if ($(`#txtPercAtalhoPreco${tipo}`).val() === '' && $(`#txtPrecoAtalhoPreco${tipo}`).val() === '')
                throw new Error(`Necessário informar o campo "PREÇO" ou "PERCENTUAL"!`);

            const percentual = ($(`#txtPercAtalhoPreco${tipo}`).val() / 100);
            const preco = parseFloat($(`#txtPrecoAtalhoPreco${tipo}`).val());

            for (let x = 0; x < listaTamanhos.length; x++) {
                if (todasCores) {
                    for (let y = 0; y < listaCores.length; y++) {
                        atalhoPreencher(listaCores[y], listaTamanhos[x], tipo, preco, percentual);
                    };
                } else {
                    atalhoPreencher(pegaChave(`#txtCorAtalhoPreco${tipo}`), listaTamanhos[x], tipo, preco, percentual);
                };
            };
        } catch (error) {
            msgAlerta(error.message);
        } finally {
            $(`#txtPercAtalhoPreco${tipo}`).val("");
            $(`#txtPrecoAtalhoPreco${tipo}`).val("");
            $(`#txtCorAtalhoPreco${tipo}`).val("");
            $.LoadingOverlay('hide');
        };
    };

    function atalhoPreencher(cor, tam, tipo, preco, percentual) {
        const idCampo = `#input_${cor}_${tam}_${tipo}`;

        const temPercentual = $(`#txtPercAtalhoPreco${tipo}`).val() !== '';
        const temPreco = $(`#txtPrecoAtalhoPreco${tipo}`).val() !== '';
        const valorAtual = parseFloat($(idCampo).val()) || 0;

        if (temPercentual && temPreco) {
            $(idCampo).val(pontoPorVirgula(preco * percentual + preco));
        } else if (!temPercentual && temPreco) {
            $(idCampo).val(pontoPorVirgula(preco));
        } else if (temPercentual && !temPreco) {
            $(idCampo).val(pontoPorVirgula(valorAtual * percentual + valorAtual));
        } else {
            throw new Error(`Necessário informar o campo "PREÇO" ou "PERCENTUAL"!`);
        };
    };

    function pontoPorVirgula(texto) {
        return parseFloat(texto).toFixed(2).toString().replaceAll(".", ",")
    };

    function criaTabelas(dataFac, dataCusto) {
        let colunasFormatar = [];
        for (let x = 0; x < listaTamanhos.length; x++) {
            colunasFormatar.push(2 + x);
        };
        criaDataTableCamposNaoFixos("#tabelaGrade_precoFac", "15vh", dataFac, colunasTabelaFac, [], [], [], 0, colunasFormatar, [], false, [], false)
        criaDataTableCamposNaoFixos("#tabelaGrade_precoCustos", "15vh", dataCusto, colunasTabelaCusto, [], [], [], 0, colunasFormatar, [], false, [], false)
    };

    function pegaDados() {
        let tamanhos = [];
        let indicesTamanhos = [];

        $("#tabelaGrade_precoFac thead th").each(function (index) {
            let titulo = $(this).text().trim();
            if (titulo !== "Cor" && titulo !== "Desc. Cor") {
                tamanhos.push(titulo);
                indicesTamanhos.push(index);
            }
        });

        let dadosPrecoFac = montaDadosGrade("#tabelaGrade_precoFac", "faccao", indicesTamanhos, tamanhos);
        let dadosPrecoCusto = montaDadosGrade("#tabelaGrade_precoCustos", "custo", indicesTamanhos, tamanhos);

        let gradeFinal = [];

        dadosPrecoFac.forEach(function (itemFac) {
            let itemCusto = dadosPrecoCusto.find(function (item) {
                return item.cor === itemFac.cor;
            });

            let tamanhos = itemFac.tamanhos.map(function (t, idx) {
                return {
                    tamanho: t.tamanho,
                    precoFac: (t.preco !== undefined && t.preco !== null) ? Number(t.preco).toFixed(2) : '',
                    precoCusto: (itemCusto.tamanhos[idx] && itemCusto.tamanhos[idx].preco !== undefined && itemCusto.tamanhos[idx].preco !== null)
                        ? Number(itemCusto.tamanhos[idx].preco).toFixed(2)
                        : ''
                };
            });

            gradeFinal.push({
                tipo: itemFac.tipo,
                cor: itemFac.cor,
                tamanhos: tamanhos
            });
        });


        return {
            produto: pegaChave("#txtProduto"),
            tabela: pegaChave("#txtTabPreco"),
            setor: pegaChave("#txtSetor"),
            parte: pegaChave("#txtParte"),
            tipo: "2",
            observacao: $("#txtObs").val().toString(),
            grade: gradeFinal
        };
    }

    function montaDadosGrade(tabelaId, tipo, idxTamanhos, tamanhos) {
        return $(tabelaId + " tbody tr").map(function () {
            let tds = $(this).find("td");
            let item = {
                tipo: tipo,
                cor: $(tds[0]).text().trim(),
                tamanhos: []
            };

            idxTamanhos.forEach(function (index, idx) {
                let preco = parseFloat($(tds[index]).find("input").val().replaceAll(",", ".") || 0);
                item.tamanhos.push({
                    tamanho: tamanhos[idx],
                    preco: preco
                });
            });

            return item;
        }).get();
    }


    async function gravarPreco() {
        $.LoadingOverlay('show')
        try {
            const dados = pegaDados();

            const response = await requisicao(jaExiste ? 'PUT' : 'POST', '/sisplan/facprecocortam/v1/gravardados?', `JSON=${JSON.stringify(dados)}`, '', 600000);

            if (!response)
                throw new Error("Não foi possível gravar os dados, tente novamente mais tarde!");

            const jsonResponse = await response.json();

            if (response.status !== 200)
                throw new Error("Não foi possível gravar os dados: ", jsonResponse.mensagem);

            criaMensagemSucesso("Dados gravados com Sucesso!", () => { voltar() });
        } catch (error) {
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
        };
    };

    function criaDataTableCamposNaoFixos(
        sIdTabela,
        sScrollY = "30vh",
        sData,
        sColumns,
        sColunasInvisiveis = [],
        sColunasDinheiro = [],
        sColunasDecimais = [],
        casasDecimais = 0,
        sColunasCentro = [],
        sColunasDireita = [],
        sBotoesOpcoes = false,
        sBotoesOpcoesPersonalizados = [],
        sBotoesTabela = true,
    ) {
        criaDataTablePadrao(
            sIdTabela,
            false,
            false,
            false,
            true,
            true,
            false,
            sScrollY,
            sData,
            sColumns,
            sColunasInvisiveis,
            [],
            sColunasDinheiro,
            sColunasDecimais,
            {},
            casasDecimais,
            sBotoesTabela ? `buttonColVis_${sIdTabela.replace("#", "")}` : "",
            sBotoesTabela ? `buttonExcel_${sIdTabela.replace("#", "")}` : "",
            false,
            sColunasCentro,
            sColunasDireita,
            [],
            [],
            false,
            sBotoesOpcoes,
            sBotoesOpcoesPersonalizados
        );
    };
});