function validarCaracteres(value) {
  const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
  return result?.length ?? 0;
}

$(document).ready(async function () {
  $('.main-footer').css('margin-bottom', '4.5%')
  await preencheSelectUnidade()

  if (getCookie("usuario") == "") {
    window.location.href = `${BASE_URI}/login`;
    return;
  }

  $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["TIPO='S'"]}`);
  $('#txtCSTIPI').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtCodigoSped').autocompleta(1, `JSON={ "tabela":"TABSPED", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtCodigoLST').autocompleta(1, `JSON={ "tabela":"TABSERV", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtRamoAtuacao').autocompleta(1, `JSON={ "tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtFornecedorINSS').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtClasseGerINSS').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtFornecedorPIS').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": ["TIPO = 'O'"]}`);
  $('#txtClasseGerPIS').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtFornecedorISS').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtClasseGerISS').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtFornecedorIRRF').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtClasseGerIRRF').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGI CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtFornecedorCOFINS').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtClasseGerCOFINS').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtFornecedorCSLL').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtClasseGerCSLL').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtFornecedorCSRF').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtClasseGerCSRF').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtCentroCusto').autocompleta(1, `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtCliente').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);

  $("#btnGrupo").pesquisa("#txtGrupo", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["TIPO='S'"]}`, "Pesquisa Grupo", "GRUPO_MA");
  $("#btnCSTIPI").pesquisa("#txtCSTIPI", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa CST IPI", "TABIPI");
  $("#btnCodigoSped").pesquisa("#txtCodigoSped", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSPED", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Código Sped", "TABSPED");
  $("#btnCodigoLST").pesquisa("#txtCodigoLST", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSERV", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Código LST", "TABSERV");
  $("#btnRamoAtuacao").pesquisa("#txtRamoAtuacao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Ramo Atuação", "RAMO_ATUACAO");
  $("#btnFornecedorINSS").pesquisa("#txtFornecedorINSS", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Grupo INSS", "ENTIDADE");
  $('#btnClasseGerINSS').pesquisa('#txtClasseGerINSS', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe INSS', 'CLASSE_GER');
  $("#btnFornecedorPIS").pesquisa("#txtFornecedorPIS", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Grupo PIS", "ENTIDADE");
  $('#btnClasseGerPIS').pesquisa('#txtClasseGerPIS', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe PIS', 'CLASSE_GER');
  $("#btnFornecedorISS").pesquisa("#txtFornecedorISS", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Grupo ISS", "ENTIDADE");
  $('#btnClasseGerISS').pesquisa('#txtClasseGerISS', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe ISS', 'CLASSE_GER');
  $("#btnFornecedorIRRF").pesquisa("#txtFornecedorIRRF", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Grupo IRRF", "ENTIDADE");
  $('#btnClasseGerIRRF').pesquisa('#txtClasseGerIRRF', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe IRRF', 'CLASSE_GER');
  $("#btnFornecedorCOFINS").pesquisa("#txtFornecedorCOFINS", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Grupo COFINS", "ENTIDADE");
  $('#btnClasseGerCOFINS').pesquisa('#txtClasseGerCOFINS', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe COFINS', 'CLASSE_GER');
  $("#btnFornecedorCSLL").pesquisa("#txtFornecedorCSLL", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Grupo CSLL", "ENTIDADE");
  $('#btnClasseGerCSLL').pesquisa('#txtClasseGerCSLL', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe CSLL', 'CLASSE_GER');
  $("#btnFornecedorCSRF").pesquisa("#txtFornecedorCSRF", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Grupo CSRF", "GRUPO_CLI");
  $('#btnClasseGerCSRF').pesquisa('#txtClasseGerCSRF', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe CSRF', 'CLASSE_GER');
  $("#btnCentroCusto").pesquisa("#txtCentroCusto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Centro Custo", "CENTROCUSTO");
  $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');

  $("#btnLimpaGrupo").on("click", function () {
    $("#txtGrupo").val("");
  });

  $('#btnLimpaCSTIPI').on('click', function () {
    $('#txtCSTIPI').val('');
  });

  $('#btnLimpaCodigoSped').on('click', function () {
    $('#txtCodigoSped').val('');
  });

  $('#btnCodigoLST').on('click', function () {
    $('#txtCodigoLST').val('');
  });

  $("#btnRamoAtuacao").on('click', function () {
    $('#txtRamoAtuacao').val('');
  });

  $('#btnLimpaFornecedorINSS').on('click', function () {
    $('#txtFornecedorINSS').val('')
  });

  $('#btnLimpaClasseGerINSS').on('click', function () {
    $('#txtClasseGerINSS').val('')
  });

  $('#btnLimpaFornecedorPIS').on('click', function () {
    $('#txtFornecedorPIS').val('')
  });

  $('#btnLimpaClasseGerPIS').on('click', function () {
    $('#txtClasseGerPIS').val('')
  });

  $('#btnLimpaFornecedorISS').on('click', function () {
    $('#txtFornecedorISS').val('')
  });

  $('#btnLimpaClasseGerISS').on('click', function () {
    $('#txtClasseGerISS').val('')
  });

  $('#btnLimpaFornecedorIRRF').on('click', function () {
    $('#txtFornecedorIRRF').val('')
  });

  $('#btnLimpaClasseGerIRRF').on('click', function () {
    $('#txtClasseGerIRRF').val('')
  });

  $('#btnLimpaFornecedorCOFINS').on('click', function () {
    $('#txtFornecedorCOFINS').val('')
  });

  $('#btnLimpaClasseGerCOFINS').on('click', function () {
    $('#txtClasseGerCOFINS').val('')
  });

  $('#btnLimpaFornecedorCSLL').on('click', function () {
    $('#txtFornecedorCSLL').val('')
  });

  $('#btnLimpaClasseGerCSLL').on('click', function () {
    $('#txtClasseGerCSLL').val('')
  });

  $('#btnLimpaFornecedorCSRF').on('click', function () {
    $('#txtFornecedorCSRF').val('')
  });

  $('#btnLimpaClasseGerCSRF').on('click', function () {
    $('#txtClasseGerCSRF').val('')
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let servico = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("CADSERVICO", getCookie("usuario"), servico);
    window.location.href = `${BASE_URI}/cadservico`;
  });

  $('#txtGrupo').on('blur', function () {
    if (!buscaValor('GRUPO_MA', 'CODIGO', 'CODIGO', $('#txtGrupo').val())) {
      throw msgAlerta('Grupo Invalido');
    }
  });

  $("#msform").validate({
    async submitHandler(form, event) {
      event.preventDefault();
      try {
        $.LoadingOverlay("show");
        try {
          if (!$('#txtDescricao').val()) {
            throw msgAlerta('Necessário informar uma descrição, verifique!');
          }
          if (!$('#txtGrupo').val()) {
            throw msgAlerta('Necessário informar um grupo, verifique!');
          }
          if (!$('#selectUnidade').val()) {
            throw msgAlerta('Necessário informar uma unidade, verifique!');
          }
          if ($('#txtAliquotaCSRF').val() > 0) {
            if ($('#txtAliquotaPIS').val() > 0) {
              throw msgAlerta('Valor do PIS informado. Para quando valor CSRF é maior que zero o valor do PIS não pode ter valor. Impossível Continuar.');
            }
            else if ($('#txtAliquotaCOFINS').val() > 0) {
              throw msgAlerta('Valor do COFINS informado. Para quando valor CSRF é maior que zero o valor do COFINS não pode ter valor. Impossível Continuar.');
            }
            else if ($('#txtAliquotaCSLL').val() > 0) {
              throw msgAlerta('Valor do CSLL informado. Para quando valor CSRF é maior que zero o valor do CSLL não pode ter valor. Impossível Continuar.');
            }
          }
          // if(!buscaValor('CENTROCUSTO', 'CODIGO', 'CODIGO', $('txtCentroCustro').val())){
          //   throw msgAlerta('Atenção centro de custo informado não existe ou não foi informado.')
          // }

          let classService = {
            CODIGO: $('#txtCodigo').val(),
            COMPLEMENTO: $('#txtComplemento').val(),
            DESCRICAO: $('#txtDescricao').val(),
            FORCOFINS: pegaChave('#txtFornecedorCOFINS'),
            FORCSLL: pegaChave('#txtFornecedorCSLL'),
            FORINSS: pegaChave('#txtFornecedorINSS'),
            FORIRRF: pegaChave('#txtFornecedorIRRF'),
            FORISS: pegaChave('#txtFornecedorISS'),
            FORPIS: pegaChave('#txtFornecedorPIS'),
            GRUPO: pegaChave('#txtGrupo'),
            UNIDADE: $('#selectUnidade').val(),
            CODIPI: pegaChave('#txtCSTIPI'),
            CODSPED: pegaChave('#txtCodigoSped'),
            SIT_TRIB: $('input[name="Tributacao"]:checked').val(),
            CODSERV: pegaChave('#txtCodigoLST'),
            ATIVO: $('#cbAtivo').is(':checked') ? 'S' : 'N',
            CODIGO_MUNICIPIO: $('#txtCodMunicipio').val(),
            CODNAT: $('#txtCodNat').val(),
            COFINS: $('#txtAliquotaCOFINS').val(),
            CSLL: $('#txtAliquotaCSLL').val(),
            INSS: $('#txtAliquotaINSS').val(),
            IRRF: $('#txtAliquotaIRRF').val(),
            ISS: $('#txtAliquotaISS').val(),
            PIS: $('#txtAliquotaPIS').val(),
            IRPF: $('#txtAliquotaIRPF').val(),
            CSRF: $('#txtAliquotaCSRF').val(),
            PERC_COFINS_ENTR: $('#txtCredCOFINS').val(),
            PERC_PIS_ENTR: $('#txtCredPIS').val(),
            PRECO: $('#txtPreco').val(),
            PERC_IMPOSTO: $('#txtPercImposto').val(),
            CDCENTRO: pegaChave('#txtCentroCusto'),
            FORCSRF: pegaChave('#txtFornecedorCSRF'),
            CLASSE_INSS: pegaChave('#txtClasseGerINSS'),
            CLASSE_PIS: pegaChave('#txtClasseGerPIS'),
            CLASSE_ISS: pegaChave('#txtClasseGerISS'),
            CLASSE_IRRF: pegaChave('#txtClasseGerIRRF'),
            CLASSE_COFINS: pegaChave('#txtClasseGerCOFINS'),
            CLASSE_CSLL: pegaChave('#txtClasseGerCSLL'),
            CLASSE_CSRF: pegaChave('#txtClasseGerCSRF'),
            // COD_IMPORTADO: $('#txt').val(),
            VALOR_MIN_INSS: $('#txtValorMinINSS').val(),
            VALOR_MIN_PIS: $('#txtValorMinPIS').val(),
            VALOR_MIN_ISS: $('#txtValorMinISS').val(),
            VALOR_MIN_IRRF: $('#txtValorMinIRRF').val(),
            VALOR_MIN_COFINS: $('#txtValorMinCOFINS').val(),
            VALOR_MIN_CSLL: $('#txtValorMinCSLL').val(),
            VALOR_MIN_CSRF: $('#txtValorMinCSRF').val(),
            CLIENTE_CONTRATO: pegaChave('#txtCliente'),
            VALOR_CONTRATO: $('#txtValor').val(),
            QTDE_CONTRATO: $('#txtQuantidade').val(),
            VALOR_EXCED_CONTRATO: $('#txtValorExcedente').val(),
            PERIODO_CONTRATO: $('#txtPeriodo').val(),
            // BAIXADO: $('#txt').val(),
            MESES_CONTRATO: $('#txtQtdeMeses').val(),
            DESC_ISS_CONTRATO: $('#cbRetISS').is(':checked') ? 'S' : 'N',
            DESC_FED_CONTRATO: $('#cbRetFed').is(':checked') ? 'S' : 'N',
            CODIGO2: $('#txtCodigo2').val(),
            NUM_CONTRATO: $('#txtNumContrato').val(),
            VIGENCIA: $('#dtCadastro').val() != '' ? $('#dtCadastro').val() : '1899-01-01',
            CNAE: $('#txtCNAE').val(),
            PARCELAR_CSRF: $('#cbParcelarCSRF').is(':checked') ? 'S' : 'N',
            COD_RET_IR: $('#txtCodRetIRRF').val(),
            COD_RET_PIS: $('#txtCodRetPIS').val(),
            COD_RET_COFINS: $('#txtCodRetCOFINS').val(),
            COD_RET_CSLL: $('#txtCodRetCSLL').val(),
            COD_RET_CSRF: $('#txtCodRetCSRF').val(),
            RAMO_ATUACAO: pegaChave('#txtRamoAtuacao'),
            DT_VALIDADE: $('#dtValidade').val() != '' ? $('#dtValidade').val() : '1899-01-01',
            TIPO_MANUT: $('input[name="tipoManutencao"]:checked').val(),
          };

          let response = await requisicao("POST", `/sisplan/cadastros/V1/servico?`, `JSON=${JSON.stringify(classService)}`);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgAlerta(jsonStr.mensagem);
            return;
          }

          toastr
            .success("Cadastro efetuado com sucesso!", "Confirmação", {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.href = `${BASE_URI}/cadservico`;
              },
            })
            .css({
              "margin-top": "20%",
              width: "500px",
              "max-width": "500px",
            });
        } catch (error) {
          console.error(error);
          // msgAlerta('Não foi possível gravar os dados do cliente!');
        }

      } finally {
        $.LoadingOverlay("hide");
      }
    },
  });

  async function validaCodigoExistente() {
    if (await buscaValor('SERVICO', 'CODIGO', 'CODIGO', $('#txtCodigo').val())) {
      throw msgAlerta('Código já cadastrado, verifique!');
    }
  };

  $('#txtCodigo').on('blur', async function () {
    if (!$('#txtCodigo').val()) {
      $('#txtCodigo').val(await RetornaProximo('SERVICO', 'SERVICO', 'CODIGO', 5));
    } else {
      await validaCodigoExistente();
    }
  });

  $('input').keyup(function () {
    $(this).val($(this).val().toUpperCase());
  });

  async function buscaDadosServico(codigo) {
    try {
      $.LoadingOverlay("show");
      let servico = '';
      servico += codigo != '' ? ` AND CODIGO = '${codigo}'` : '';

      response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"SERVICO", "camposSelect": [
      "SERVICO.CODIGO", "SERVICO.COMPLEMENTO", "SERVICO.DESCRICAO", "SERVICO.FORCOFINS", "SERVICO.FORCSLL", "SERVICO.FORINSS", "SERVICO.FORIRRF", "SERVICO.FORISS",
      "SERVICO.FORPIS", "SERVICO.GRUPO", "SERVICO.UNIDADE", "SERVICO.CODIPI", "SERVICO.CODSPED", "SERVICO.SIT_TRIB", "SERVICO.CODSERV", "SERVICO.ATIVO", "SERVICO.CODIGO_MUNICIPIO",
      "SERVICO.CODNAT", "SERVICO.COFINS", "SERVICO.CSLL", "SERVICO.INSS", "SERVICO.IRRF", "SERVICO.ISS ", "SERVICO.PIS ", "SERVICO.IRPF", "SERVICO.PERC_COFINS_ENTR",
      "SERVICO.PERC_PIS_ENTR", "SERVICO.PRECO ", "SERVICO.PERC_IMPOSTO", "SERVICO.CDCENTRO", "SERVICO.FORCSRF", "SERVICO.CSRF", "SERVICO.CLASSE_INSS", "SERVICO.CLASSE_PIS", 
      "SERVICO.CLASSE_ISS", "SERVICO.CLASSE_IRRF", "SERVICO.CLASSE_COFINS", "SERVICO.CLASSE_CSLL", "SERVICO.COD_IMPORTADO", "SERVICO.VALOR_MIN_INSS", "SERVICO.VALOR_MIN_PIS",
      "SERVICO.VALOR_MIN_ISS", "SERVICO.VALOR_MIN_IRRF", "SERVICO.VALOR_MIN_COFINS", "SERVICO.VALOR_MIN_CSLL", "SERVICO.CLASSE_CSRF", "SERVICO.VALOR_MIN_CSRF", "SERVICO.ID",
      "SERVICO.CLIENTE_CONTRATO", "SERVICO.VALOR_CONTRATO", "SERVICO.QTDE_CONTRATO", "SERVICO.VALOR_EXCED_CONTRATO", "SERVICO.PERIODO_CONTRATO", "SERVICO.BAIXADO", "SERVICO.MESES_CONTRATO",
      "SERVICO.DESC_ISS_CONTRATO", "SERVICO.CODIGO2", "SERVICO.NUM_CONTRATO", "SERVICO.VIGENCIA  ", "SERVICO.CNAE", "SERVICO.PARCELAR_CSRF", "SERVICO.DESC_FED_CONTRATO",
      "SERVICO.COD_RET_IR", "SERVICO.COD_RET_PIS", "SERVICO.COD_RET_COFINS", "SERVICO.COD_RET_CSLL", "SERVICO.RAMO_ATUACAO", "SERVICO.DT_VALIDADE", "SERVICO.TIPO_MANUT", "SERVICO.COD_RET_CSRF"]
      "where": ["1=1 ${servico}"]}`, null);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      return jsonStr.RESULT[0][0];

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  const mudarTributacao = {
    'N': () => $('#rgNormal').prop('checked', true),
    'T': () => $('#rgNormalTrib').prop('checked', true),
    'R': () => $('#rgRetida').prop('checked', true),
    'S': () => $('#rgSubstituida').prop('checked', true),
    'I': () => $('#rgIsenta').prop('checked', true),
    'O': () => $('#rgOrgaoMun').prop('checked', true),
    'P': () => $('#rgPgMun').prop('checked', true),
    '': () => ''
  }

  const mudarManutencao = {
    'N': () => $('#rgNenhum').prop('checked', true),
    'M': () => $('#rgMaquina').prop('checked', true),
    'F': () => $('#rgFrota').prop('checked', true),
    '': () => '',
  }

  function preencheCampos(servico) {
    $('#selectUnidade').val(servico.UNIDADE);
    $("#cbAtivo").prop("checked", servico.ATIVO == 'S');
    mudarTributacao[servico.SIT_TRIB]();
    mudarManutencao[servico.TIPO_MANUT]();
    $('#txtCodigo').val(servico.CODIGO);
    $('#txtCodigo2').val(servico.CODIGO2);
    $('#txtDescricao').val(servico.DESCRICAO);
    $('#txtComplemento').val(servico.COMPLEMENTO);
    insereValor('#txtGrupo', servico.GRUPO, { tabela: 'GRUPO_MA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.GRUPO });
    insereValor('#txtCSTIPI', servico.CODIPI, { tabela: 'TABIPI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CODIPI });
    insereValor('#txtCodigoSped', servico.CODSPED, { tabela: 'TABSPED', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CODSPED });
    insereValor('#txtCodigoLST', servico.CODSERV, { tabela: 'TABSERV', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CODSERV });
    $('#txtPreco').val(servico.PRECO);
    $('#txtCodNat').val(servico.CODNAT);
    $('#txtCodMunicipio').val(servico.CODIGO2);
    $('#txtCNAE').val(servico.CNAE);
    $('#txtPercImposto').val(servico.PERC_IMPOSTO);
    insereValor('#txtRamoAtuacao', servico.RAMO_ATUACAO, { tabela: 'RAMO_ATUACAO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.RAMO_ATUACAO });
    insereValor('#txtCentroCusto', servico.CDCENTRO, { tabela: 'CENTROCUSTO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CDCENTRO });

    insereValor('#txtFornecedorINSS', servico.FORINSS, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: servico.FORINSS });
    insereValor('#txtClasseGerINSS', servico.CLASSE_INSS, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CLASSE_INSS });
    $('#txtClasseGerINSS').val(servico.CLASSE_INSS);
    $('#txtAliquotaINSS').val(servico.INSS);
    $('#txtValorMinINSS').val(servico.VALOR_MIN_INSS);

    insereValor('#txtFornecedorPIS', servico.FORPIS, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: servico.FORPIS });
    insereValor('#txtClasseGerPIS', servico.CLASSE_PIS, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CLASSE_PIS });
    $('#txtAliquotaPIS').val(servico.PIS);
    $('#txtValorMinPIS').val(servico.VALOR_MIN_PIS);
    $('#txtCodRetPIS').val(servico.COD_RET_PIS);

    insereValor('#txtFornecedorISS', servico.FORISS, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: servico.FORISS });
    insereValor('#txtClasseGerISS', servico.CLASSE_ISS, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CLASSE_ISS });
    $('#txtAliquotaISS').val(servico.ISS);
    $('#txtValorMinISS').val(servico.VALOR_MIN_ISS);

    insereValor('#txtFornecedorIRRF', servico.FORIRRF, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: servico.FORIRRF });
    insereValor('#txtClasseGerIRRF', servico.CLASSE_IRRF, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CLASSE_IRRF });
    $('#txtAliquotaIRRF').val(servico.IRRF);
    $('#txtValorMinIRRF').val(servico.VALOR_MIN_IRRF);
    $('#txtCodRetIRRF').val(servico.COD_RET_IR);

    insereValor('#txtFornecedorCOFINS', servico.FORCOFINS, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: servico.FORCOFINS });
    insereValor('#txtClasseGerCOFINS', servico.CLASSE_COFINS, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CLASSE_COFINS });
    $('#txtAliquotaCOFINS').val(servico.COFINS);
    $('#txtValorMinCOFINS').val(servico.VALOR_MIN_COFINS);
    $('#txtCodRetCOFINS').val(servico.COD_RET_COFINS);

    insereValor('#txtFornecedorCSLL', servico.FORCSLL, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: servico.FORCSLL });
    insereValor('#txtClasseGerCSLL', servico.CLASSE_CSLL, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CLASSE_CSLL });
    $('#txtAliquotaCSLL').val(servico.CSLL);
    $('#txtValorMinCSLL').val(servico.VALOR_MIN_CSLL);
    $('#txtCodRetCSLL').val(servico.COD_RET_CSLL);

    insereValor('#txtFornecedorCSRF', servico.FORCSRF, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: servico.FORCSRF });
    insereValor('#txtClasseGerCSRF', servico.CLASSE_CSRF, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: servico.CLASSE_CSRF });
    $('#txtAliquotaCSRF').val(servico.CSRF);
    $('#txtValorMinCSRF').val(servico.VALOR_MIN_CSRF);
    $('#txtCodRetCSRF').val(servico.COD_RET_CSRF);
    $("#cbParcelarCSRF").prop("checked", servico.PARCELAR_CSRF == 'S');

    $('#txtCredCOFINS').val(servico.PERC_COFINS_ENTR);
    $('#txtCredPIS').val(servico.PERC_PIS_ENTR);

    insereValor('#txtCliente', servico.CLIENTE_CONTRATO, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: servico.CLIENTE_CONTRATO });
    $('#txtPeriodo').val(servico.PERIODO_CONTRATO);
    $('#txtQtdeMeses').val(servico.MESES_CONTRATO);
    $('#txtValor').val(servico.VALOR_CONTRATO);
    $('#txtQuantidade').val(servico.QTDE_CONTRATO);
    $('#txtValorExcedente').val(servico.VALOR_EXCED_CONTRATO);
    $('#txtNumContrato').val(servico.NUM_CONTRATO);
    $('#dtValidade').val(servico.VIGENCIA);
    $('#dtCadastro').val(servico.DT_VALIDADE);
    $('#cbRetFed').prop('checked', servico.DESC_FED_CONTRATO == 'S');
    $('#cbRetISS').prop('checked', servico.DESC_ISS_CONTRATO == 'S');
  }

  if (servico != "" && servico != "create") {
    $('#txtCodigo').attr('disabled', true);
    let dados = await buscaDadosServico(servico);
    preencheCampos(dados);
  } else {
    $("#cbAtivo").prop("checked", true);
  }

  async function preencheSelectUnidade() {
    let data = await buscaUnidade();
    data.map(unidade => { $('#selectUnidade').append($('<option>', { value: unidade.UNIDADE, text: unidade.UNIDADE })); })
  }

  async function buscaUnidade() {
    let response = '';
    try {
      $.LoadingOverlay("show");
      response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"UNIDADE", "camposSelect":[ "UNIDADE"], "where": ["ATIVO = 'S'"]}`, null);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      return jsonStr.RESULT[0];

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }
  $(".collapse")
    .on("shown.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
      clicked
        .parent()
        .find(".fa-angle-right")
        .removeClass("fa-angle-right")
        .addClass("fa-angle-down");
    })
    .on("hidden.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });

  $('#txtCodigo').focus()

  $("#tutorial").on("click", function () {
    $("#geral-tab").trigger("click");
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == "geral") {
          if (!$("#multiCollapseExample1").hasClass("show"));
          $("#multiCollapseExample1").collapse("show");
        } else if (Element.node.id == "tributacao") {
          if (!$("#multiCollapseExample2").hasClass("show")) {
            $("#multiCollapseExample2").collapse("show");
          }
        } else if (Element.node.id == "dados_contrato") {
          if (!$("#multiCollapseExample3").hasClass("show")) {
            $("#multiCollapseExample3").collapse("show");
          }
        }
      },
    });
    driver.defineSteps([{
      element: "#geral-tab",
      popover: {
        title: "Aba Geral",
        description: "Clique aqui para abrir a aba geral.",
        position: "top",
      },
    },
    {
      element: "#geral",
      popover: {
        title: "Cadastro Geral",
        description: "Aqui você pode informar os dados gerais de cadastro dos Clientes/Fornecedores.",
        position: "bottom",
      },
    },
    {
      element: "#multiCollapseExample1",
      popover: {
        title: "Dados de Cadastro Geral",
        description: "Esses são os campos que você informará os dados gerais de cadastro.",
        position: "top",
      },
    },
    {
      element: "#tributacao",
      popover: {
        title: "Cadastro Tributação",
        description: "Aqui você pode informar os dados tributários de cadastro dos Serviços.",
        position: "top",
      },
    },
    {
      element: "#multiCollapseExample3",
      popover: {
        title: "Dados Tributação",
        description: "Aqui estão listados separadamente cada tributo.",
        position: "top",
      },
    },
    {
      element: "#btnGravar",
      popover: {
        title: "Botão Gravar",
        description: "Ao clicar nesse botão você grava os dados inseridos.",
        position: "left",
      },
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description: "Ao clicar nesse botão você retorna para a tela de consulta dos Serviços.",
        position: "left",
      },
    },
    ]);

    driver.start();
    driver.getHighlightedElement();
  });
});