$(document).ready(async function () {
    let abaEstoque = true;
    let abaEstoqueDep = false;
    let lastElemento;

    $('#modal-proditensest').on('show.bs.modal', async function () {
        await consultaEstoqueProd();
        $('#inputgroupdeposito').addClass('d-none');
        $('#cbContemEstoque').prop('checked', false);
    });

    $('#custom-tab-estoque').on('click', async function () {
        abaEstoque = true;
        abaEstoqueDep = false;
        if ($('#txtDepositoProdEst').val() == '') {
            $('#listaDepositoProdEst').val('');
        }
        $('#txtDepositoProdEst').val('');
        await consultaEstoqueProd();
        $('#inputgroupdeposito').addClass('d-none');
    });

    $('#cbContemEstoque').on('click', async function () {
        await consultaEstoqueProd();
    });

    $('#listaDepositoProdEst').on('change', async function () {
        await consultaEstoqueProd();
    })


    document.getElementById('txtDepositoProdEst').addEventListener('focusout', async function () {
        await consultaEstoqueProd();
    })


    $('#custom-tab-estoqueprod').on('click', async function () {
        abaEstoque = false;
        abaEstoqueDep = true;
        if ($('#txtDepositoProdEst').val() == '') {
            $('#listaDepositoProdEst').val('');
        }
        $('#txtDepositoProdEst').val('');
        await consultaEstoqueProd();
        $('#inputgroupdeposito').removeClass('d-none');

    });

    $('#txtDepositoProdEst').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO chave", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnConsultaDepProdEst').pesquisa_serverside(['#txtDepositoProdEst'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Depósito');
    $('#txtDepositoProdEst').listaFiltros();

    $('#btnLimpaConsultaDepProdEst').on('click', function () {
        if ($('#txtDepositoProdEst').val() == '') {
            $('#listaDepositoProdEst').val('');
        }
        $('#txtDepositoProdEst').val('');
        $('#txtDepositoProdEst').focus();
    });

    async function consultaEstoqueProd() {

        if ($.fn.DataTable.isDataTable('#tabelaProdEstoqueDep', '#tabelaProdEstoque')) {
            $('#tabelaProdEstoqueDep', '#tabelaProdEstoque').DataTable().destroy();
            $('#tabelaProdEstoqueDep', '#tabelaProdEstoque').empty();
        };

        const sCodigo = $('#txtTituloProdEst').val();
        const sComEstoque = $('#cbContemEstoque').is(':checked');
        const sDepositos = await formataListas($('#listaDepositoProdEst').val());

        const PesquisaEstoque = {
            tabela: "PA_ITEN",
            camposSelect: ["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO AS DESC_COR", "PA_ITEN.TAM", "PA_ITEN.QUANTIDADE", "PA_ITEN.BARRA", "PA_ITEN.BARRA28",
                "PA_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO AS DESC_DEPOSITO", "PA_ITEN.LOTE", "PA_ITEN.PERCENTUAL", "PA_ITEN.QTDE_BRUTO", "PA_ITEN.ROMANEIO", "PA_ITEN.TIPO",
                "PA_ITEN.COMPOSICAO", "PA_ITEN.BARRACLI", "PA_ITEN.ORDEM", "PA_ITEN.CONTR_PAF", "PA_ITEN.DT_ESTOQUE", "PA_ITEN.ATIVO", "PA_ITEN.QTDE_MIN",
                "PA_ITEN.DT_FAB", "PA_ITEN.DT_VAL", "PA_ITEN.COR_LINHA", "PA_ITEN.LOTE_QTDE", "PA_ITEN.LOTE_MIN", "PA_ITEN.LOTE_APANHADO", "PA_ITEN.COD_PROD_CLI", "PA_ITEN.COMPOSICAO2",
                "PA_ITEN.COMPOSICAO3", "PA_ITEN.COMPOSICAO4", "PA_ITEN.LANCAMENTO", "PA_ITEN.PRECO_MEDIO"],
            leftJoin: [
                { tabela: "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PA_ITEN.DEPOSITO" },
                { tabela: "CADCOR", "condicao": "CADCOR.COR = PA_ITEN.COR" },
                { tabela: "PRODUTO", "condicao": "PRODUTO.CODIGO = PA_ITEN.CODIGO" },
                { tabela: "FAIXA_ITEN", "condicao": "FAIXA_ITEN.FAIXA = PRODUTO.FAIXA AND FAIXA_ITEN.TAMANHO = PA_ITEN.TAM" },
            ],
            where: [`1=1 AND PA_ITEN.CODIGO = '${sCodigo}'`],
            orderBy: ["PA_ITEN.DEPOSITO", "PA_ITEN.TIPO", "FAIXA_ITEN.POSICAO"]
        };

        if (abaEstoqueDep) {
            PesquisaEstoque.camposSelect.push("DEPOSITO.EMPRESA", `(SELECT SUM(QTDE_EST_MIN) FROM QTDE_EST_MIN_001 TAB WHERE UDF_REPLACE(TAB.EMPRESA,'_','') = UDF_REPLACE(DEPOSITO.EMPRESA,'_','') 
                                               AND TAB.CODIGO = PA_ITEN.CODIGO AND TAB.COR = PA_ITEN.COR AND TAB.TAM = PA_ITEN.TAM) QTDE_MIN`);
        };

        if (sComEstoque) {
            PesquisaEstoque.where.push('PA_ITEN.QUANTIDADE > 0 ')
        };

        if (sDepositos != '' && sDepositos != null) {
            PesquisaEstoque.where.push(`PA_ITEN.DEPOSITO IN (${sDepositos})`)
        };


        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaEstoque));

        let tabela;

        if (abaEstoqueDep) {
            tabela = 'tabelaProdEstoqueDep';
        } else {
            tabela = 'tabelaProdEstoque';
        }

        let dataSetCols = [];

        if (abaEstoqueDep) {
            dataSetCols.push({
                'title': 'Empresa',
                'data': 'EMPRESA'
            });
        }

        dataSetCols.push({
            'title': 'Depósito',
            'data': 'DEPOSITO'
        })

        dataSetCols.push({
            'title': 'Ordem',
            'data': 'ORDEM'
        })
        dataSetCols.push({
            'title': 'Cor',
            'data': 'COR'
        })
        dataSetCols.push({
            'title': 'Desc Cor',
            'data': 'DESC_COR'

        })
        dataSetCols.push({
            'title': 'Tam',
            'data': 'TAM'
        })
        dataSetCols.push({
            'title': 'Quantidade',
            'data': 'QUANTIDADE'
        })
        dataSetCols.push({
            'title': 'Qtde Bruto',
            'data': 'QTDE_BRUTO'
        })
        dataSetCols.push({
            'title': 'Qtde Min',
            'data': 'QTDE_MIN',
        })
        dataSetCols.push({
            'title': 'Lançamento',
            'data': 'LANCAMENTO'
        })
        dataSetCols.push({
            'title': 'Desc Depósito',
            'data': 'DESC_DEPOSITO'
        })
        dataSetCols.push({
            'title': 'Lote',
            'data': 'LOTE'
        })
        dataSetCols.push({
            'title': 'Ativo',
            'data': 'ATIVO'
        })
        dataSetCols.push({
            'title': 'Barra',
            'data': 'BARRA'
        })
        dataSetCols.push({
            'title': 'Barra28',
            'data': 'BARRA28'
        })
        dataSetCols.push({
            'title': 'Percentual',
            'data': 'PERCENTUAL'
        })
        dataSetCols.push({
            'title': 'Romaneio',
            'data': 'ROMANEIO'
        })
        dataSetCols.push({
            'title': 'Tipo',
            'data': 'TIPO'
        })
        dataSetCols.push({
            'title': 'BarraCli',
            'data': 'BARRACLI'
        })
        dataSetCols.push({
            'title': 'Contr PAF',
            'data': 'CONTR_PAF'
        })
        dataSetCols.push({
            'title': 'Cod Prod Cli',
            'data': 'COD_PROD_CLI'
        })
        dataSetCols.push({
            'title': 'DT Fab',
            'data': 'DT_FAB'
        })
        dataSetCols.push({
            'title': 'DT Val',
            'data': 'DT_VAL'
        })
        dataSetCols.push({
            'title': 'Lote QTDE',
            'data': 'LOTE_QTDE',
        })
        dataSetCols.push({
            'title': 'Lote MIN',
            'data': 'LOTE_MIN'
        })
        dataSetCols.push({
            'title': 'Lote APANHADO',
            'data': 'LOTE_APANHADO'
        })
        dataSetCols.push({
            'title': 'Composição',
            'data': 'COMPOSICAO'
        })
        dataSetCols.push({
            'title': 'Composição 2',
            'data': 'COMPOSICAO2'
        })
        dataSetCols.push({
            'title': 'Composição 3',
            'data': 'COMPOSICAO3'
        })
        dataSetCols.push({
            'title': 'Composição 4',
            'data': 'COMPOSICAO4'
        })
        dataSetCols.push({
            'title': 'Cor Linha',
            'data': 'COR_LINHA'
        })
        dataSetCols.push({
            'title': 'Preço Médio',
            'data': 'PRECO_MEDIO'
        })

        $(`#${tabela}`).DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            scrollX: false,
            info: true,
            order: false,
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStr
        });
    };

});


